/*
            Endeavour Dynamic Data Exchange (DDE) Converters
 */

#ifndef EDVDDE_H
#define EDVDDE_H

#include <sys/types.h>
#include <glib.h>

/*
 *	Disk object dnd source widget data structure:
 */
typedef struct {

	/* Protocol (file, ftp, http, etc). */
	gchar *protocol;

	/* User and password. */
	gchar *user, *password;

	/* Host and port (port may be 0 to indicate default). */
	gchar *host;
	gint port;

	/* If object_type is EDV_DND_OBJECT_TYPE_DISK_OBJECT then
	 * this value is the full path to the disk object.
	 *
	 * If object_type is EDV_DND_OBJECT_TYPE_RECYCLED_OBJECT then
	 * this value is a string containing the index number of the
	 * recycled object.
	 */
	gchar *full_path;

} edv_dnd_object_struct;


extern edv_dnd_object_struct *EDVDNDObjectNew(void);
extern void EDVDNDObjectDelete(edv_dnd_object_struct *dnd_obj);

extern guint8 *EDVDNDObjectToBuffer(
	const edv_dnd_object_struct **dnd_object, gint total_dnd_objects,
	gint *buf_len
);
extern edv_dnd_object_struct **EDVDNDBufferToObject(
	const guint8 *buf, gint buf_len,
	gint *total_dnd_objects
);


#endif	/* EDVDDE_H */
