/*
                    Endeavour Find Object Procedures
 */

#ifndef EDVFIND_H
#define EDVFIND_H

#include <sys/stat.h>
#include <glib.h>


/* Archive object finding. */
extern gint EDVFindArchiveObjectByName(
        edv_core_struct *core_ptr,
        const gchar *arch_path, const gchar *expression,
        gbool case_sensitive,
        gpointer client_data,
        gint (*progress_cb)(const gchar *, gfloat, gpointer),
        void (*match_cb)(const gchar *, const struct stat *, gpointer)
);

/* Recycled object finding. */
extern gint EDVFindRecycledObjectByContent(
        const gchar *recycled_index_file, const gchar *expression,
        gbool case_sensitive,
        gpointer client_data,
        gint (*progress_cb)(const gchar *, gfloat, gpointer),
        void (*match_cb)(
                const gchar *, const struct stat *, const gchar *, gpointer
        )
);
extern gint EDVFindRecycledObjectByName(
        const gchar *recycled_index_file, const gchar *expression,
        gbool case_sensitive,
        gpointer client_data,
        gint (*progress_cb)(const gchar *, gfloat, gpointer),
        void (*match_cb)(const gchar *, const struct stat *, gpointer)
);

/* Disk object finding. */
extern gint EDVFindObjectByContent(
        const gchar *start_dir, const gchar *expression,
        gbool recursive, gbool case_sensitive,
        gpointer client_data,
        gint (*progress_cb)(const gchar *, gfloat, gpointer),
        void (*match_cb)(
                const gchar *, const struct stat *, const gchar *, gpointer
        )
);
extern gint EDVFindObjectByName(
	const gchar *start_dir, const gchar *expression,
        gbool recursive, gbool case_sensitive,
	gpointer client_data,
	gint (*progress_cb)(const gchar *, gfloat, gpointer),
	void (*match_cb)(const gchar *, const struct stat *, gpointer)
);




#endif	/* EDVFIND_H */
