/*
                   Endeavour Disk Object Operations

	See edvrecbinfop.h for recycle bin recovery and delete operations.
 */

#ifndef EDVFOP_H
#define EDVFOP_H

#include <gtk/gtk.h>
#include "endeavour.h"


extern const gchar *EDVFOPGetError();

extern gint EDVFOPCopy(
        edv_core_struct *core_ptr,
        const gchar *src_obj, const gchar *tar_obj,
        gchar **new_obj_rtn,            /* Dynamically allocated. */
        GtkWidget *toplevel,            /* Can be NULL. */
	gbool show_progress, gbool interactive,
        gbool *yes_to_all
);
extern gint EDVFOPMove(
        edv_core_struct *core_ptr,
        const gchar *src_obj, const gchar *tar_obj,
        gchar **new_obj_rtn,            /* Dynamically allocated. */
        GtkWidget *toplevel,            /* Can be NULL. */
	gbool show_progress, gbool interactive,
        gbool *yes_to_all
);
extern gint EDVFOPLink(
        edv_core_struct *core_ptr,
        const gchar *src_obj, const gchar *tar_obj,
        gchar **new_obj_rtn, GtkWidget *toplevel,
        gbool show_progress, gbool interactive,
        gbool *yes_to_all
);
extern gint EDVFOPRelink(
        edv_core_struct *core_ptr,
        const gchar *new_dest, const gchar *tar_obj,
        GtkWidget *toplevel,
        gbool show_progress, gbool interactive,
        gbool *yes_to_all
);
extern gint EDVFOPRename(
        edv_core_struct *core_ptr,
        const gchar *src_obj, const gchar *new_name,
        gchar **new_obj_rtn, GtkWidget *toplevel,
        gbool show_progress, gbool interactive,
        gbool *yes_to_all
);
extern gint EDVFOPChmod(
        edv_core_struct *core_ptr,
        const gchar *src_obj, guint permissions,
        GtkWidget *toplevel,
        gbool show_progress, gbool interactive,
        gbool *yes_to_all
);
extern gint EDVFOPChown(
        edv_core_struct *core_ptr,
        const gchar *src_obj, gint owner_id, gint group_id,
        GtkWidget *toplevel,
        gbool show_progress, gbool interactive,
        gbool *yes_to_all
);


#endif	/* EDVFOP_H */
