/*
                        Endeavour Procedures
 */

#ifndef EDVOP_H
#define EDVOP_H

#include <gtk/gtk.h>
#include "edvdde.h"
#include "browser.h"
#include "imbr.h"
#include "archiver.h"
#include "propwin.h"
#include "endeavour.h"


extern gint EDVDoWindowNexus(
        edv_core_struct *core_ptr,
        const gchar *name,              /* Name of window. */
        const gchar *path,              /* Initial object path. */
	const gchar *extra,
        GtkWidget *ref_toplevel
);

extern gint EDVDoNewBrowser(edv_core_struct *core_ptr);
extern gint EDVDoNewImbr(edv_core_struct *core_ptr);
extern gint EDVDoNewArchiverOpen(
	edv_core_struct *core_ptr, const gchar *path
);
extern gint EDVDoNewArchiver(edv_core_struct *core_ptr);
extern gint EDVDoPropWinAndSwitchPage(
	edv_core_struct *core_ptr, edv_object_struct *obj,
	GtkWidget *ref_toplevel, const gchar *tab_name
);
extern gint EDVDoPropWin(
	edv_core_struct *core_ptr, edv_object_struct *obj,
	GtkWidget *ref_toplevel
);

extern void EDVDoRunDeviceCheck(
        edv_core_struct *core_ptr, edv_device_struct *dev_ptr,
        GtkWidget *ref_toplevel
);
extern void EDVDoRunDeviceTools(
        edv_core_struct *core_ptr, edv_device_struct *dev_ptr,
        GtkWidget *ref_toplevel
);
extern void EDVDoRunDeviceFormat(
        edv_core_struct *core_ptr, edv_device_struct *dev_ptr,
        GtkWidget *ref_toplevel
);

extern void EDVDoRunTerminal(edv_core_struct *core_ptr, const gchar *cmd);

extern void EDVDoMapRecBinDeskIcon(edv_core_struct *core_ptr);
extern void EDVDoMapRecBin(edv_core_struct *core_ptr);

extern void EDVDoMapHistoryListWin(
	edv_core_struct *core_ptr, GtkWidget *rel_toplevel
);

extern void EDVDoMapOptionsWin(
        edv_core_struct *core_ptr, GtkWidget *rel_toplevel
);
extern void EDVDoMapCustomizeWin(
        edv_core_struct *core_ptr, GtkWidget *rel_toplevel
);
extern void EDVDoMapDevicesListWin(
	edv_core_struct *core_ptr, GtkWidget *rel_toplevel
);
extern void EDVDoMapMIMETypesListWin(
	edv_core_struct *core_ptr, GtkWidget *rel_toplevel
);

extern void EDVDoMapRunDlg(edv_core_struct *core_ptr);

extern void EDVDoMapBrowserFindWin(
	edv_core_struct *core_ptr, edv_browser_struct *browser
);
extern void EDVDoMapImbrFindWin(
        edv_core_struct *core_ptr, edv_imbr_struct *imbr
);
extern void EDVDoMapArchiverFindWin(
        edv_core_struct *core_ptr, edv_archiver_struct *archiver
);
extern void EDVDoMapRecBinFindWin(
        edv_core_struct *core_ptr, edv_recbin_struct *recbin
);

extern void EDVDoUpdateDevicesPUList(edv_core_struct *core_ptr);
extern void EDVDoUpdateMIMETypeHintIndexes(edv_core_struct *core_ptr);
extern void EDVDoUpdateOpenWithPUList(edv_core_struct *core_ptr);

extern void EDVDoSyncDisks(edv_core_struct *core_ptr);

extern void EDVDoInternetDownloadObject(
        edv_core_struct *core_ptr,
        edv_dnd_object_struct *dnd_obj,		/* Source. */
        const gchar *target_path,		/* Target. */
	GtkWidget *toplevel
);

extern void EDVDoHelp(
	edv_core_struct *core_ptr, const gchar *topic, GtkWidget *toplevel
);
extern void EDVDoHelpAbout(edv_core_struct *core_ptr, GtkWidget *toplevel);

extern void EDVDoRecycleBinSizeCheck(
        edv_core_struct *core_ptr, GtkWidget *toplevel
);


#endif	/* EDVOP_H */
