#include <glib.h>

#include "../include/disk.h"

#include "edvtypes.h"
#include "edvobj.h"
#include "edvrecbin.h"


/* Recycle bin utilities. */
gchar *EDVRecBinGetDirectoryFromIndexPath(const gchar *filename);

/* Recycled object functions. */
edv_recbin_object_struct *EDVRecBinObjectNew(void);
edv_recbin_object_struct *EDVRecBinObjectCopy(
	edv_recbin_object_struct *obj
);
void EDVRecBinObjectDelete(
	edv_recbin_object_struct *obj
);



/*
 *	Returns a dynamically allocated string containing the directory
 *	that contains the recycled objects parsed from the given file
 *	name of the recycled.ini index file.
 *
 *	The calling function needs to deallocate the returned value.
 */
gchar *EDVRecBinGetDirectoryFromIndexPath(const gchar *filename)
{
	const gchar *cstrptr;


	if(filename == NULL)
	    return(NULL);

	cstrptr = GetParentDir(filename);
	if(cstrptr == NULL)
	    return(NULL);
	else
	    return(g_strdup(cstrptr));
}

/*
 *	Creates a new recbin object structure.
 */
edv_recbin_object_struct *EDVRecBinObjectNew(void)
{
	edv_recbin_object_struct *obj = (edv_recbin_object_struct *)g_malloc0(
	    sizeof(edv_recbin_object_struct)
	);
	if(obj == NULL)
	    return(obj);

	obj->name = NULL;
	obj->original_path = NULL;
	obj->index = 0;
	obj->date_deleted = 0;

	obj->type = EDV_OBJECT_TYPE_FILE;
	obj->permissions = 0;
	obj->access_time = 0;
	obj->modify_time = 0;
	obj->change_time = 0;
	obj->owner_id = 0;
	obj->group_id = 0;
	obj->size = 0;

	return(obj);
}

/*
 *	Coppies the given recbin object and returns a new coppied recbin
 *	object.
 */
edv_recbin_object_struct *EDVRecBinObjectCopy(
        edv_recbin_object_struct *obj
)
{
	edv_recbin_object_struct *obj2;

	if(obj == NULL)
	    return(NULL);

	obj2 = EDVRecBinObjectNew();
	if(obj2 == NULL)
	    return(obj2);

        obj2->name = (obj->name != NULL) ?
	    g_strdup(obj->name) : NULL;
        obj2->original_path = (obj->original_path != NULL) ?
            g_strdup(obj->original_path) : NULL;
        obj2->index = obj->index;
        obj2->date_deleted = obj->date_deleted;

        obj2->type = obj->type;
        obj2->permissions = obj->permissions;
        obj2->access_time = obj->access_time;
        obj2->modify_time = obj->modify_time;
        obj2->change_time = obj->change_time;
        obj2->owner_id = obj->owner_id;
        obj2->group_id = obj->group_id;
        obj2->size = obj->size;

	return(obj2);
}

/*
 *	Deallocates all resources on the given recbin object and
 *	deallocates the recbin object structure itself.
 */
void EDVRecBinObjectDelete(
        edv_recbin_object_struct *obj
)
{
	if(obj == NULL)
	    return;


	g_free(obj->name);
	g_free(obj->original_path);

	g_free(obj);
}
