/*
                   Endeavour Find Objects Window

	Used for finding objects by name or grep'ing for a string
	contained within.
 */

#ifndef FINDWIN_H
#define FINDWIN_H

#include <gtk/gtk.h>
#include "edvtypes.h"
#include "edvstatusbar.h"


/*
 *	Find operation codes:
 */
#define EDV_FINDWIN_FIND_OBJECT_NAME		0
#define EDV_FINDWIN_FIND_OBJECT_CONTENT		1

/*
 *	Find role codes:
 */
#define EDV_FINDWIN_ROLE_DISK_OBJECT		0
#define EDV_FINDWIN_ROLE_RECYCLED_OBJECT	1
#define EDV_FINDWIN_ROLE_ARCHIVE_OBJECT		2

/*
 *	Maximum columns on the results clist:
 */
#define DEV_FINDWIN_RESULTS_LIST_COLUMNS_MAX	4

/*
 *	Find object window structure:
 */
typedef struct {

	gbool initialized;
	gbool map_state;
	gbool processing;
	gint busy_count;

	gpointer core_ptr;

	gint stop_count;

        gbool status_bar_map_state;

	GtkAccelGroup *accelgrp;
	GtkWidget	*toplevel,
			*main_vbox,

			*find_op_combo,
			*search_combo,
			*location_combo,

                        *case_sensitive_check,
                        *recursive_check,

			*search_btn, *stop_btn, *clear_btn, *close_btn,

			*results_clist,

			*open_btn, *open_with_btn, *goto_btn;

	/* Results clist right click menu. */
	GtkWidget	*results_clist_menu,
			*results_clist_open_mi,
                        *results_clist_open_with_mi,
                        *results_clist_goto_mi;

        /* Status bar. */
	edv_status_bar_struct *status_bar;

	/* Reference browser index number (only one may be non-negative). */
	gint browser_num;
	gint imbr_num;
	gint recbin_num;
	gint archiver_num;

	/* Find role code, one of EDV_FNIDWIN_ROLE_*. */
	gint role;

	/* Find operation code, one of EDV_FINDWIN_FIND_*. */
	gint find_op;

        /* Last known write protect state, can be -1 to indicate
         * undefined.
         */
	gint last_write_protect_state;

} edv_findwin_struct;



extern gchar *EDVFindWinCurrentSearch(edv_findwin_struct *fw);
extern void EDVFindWinSetSearch(
        edv_findwin_struct *fw, const gchar *s,
        gbool record_history
);

extern gchar *EDVFindWinCurrentLocation(edv_findwin_struct *fw);
extern void EDVFindWinSetLocation(
	edv_findwin_struct *fw, const gchar *path,
	gbool record_history
);

extern gint EDVFindWinCurrentFindOP(edv_findwin_struct *fw);

extern void EDVFindWinSetReferenceWindow(
	edv_findwin_struct *fw,
	gint browser_num, gint imbr_num, gint recbin_num,
	gint archive_num
);

extern void EDVFindWinListResetColumns(edv_findwin_struct *fw, gint op_code);
extern void EDVFindWinListAppend(
        edv_findwin_struct *fw,
        const gchar *path, const struct stat *lstat_buf,
	const gchar *excerpt
);
extern void EDVFindWinListClear(edv_findwin_struct *fw);

extern void EDVFindWinSyncConfiguration(edv_findwin_struct *fw);

extern edv_findwin_struct *EDVFindWinNew(gpointer core_ptr);
extern void EDVFindWinUpdateMenus(edv_findwin_struct *fw);
extern void EDVFindWinSetBusy(edv_findwin_struct *fw, gbool is_busy);
extern void EDVFindWinMap(edv_findwin_struct *fw);
extern void EDVFindWinUnmap(edv_findwin_struct *fw);
extern void EDVFindWinDelete(edv_findwin_struct *fw);


#endif	/* FINDWIN_H */
