#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
/* #include <gdk/gdkprivate.h> */

#include "../include/string.h"
#include "../include/fio.h"

#include "guiutils.h"
#include "cdialog.h"
#include "fb.h"
#include "progressdialog.h"

#include "edvtypes.h"
#include "edvdate.h"
#include "edvcfg.h"
#include "edvhistory.h"
#include "historywin.h"
#include "endeavour.h"
#include "edvcb.h"
#include "edvutils.h"
#include "edvutilsgtk.h"
#include "edvcfglist.h"
#include "config.h"

#include "images/icon_new_20x20.xpm"
#include "images/icon_copy_file_20x20.xpm"
#include "images/icon_move_file_20x20.xpm"
#include "images/icon_link2_20x20.xpm"
#include "images/icon_chmod_20x20.xpm"
#include "images/icon_owned_20x20.xpm"
#include "images/icon_planet_20x20.xpm"
#include "images/icon_cancel_20x20.xpm"
#include "images/icon_recover_20x20.xpm"
#include "images/icon_purge_20x20.xpm"
#include "images/icon_archive_add_20x20.xpm"
#include "images/icon_archive_extract_20x20.xpm"
#include "images/icon_reload_20x20.xpm"
#include "images/icon_clear_20x20.xpm"
#include "images/icon_save_20x20.xpm"
#include "images/icon_save_32x32.xpm"
#include "images/icon_close_20x20.xpm"
#include "images/icon_processes_48x48.xpm"


static gint EDVHistoryListProgressCB(
	gpointer data, gulong pos, gulong max
);

static gint EDVHistoryListWinDeleteEventCB(
        GtkWidget *widget, GdkEvent *event, gpointer data
);
static gint EDVHistoryListWinKeyEventCB(
        GtkWidget *widget, GdkEventKey *key, gpointer data
);
static gint EDVHistoryListWinButtonPressEventCB(
	GtkWidget *widget, GdkEventButton *button, gpointer data
);
static void EDVHistoryListWinSelectRowCB(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
        gpointer data
);
static void EDVHistoryListWinUnselectRowCB(
        GtkCList *clist, gint row, gint column, GdkEvent *event,
        gpointer data
);
static void EDVHistoryListWinFindCB(
        GtkWidget *widget, gpointer data
);
static void EDVHistoryListWinRefreshCB(
        GtkWidget *widget, gpointer data
);
static void EDVHistoryListWinSaveCB(
        GtkWidget *widget, gpointer data
);
static void EDVHistoryListWinClearCB(
        GtkWidget *widget, gpointer data
);
static void EDVHistoryListWinCloseCB(
        GtkWidget *widget, gpointer data
);

static gint EDVHistoryListWinSave(
	edv_history_listwin_struct *lw, const gchar *path,
	gbool append
);
static void EDVHistoryListWinUpdateDisplay(
	edv_history_listwin_struct *lw, edv_history_struct *h_ptr
);
void EDVHistoryListWinSetRow(
        edv_history_listwin_struct *lw,
	gint row, edv_history_struct *h_ptr
);
void EDVHistoryListWinFetchValues(
	edv_history_listwin_struct *lw
);

edv_history_listwin_struct *EDVHistoryListWinNew(
	gpointer core_ptr
);
void EDVHistoryListWinUpdateMenus(
        edv_history_listwin_struct *lw
);
void EDVHistoryListWinSetBusy(
        edv_history_listwin_struct *lw, gbool is_busy
);
void EDVHistoryListWinMap(
        edv_history_listwin_struct *lw
);
void EDVHistoryListWinUnmap(
        edv_history_listwin_struct *lw
);
void EDVHistoryListWinDelete(
	edv_history_listwin_struct *lw
);


#define LISTWIN_WIDTH	640
#define LISTWIN_HEIGHT	480

#define LISTWIN_BTN_WIDTH	(100 + (2 * 3))
#define LISTWIN_BTN_HEIGHT	(30 + (2 * 3))

#define LISTWIN_ARROW_WIDTH	20
#define LISTWIN_ARROW_HEIGHT	20

#define LISTWIN_TITLE	"History"


/*
 *	History list window save progress callback.
 */
static gint EDVHistoryListProgressCB(
        gpointer data, gulong pos, gulong max
)
{
	edv_history_listwin_struct *lw = (edv_history_listwin_struct *)data;
	if(lw == NULL)
	    return(-1);

        if(ProgressDialogIsQuery())
        {
	    if(ProgressDialogStopCount() > 0)
		return(-1);

	    if(max > 0)
	    {
		gfloat progress = (gfloat)pos / (gfloat)max;

		ProgressDialogUpdate(
		    NULL, NULL, NULL, NULL,
                    progress, EDV_DEF_PROGRESS_BAR_TICKS, TRUE
                );
            }
        }

	return(0);
}


/*
 *	History list window "delete_event" signal callback.
 */
static gint EDVHistoryListWinDeleteEventCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
)
{
	edv_history_listwin_struct *lw = (edv_history_listwin_struct *)data;
	if(lw == NULL)
	    return(TRUE);

	EDVHistoryListWinCloseCB(NULL, lw);

	return(TRUE);
}

/*
 *	History list window "key_press_event" signal callback.
 */
static gint EDVHistoryListWinKeyEventCB(
        GtkWidget *widget, GdkEventKey *key, gpointer data
)
{
        static gbool reenterent = FALSE;
        gint status = FALSE;
        gint etype;
        guint keyval, state;
        gbool press;
        edv_core_struct *core_ptr;
        GtkCList *clist;
        edv_history_listwin_struct *lw = (edv_history_listwin_struct *)data;
        if(lw == NULL)
            return(status);

        clist = (GtkCList *)lw->history_clist;
        if(clist == NULL)
            return(status);

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return(status);

        if(reenterent)
            return(status);
        else
            reenterent = TRUE;

        /* Get event type. */
        etype = key->type;

        /* Get other key event values. */
        press = (etype == GDK_KEY_PRESS) ? TRUE : FALSE;
        keyval = key->keyval;
        state = key->state;

/* Macro to emit a signal stop for a key press or release depending
 * on the current event's type.
 */
#define DO_STOP_KEY_SIGNAL_EMIT \
{ \
 gtk_signal_emit_stop_by_name( \
  GTK_OBJECT(widget), \
  press ? "key_press_event" : "key_release_event" \
 ); \
}

/* Macro to clamp the GtkAdjustment adj and emit a "value_changed"
 * signal.
 */
#define DO_ADJ_CLAMP_EMIT       \
{ \
 if(adj->value > (adj->upper - adj->page_size)) \
  adj->value = adj->upper - adj->page_size; \
\
 if(adj->value < adj->lower) \
  adj->value = adj->lower; \
\
 gtk_signal_emit_by_name( \
  GTK_OBJECT(adj), "value_changed" \
 ); \
}

/* Macro to clamp the GtkCList clist's focus_row. */
#define DO_CLIST_FOCUS_ROW_CLAMP        \
{ \
 if(clist->focus_row >= clist->rows) \
  clist->focus_row = clist->rows - 1; \
 if(clist->focus_row < 0) \
  clist->focus_row = 0; \
}

	if(1)
	{
            gint row;
	    GList *glist;
            GtkCList *clist = GTK_CLIST(widget);


            /* Get last selected row. */
	    row = EDVCListGetSelectedLast(clist, NULL);

            /* Handle by key value. */
            switch(keyval)
            {
#if 0
              case GDK_Return:
              case GDK_KP_Enter:
              case GDK_ISO_Enter:
              case GDK_3270_Enter:
                if(press)
                {
		    EDVHistoryListWinEditCB(NULL, lw);
		}
		DO_STOP_KEY_SIGNAL_EMIT
		status = TRUE;
                break;
#endif

#if 0
              case GDK_Delete:
                if(press)
                {
		    EDVHistoryListWinRemoveCB(NULL, lw);
                }
                DO_STOP_KEY_SIGNAL_EMIT
                status = TRUE;
                break;
#endif
              case GDK_space:
              case GDK_KP_Space:
                row = clist->focus_row;
                if((row >= 0) && (row < clist->rows) && press)
                {
                    gbool already_selected = FALSE;

                    /* Check if this row is already selected. */
                    glist = clist->selection;
                    while(glist != NULL)
                    {
                        if(row == (gint)glist->data)
                        {
                            already_selected = TRUE;
                            break;
                        }
                        glist = glist->next;
                    }

                    gtk_clist_freeze(clist);
                    if(already_selected)
                        gtk_clist_unselect_row(clist, row, 0);
                    else
                        gtk_clist_select_row(clist, row, 0);
                    gtk_clist_thaw(clist);
                }
                DO_STOP_KEY_SIGNAL_EMIT
                status = TRUE;
                break;

              case GDK_Up:
              case GDK_KP_Up:
                if(state & GDK_CONTROL_MASK)
                {
                    /* Get adjustment and scroll up. */
                    GtkAdjustment *adj = clist->vadjustment;
                    if((adj != NULL) && press)
                    {
                        gtk_clist_freeze(clist);
                        adj->value -= adj->step_increment;
                        DO_ADJ_CLAMP_EMIT
                        gtk_clist_thaw(clist);
                    }
                    DO_STOP_KEY_SIGNAL_EMIT
                    status = TRUE;
                }
                else
                {
                    if(press)
                    {
                        gint prev_focus_row = clist->focus_row;

                        gtk_clist_freeze(clist);
                        clist->focus_row--;
                        DO_CLIST_FOCUS_ROW_CLAMP

                        if(gtk_clist_row_is_visible(
                            clist, clist->focus_row) != GTK_VISIBILITY_FULL
                        )
                            gtk_clist_moveto(
                                clist,
                                clist->focus_row, -1,   /* Row, column. */
                                0.5, 0.0                /* Row, column. */
                            );

                        if(state & GDK_SHIFT_MASK)
                        {
                            gtk_clist_select_row(
                                clist, prev_focus_row, 0
                            );
                            gtk_clist_select_row(
                                clist, clist->focus_row, 0
                            );
                        }
                        gtk_clist_thaw(clist);
                    }
                    DO_STOP_KEY_SIGNAL_EMIT
                    status = TRUE;
                }
                break;

              case GDK_Down:
              case GDK_KP_Down:
                if(state & GDK_CONTROL_MASK)
                {
                    /* Get adjustment and scroll down. */
                    GtkAdjustment *adj = clist->vadjustment;
                    if((adj != NULL) && press)
                    {
                        gtk_clist_freeze(clist);
                        adj->value += adj->step_increment;
                        DO_ADJ_CLAMP_EMIT
                        gtk_clist_thaw(clist);
                    }
                    DO_STOP_KEY_SIGNAL_EMIT
                    status = TRUE;
                }
                else
                {
                    if(press)
                    {
                        gint prev_focus_row = clist->focus_row;

                        gtk_clist_freeze(clist);
                        clist->focus_row++;
                        DO_CLIST_FOCUS_ROW_CLAMP

                        if(gtk_clist_row_is_visible(
                            clist, clist->focus_row) != GTK_VISIBILITY_FULL
                        )
                            gtk_clist_moveto(
                                clist,
                                clist->focus_row, -1,   /* Row, column. */
                                0.5, 0.0                /* Row, column. */
			    );

                        if(state & GDK_SHIFT_MASK)
                        {
                            gtk_clist_select_row(
                                clist, prev_focus_row, 0
                            );
                            gtk_clist_select_row(
                                clist, clist->focus_row, 0
                            );
                        }
                        gtk_clist_thaw(clist);
                    }
                    DO_STOP_KEY_SIGNAL_EMIT
                    status = TRUE;
                }
		break;

              case GDK_Left:
              case GDK_KP_Left:
                if(1)
                {
                    /* Get adjustment and scroll left. */
                    GtkAdjustment *adj = clist->hadjustment;
                    if((adj != NULL) && press)
                    {
                        gtk_clist_freeze(clist);
                        if(state & GDK_CONTROL_MASK)
                            adj->value -= adj->step_increment * 4;
                        else if(state & GDK_SHIFT_MASK)
                            adj->value = adj->lower;
                        else
                            adj->value -= adj->step_increment;
                        DO_ADJ_CLAMP_EMIT
                        gtk_clist_thaw(clist);
                    }
                }
                DO_STOP_KEY_SIGNAL_EMIT
                status = TRUE;
                break;

              case GDK_Right:
              case GDK_KP_Right:
                if(1)
                {
                    /* Get adjustment and scroll right. */
                    GtkAdjustment *adj = clist->hadjustment;
                    if((adj != NULL) && press)
                    {
                        gtk_clist_freeze(clist);
                        if(state & GDK_CONTROL_MASK)
                            adj->value += adj->step_increment * 4;
                        else if(state & GDK_SHIFT_MASK)
                            adj->value = adj->upper - adj->page_size;
                        else
                            adj->value += adj->step_increment;
                        DO_ADJ_CLAMP_EMIT
                        gtk_clist_thaw(clist);
                    }
                }
                DO_STOP_KEY_SIGNAL_EMIT
                status = TRUE;
                break;

              case GDK_Page_Up:
              case GDK_KP_Page_Up:
                if(1)
                {
                    /* Get adjustment and scroll up one page. */
                    GtkAdjustment *adj = clist->vadjustment;
                    if((adj != NULL) && press)
                    {
                        gtk_clist_freeze(clist);
                        adj->value -= adj->page_increment;
                        DO_ADJ_CLAMP_EMIT
                        gtk_clist_thaw(clist);
                    }
                }
                DO_STOP_KEY_SIGNAL_EMIT
                status = TRUE;
                break;

              case GDK_Page_Down:
              case GDK_KP_Page_Down:
                if(1)
                {
                    /* Get adjustment and scroll down one page. */
                    GtkAdjustment *adj = clist->vadjustment;
                    if((adj != NULL) && press)
                    {
                        gtk_clist_freeze(clist);
                        adj->value += adj->page_increment;
                        DO_ADJ_CLAMP_EMIT
                        gtk_clist_thaw(clist);
                    }
                }
                DO_STOP_KEY_SIGNAL_EMIT
                status = TRUE;
                break;

              case GDK_Home:
              case GDK_KP_Home:
                if(1)
                {
                    /* Get adjustment and scroll all the way up. */
                    GtkAdjustment *adj = clist->vadjustment;
                    if((adj != NULL) && press)
                    {
                        gtk_clist_freeze(clist);
                        adj->value = adj->lower;
                        DO_ADJ_CLAMP_EMIT
                        gtk_clist_thaw(clist);
                    }
                }
                DO_STOP_KEY_SIGNAL_EMIT
                status = TRUE;
                break;

              case GDK_End:
              case GDK_KP_End:
                if(1)
                {
                    /* Get adjustment and scroll all the way down. */
                    GtkAdjustment *adj = clist->vadjustment;
                    if((adj != NULL) && press)
                    {
                        gtk_clist_freeze(clist);
                        adj->value = adj->upper - adj->page_size;
                        DO_ADJ_CLAMP_EMIT
                        gtk_clist_thaw(clist);
                    }
                }
                DO_STOP_KEY_SIGNAL_EMIT
                status = TRUE;
                break;

            }
	}

#undef DO_CLIST_FOCUS_ROW_CLAMP
#undef DO_ADJ_CLAMP_EMIT
#undef DO_STOP_KEY_SIGNAL_EMIT

	reenterent = FALSE;
	return(status);
}

/*
 *	History list window "button_press_event" signal callback.
 */
static gint EDVHistoryListWinButtonPressEventCB(
        GtkWidget *widget, GdkEventButton *button, gpointer data
)
{
        static gbool reenterent = FALSE;
        gint etype;
        edv_core_struct *core_ptr;
        GtkCList *clist;
        edv_history_listwin_struct *lw = (edv_history_listwin_struct *)data;
        if(lw == NULL)
            return(TRUE);

        clist = (GtkCList *)lw->history_clist;
        if(clist == NULL)
            return(TRUE);

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return(TRUE);

        if(reenterent)
            return(TRUE);
        else
            reenterent = TRUE;

	if(clist->clist_window != ((GdkEventAny *)button)->window)
	{
	    reenterent = FALSE;
	    return(TRUE);
	}

        /* Get event type. */
        etype = button->type;

        if(1)
        {
            gint row, column;
            GtkWidget *w;


            /* Find row and column based on given coordinates. */
            if(!gtk_clist_get_selection_info(
                clist, button->x, button->y, &row, &column
            ))
            {
                row = -1;
                column = 0;
            }

            /* Handle by event type. */
            switch(etype)
            {
#if 0
              case GDK_2BUTTON_PRESS:
                /* Handle by button number. */
                switch(button->button)
                {
                  case 1:
		    EDVHistoryListWinEditCB(NULL, lw);
		    break;
		}
		break;
#endif

              case GDK_BUTTON_PRESS:
                /* Handle by button number. */
                switch(button->button)
                {
                  case 3:
		    /* Select row before mapping menu? */
                    if(EDVCFGItemListGetValueI(
                        core_ptr->cfg_list, EDV_CFG_PARM_RIGHT_CLICK_MENU_SELECTS
                    ) && (row >= 0) && (row < clist->rows))
                    {
			gtk_clist_freeze(clist);
			gtk_clist_select_row(clist, row, column);
			gtk_clist_thaw(clist);
		    }

                    /* Get right click menu widget and map it. */
                    w = lw->menu;
                    if(w != NULL)
                        gtk_menu_popup(
                            GTK_MENU(w), NULL, NULL,
                            NULL, NULL,
                            button->button, button->time
                        );
                    break;
                }
                break;
            }
        }


        reenterent = FALSE;

	return(TRUE);
}

/*
 *	History list window "select_row" signal callback.
 */
static void EDVHistoryListWinSelectRowCB(
        GtkCList *clist, gint row, gint column, GdkEvent *event,
        gpointer data
)
{
        static gbool reenterent = FALSE;
	edv_core_struct *core_ptr;
        edv_history_listwin_struct *lw = (edv_history_listwin_struct *)data;
        if(lw == NULL)
            return;

	core_ptr = (edv_core_struct *)lw->core_ptr;
	if(core_ptr == NULL)
	    return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;

	/* Check which clist this event is for. */
	if(GTK_WIDGET(clist) == lw->history_clist)
	{
	    /* Check if selected row is fully visible, if not then
	     * adjust scroll position to try and make it visible.
	     */
	    if(gtk_clist_row_is_visible(clist, row) !=
		GTK_VISIBILITY_FULL
	    )
		gtk_clist_moveto(
		    clist,
		    row, -1,	/* Row, column. */
		    0.5, 0.0	/* Row, column. */
		);

	    /* Update displayed history. */
            if((row >= 0) && (row < core_ptr->total_history_events))
                EDVHistoryListWinUpdateDisplay(
                    lw,  core_ptr->history_event[row]
                );

	    EDVHistoryListWinUpdateMenus(lw);
	}

        reenterent = FALSE;
}

/*
 *	History list window "unselect_row" signal callback.
 */
static void EDVHistoryListWinUnselectRowCB(
        GtkCList *clist, gint row, gint column, GdkEvent *event,
        gpointer data
)
{
        static gbool reenterent = FALSE;
        edv_core_struct *core_ptr;
        edv_history_listwin_struct *lw = (edv_history_listwin_struct *)data;
        if(lw == NULL)
            return;

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;

        /* Check which clist this event is for. */
        if(GTK_WIDGET(clist) == lw->history_clist)
        {
	    EDVHistoryListWinUpdateDisplay(lw, NULL);
            EDVHistoryListWinUpdateMenus(lw);
        }

        reenterent = FALSE;
}

/*
 *	History find entry "activate" signal callback.
 */
static void EDVHistoryListWinFindCB(
        GtkWidget *widget, gpointer data
)
{
        static gbool reenterent = FALSE;
	gint find_itterations = 0;
	gint row, column, sel_row;
	const gchar *find_str;
	GtkEntry *entry;
        GtkCList *clist;

        gchar *cell_text;
        guint8 spacing;
        GdkPixmap *pixmap;
        GdkBitmap *mask;

        edv_history_listwin_struct *lw = (edv_history_listwin_struct *)data;
        if(lw == NULL)
            return;

	entry = (GtkEntry *)lw->find_entry;
	if(entry == NULL)
	    return;

        clist = (GtkCList *)lw->history_clist;
        if(clist == NULL)
            return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;


	/* Get string to match for from entry. */
        find_str = gtk_entry_get_text(entry);
        if(find_str == NULL)
	{
	    reenterent = FALSE;
            return;
	}
	if(*find_str == '\0')
	{
            reenterent = FALSE;
            return;
        }

	/* Get selected row + 1 or 0 if none. */
	sel_row = EDVCListGetSelectedLast(clist, NULL);
	if(sel_row < 0)
            sel_row = 0;
	else
	    sel_row++;

	/* Iterate through rows, checking each Type column to see if
	 * therer is any partial patches.
	 */
	do
	{
	    /* Iterate from selected row to end. */
	    for(row = sel_row; row < clist->rows; row++)
	    {
		/* Iterate through all cells on this row. */
		for(column = 0; column < clist->columns; column++)
		{
		    /* Begin fetching current cell's text by its type. */
		    cell_text = NULL;
		    switch((gint)gtk_clist_get_cell_type(clist, row, column))
		    {
		      case GTK_CELL_TEXT:
			gtk_clist_get_text(clist, row, column, &cell_text);
			break;

		      case GTK_CELL_PIXTEXT:
			gtk_clist_get_pixtext(
			    clist, row, column, &cell_text,
			    &spacing, &pixmap, &mask
			);
			break;
		    }
		    /* Got cell text? */
		    if(cell_text != NULL)
		    {
			/* Find string found inside cell text string? */
			if(strcasestr(cell_text, find_str))
			    break;
		    }
		}
                /* If column itteration broke before all columns were
                 * iterated through then that implies a match was made.
                 */
                if(column < clist->columns)
                    break;
            }
	    /* Got match? */
            if(row < clist->rows)
		break;
	    else
		find_itterations++;

	    /* Reset sel_row to 0 so that find starts at beginning. */
	    sel_row = 0;

	} while(find_itterations < 2);

	/* Got match? */
	if(row < clist->rows)
	{
	    /* Select new matched row. */
	    gtk_clist_unselect_all(clist);
	    gtk_clist_select_row(clist, row, 0);
	}

        reenterent = FALSE;
}

/*
 *	History refresh button callback.
 */
static void EDVHistoryListWinRefreshCB(
        GtkWidget *widget, gpointer data
)
{
        static gbool reenterent = FALSE;
        edv_history_listwin_struct *lw = (edv_history_listwin_struct *)data;
        if(lw == NULL)
            return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;

	EDVHistoryListWinSetBusy(lw, TRUE);
	EDVHistoryListWinFetchValues(lw);
	EDVHistoryListWinUpdateMenus(lw);
	EDVHistoryListWinSetBusy(lw, FALSE);

        reenterent = FALSE;
}

/*
 *	History list window save button callback.
 */
static void EDVHistoryListWinSaveCB(
        GtkWidget *widget, gpointer data
)
{
        static gbool reenterent = FALSE;
        gbool status;
        fb_type_struct **ftype = NULL, *ftype_rtn = NULL;
        gint total_ftypes = 0;
        gchar **path_rtn = NULL;
        gint total_path_rtns = 0;
	GtkWidget *toplevel;
	edv_core_struct *core_ptr;
        edv_history_listwin_struct *lw = (edv_history_listwin_struct *)data;
        if(lw == NULL)
            return;

	if(FileBrowserIsQuery())
	    return;

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;


	toplevel = lw->toplevel;

        EDVHistoryListWinSetBusy(lw, TRUE);


	/* Create file types list, the list of formats that we can
	 * save to.
	 */
        FileBrowserTypeListNew(
            &ftype, &total_ftypes,
            ".txt", "Text files"
        );

        /* Query user for file to save to. */
        FileBrowserSetTransientFor(toplevel);
        status = FileBrowserGetResponse(
            "Save History",
            "Save", "Cancel",
            NULL,               /* Use last path. */
            ftype, total_ftypes,
            &path_rtn, &total_path_rtns,
            &ftype_rtn
        );
        FileBrowserSetTransientFor(NULL);

        /* Got user response? */
        if(status)
        {
            const gchar *new_path = (total_path_rtns > 0) ?
                path_rtn[0] : NULL;
            const gchar *ftype_ext = (ftype_rtn != NULL) ?
                ftype_rtn->ext : NULL;

            while(((new_path != NULL) ? (*new_path != '\0') : FALSE) &&
                   (ftype_ext != NULL)
            )
            {
                gbool object_exists = FALSE;
                gchar *buf;
                struct stat stat_buf, lstat_buf;


                /* File already exists? */
                if(!stat(new_path, &stat_buf))
                {
                    gbool need_break = FALSE;
                    gint status2;
                    gchar *buf2 = g_strdup_printf(
"Overwrite:\n\
\n\
    %s\n",
                        new_path
                    );

                    CDialogSetTransientFor(toplevel);
                    status2 = CDialogGetResponse(
                        "Confirm Overwrite",
                        buf2,
                        NULL,
                        CDIALOG_ICON_WARNING,
                        CDIALOG_BTNFLAG_YES | CDIALOG_BTNFLAG_NO,
                        CDIALOG_BTNFLAG_NO
                    );
                    CDialogSetTransientFor(NULL);

                    g_free(buf2);

                    switch(status2)
                    {
                      case CDIALOG_RESPONSE_YES:
                      case CDIALOG_RESPONSE_YES_TO_ALL:
                      case CDIALOG_RESPONSE_OK:
                        break;

                      default:
                        need_break = TRUE;
                        break;
                    }

		    /* Mark that the object we are saving to currently
		     * exists.
                     */
                    object_exists = TRUE;

                    if(need_break)
                        break;
                }


		/* Format progress dialog message. */
		buf = g_strdup_printf(
"Saving history to file:\n\
\n\
    %s\n",
                    new_path
                );

                /* Map progress dialog. */
                ProgressDialogSetTransientFor(toplevel);
                ProgressDialogMap(
                    "Saving History",
                    buf,
                    (const u_int8_t **)icon_save_32x32_xpm,
                    "Stop"
                );

                g_free(buf);

		/* Begin saving history using a format based on the
		 * selected extension.
		 */
/*		if(!strcmp(ftype_ext, ".txt")) */
		if(1)
                {
		    EDVHistoryListWinSave(lw, new_path, TRUE);
                }

                /* Notify Endeavour's resources about the save. */
                if(object_exists)
                {
                    if(!lstat(new_path, &lstat_buf))
                        EDVObjectModifiedEmit(
                            core_ptr, new_path, new_path, &lstat_buf
                        );
                }
                else
                {
                    if(!lstat(new_path, &lstat_buf))
                        EDVObjectAddedEmit(
                            core_ptr, new_path, &lstat_buf
                        );
                }

		break;	/* Break since this level is one big while() loop. */
            }
	}	/* Got user response? */

	/* Deallocate file types list. */
	FileBrowserDeleteTypeList(ftype, total_ftypes);
	ftype = NULL;
	total_ftypes = 0;

        EDVHistoryListWinUpdateMenus(lw);

        EDVHistoryListWinSetBusy(lw, FALSE);

	/* Unmap progress dialog, it may have been mapped in the above
	 * operation.
	 */
	ProgressDialogBreakQuery(TRUE);
	ProgressDialogSetTransientFor(NULL);

        reenterent = FALSE;
}

/*
 *	History list window clear callback.
 */
static void EDVHistoryListWinClearCB(
        GtkWidget *widget, gpointer data
)
{
        static gbool reenterent = FALSE;
	gint i;
	edv_core_struct *core_ptr;
        edv_history_listwin_struct *lw = (edv_history_listwin_struct *)data;
        if(lw == NULL)
            return;

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;

        EDVHistoryListWinSetBusy(lw, TRUE);

	/* Deallocate all history events on the core structure. */
	for(i = 0; i < core_ptr->total_history_events; i++)
	    EDVHistoryDelete(core_ptr->history_event[i]);
	g_free(core_ptr->history_event);
	core_ptr->history_event = NULL;
	core_ptr->total_history_events = 0;

	/* Refresh history listing. */
	EDVHistoryListWinFetchValues(lw);

        EDVHistoryListWinUpdateMenus(lw);

        EDVHistoryListWinSetBusy(lw, FALSE);

        reenterent = FALSE;
}

/*
 *	History list window close button callback.
 */
static void EDVHistoryListWinCloseCB(
	GtkWidget *widget, gpointer data
)
{
        edv_history_listwin_struct *lw = (edv_history_listwin_struct *)data;
        if(lw == NULL)
            return;

	EDVHistoryListWinUnmap(lw);
}


/*
 *	Writes the information contained in the history list to the
 *	file specified by path. If append is TRUE then the information
 *	will be appended.
 */
static gint EDVHistoryListWinSave(
        edv_history_listwin_struct *lw, const gchar *path,
        gbool append
)
{
	gint row, column;
	FILE *fp;
	GtkCList *clist;

	if((lw == NULL) || (path == NULL))
	    return(-1);

	clist = (GtkCList *)lw->history_clist;
	if(clist == NULL)
	    return(-1);

	/* Open file. */
	if(append)
	    fp = FOpen(path, "ab");
	else
	    fp = FOpen(path, "wb");
	if(fp == NULL)
	    return(-1);

	/* Iterate through each row, saving the the information of
	 * each cell on each row.
	 */
	for(row = 0; row < clist->rows; row++)
	{
	    if(EDVHistoryListProgressCB(lw, row, clist->rows))
		break;

	    for(column = 0; column < clist->columns; column++)
	    {
		gchar *text = NULL;
		guint8 spacing;
		GdkPixmap *pixmap;
		GdkBitmap *mask;


		switch((gint)gtk_clist_get_cell_type(clist, row, column))
		{
		  case GTK_CELL_PIXTEXT:
		    gtk_clist_get_pixtext(
			clist, row, column, &text, &spacing,
			&pixmap, &mask
		    );
		    break;

		  case GTK_CELL_TEXT:
		    gtk_clist_get_text(
			clist, row, column, &text
		    );
		    break;
		}
		if(text != NULL)
		{
		    fputs(text, fp);
		    fputc('\t', fp);
		}
	    }
	    fputc('\n', fp);
	}

	/* Close file. */
	FClose(fp);

	EDVHistoryListProgressCB(lw, clist->rows, clist->rows);

	return(0);
}

/*
 *	Updates the displayed history event on the given list window.
 *
 *	This will destroy the display_client widget and create a
 *	new one if h_ptr is not NULL.
 */
static void EDVHistoryListWinUpdateDisplay(
        edv_history_listwin_struct *lw, edv_history_struct *h_ptr
)
{
#if 0
	gint border_major = 5, border_minor = 2;
	GtkWidget *w, *parent, *parent2, *parent3;


	if(lw == NULL)
	    return;

	/* Get previous display client GtkVBox and destroy it. */
	w = lw->display_client;
	if(w != NULL)
	{
	    gtk_widget_destroy(w);
	    lw->display_client = w = NULL;
	}

	/* Get parent. */
	parent = lw->display_parent;
	if(parent == NULL)
	    return;

	/* Stop updating at this point if the given history structure
	 * is NULL.
	 */
	if(h_ptr == NULL)
	    return;

	/* Create new client vbox. */
	lw->display_client = w = gtk_vbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent2 = w;


	if(1)
	{
	    const gchar *class_str = NULL;

	    /* Hbox for class heading. */
	    w = gtk_hbox_new(FALSE, border_minor);
	    gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	    gtk_widget_show(w);
	    parent3 = w;

	    switch(h_ptr->mt_class)
	    {
	      case EDV_MIMETYPE_CLASS_SYSTEM:
		class_str = "System Object Type";
		break;

	      case EDV_MIMETYPE_CLASS_FORMAT:
		class_str = "File Format";
		break;

	      case EDV_MIMETYPE_CLASS_PROGRAM:
		class_str = "Application";
		break;

              case EDV_MIMETYPE_CLASS_UNIQUE:
                class_str = "Unique Object";
                break;
	    }
	    w = gtk_label_new(
		(class_str != NULL) ? class_str : "*Unknown Class*"
            );
            gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
            gtk_widget_show(w);
	}


	/* HBox for icon and type line. */
	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent3 = w;

	/* Create icon? */
	if(1)
	{
	    GdkPixmap *pixmap;
	    GdkBitmap *mask;

	    /* First try to get large sized pixmap, use standard state
	     * always.
	     */
	    pixmap = h_ptr->large_pixmap[EDV_MIMETYPE_ICON_STATE_STANDARD];
	    mask = h_ptr->large_mask[EDV_MIMETYPE_ICON_STATE_STANDARD];
	    /* No large? Then try medium. */
	    if(pixmap == NULL)
	    {
                pixmap = h_ptr->medium_pixmap[EDV_MIMETYPE_ICON_STATE_STANDARD];
                mask = h_ptr->medium_mask[EDV_MIMETYPE_ICON_STATE_STANDARD];
	    }
            /* No medium? Then try small. */
            if(pixmap == NULL)
            {
                pixmap = h_ptr->small_pixmap[EDV_MIMETYPE_ICON_STATE_STANDARD];
                mask = h_ptr->small_mask[EDV_MIMETYPE_ICON_STATE_STANDARD];
            }

	    /* Got pixmap and mask pair? */
	    if(pixmap != NULL)
	    {
		w = gtk_pixmap_new(pixmap, mask);
		gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
		gtk_widget_show(w);
	    }
	}
	/* Type label. */
	w = gtk_label_new(
	    (h_ptr->type != NULL) ? h_ptr->type : "(null)"
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);


        /* HBox for value line. */
        w = gtk_hbox_new(FALSE, border_minor);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent3 = w;

        /* Value label. */
        w = gtk_label_new("Value:");
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        /* Label. */
        w = gtk_label_new(
            (h_ptr->value != NULL) ? h_ptr->value : "*none*"
        );
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);


	/* Description available? */
	if(h_ptr->description != NULL)
	{
            /* HBox for description line. */
            w = gtk_hbox_new(FALSE, border_minor);
            gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
            gtk_widget_show(w);
            parent3 = w;

            /* Description label. */
            w = gtk_label_new(h_ptr->description);
	    gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	    gtk_widget_show(w);
	}

#endif
}


/*
 *	Sets the row on the MIME Types clist on the given list window to the
 *	values specified by the given MIME Type structure.
 */
void EDVHistoryListWinSetRow(
	edv_history_listwin_struct *lw, gint row, edv_history_struct *h_ptr
)
{
        GtkCList *clist;
	gint date_relativity;
	const gchar *date_format;
        edv_core_struct *core_ptr;
	const gchar *type_name = "Unknown";
	GdkPixmap *pixmap = NULL;
	GdkBitmap *mask = NULL;


	if((lw == NULL) || (h_ptr == NULL))
	    return;

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return;

        clist = (GtkCList *)lw->history_clist;
        if(clist == NULL)
            return;

	date_relativity = EDVCFGItemListGetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_DATE_RELATIVITY
        );
        date_format = EDVCFGItemListGetValueS(
            core_ptr->cfg_list, EDV_CFG_PARM_DATE_FORMAT
        );


	/* Get pixmap and mask to represent history type. */
	switch(h_ptr->type)
	{
	  case EDV_HISTORY_DISK_OBJECT_CREATE:
            type_name = "Create";
	    pixmap = lw->object_create_pixmap;
	    mask = lw->object_create_mask;
	    break;

          case EDV_HISTORY_DISK_OBJECT_COPY:
            type_name = "Copy";
            pixmap = lw->object_copy_pixmap;
            mask = lw->object_copy_mask;
            break;

          case EDV_HISTORY_DISK_OBJECT_MOVE:
            type_name = "Move";
            pixmap = lw->object_move_pixmap;
            mask = lw->object_move_mask;
            break;

          case EDV_HISTORY_DISK_OBJECT_LINK:
            type_name = "Link";
            pixmap = lw->object_link_pixmap;
            mask = lw->object_link_mask;
            break;

          case EDV_HISTORY_DISK_OBJECT_CHOWN:
            type_name = "Chown";
            pixmap = lw->object_chown_pixmap;
            mask = lw->object_chown_mask;
            break;

          case EDV_HISTORY_DISK_OBJECT_CHMOD:
            type_name = "CHMod";
            pixmap = lw->object_chmod_pixmap;
            mask = lw->object_chmod_mask;
            break;

          case EDV_HISTORY_DISK_OBJECT_DOWNLOAD:
            type_name = "Download";
            pixmap = lw->object_download_pixmap;
            mask = lw->object_download_mask;
            break;

          case EDV_HISTORY_DISK_OBJECT_DELETE:
            type_name = "Delete";
            pixmap = lw->object_delete_pixmap;
            mask = lw->object_delete_mask;
            break;

          case EDV_HISTORY_RECYCLED_OBJECT_RECOVER:
            type_name = "Recover";
            pixmap = lw->recobj_recover_pixmap;
            mask = lw->recobj_recover_mask;
            break;

          case EDV_HISTORY_RECYCLED_OBJECT_PURGE:
            type_name = "Purge";
            pixmap = lw->recobj_purge_pixmap;
            mask = lw->recobj_purge_mask;
            break;

          case EDV_HISTORY_RECYCLED_OBJECT_PURGE_ALL:
            type_name = "Purge All";
            pixmap = lw->recobj_purge_pixmap;
            mask = lw->recobj_purge_mask;
            break;

          case EDV_HISTORY_ARCHIVE_OBJECT_ADD:
            type_name = "Archive Add";
            pixmap = lw->arcobj_add_pixmap;
            mask = lw->arcobj_add_mask;
            break;

          case EDV_HISTORY_ARCHIVE_OBJECT_EXTRACT:
            type_name = "Archive Extract";
            pixmap = lw->arcobj_extract_pixmap;
            mask = lw->arcobj_extract_mask;
            break;

          case EDV_HISTORY_ARCHIVE_OBJECT_DELETE:
            type_name = "Archive Delete";
            pixmap = lw->arcobj_delete_pixmap;
            mask = lw->arcobj_delete_mask;
            break;
	}


	/* Given row index in bounds? */
	if((row >= 0) && (row < clist->rows))
	{
	    /* Set column 0 as MIME Type type. */
	    if(clist->columns > 0)
	    {
		if(pixmap != NULL)
		    gtk_clist_set_pixtext(
			clist, row, 0,
			type_name,
			EDV_LIST_PIXMAP_TEXT_SPACING,
			pixmap, mask
		    );
		else
		    gtk_clist_set_text(
                        clist, row, 0,
                        type_name
                    );
	    }
            /* Set column 1 as source value. */
            if(clist->columns > 1)
            {
		gtk_clist_set_text(
		    clist, row, 1,
		    (h_ptr->src_path != NULL) ? h_ptr->src_path : ""
		);
            }
            /* Set column 2 as target value. */
            if(clist->columns > 2)
            {
                gtk_clist_set_text(
                    clist, row, 2,
                    (h_ptr->tar_path != NULL) ? h_ptr->tar_path : ""
                );
            }
            /* Set column 3 as status value. */
            if(clist->columns > 3)
            {
		GtkStyle *style = NULL;
		const gchar *status_str = "Unknown Error";
		switch(h_ptr->status)
		{
		  case 0:
		    status_str = "Success";
		    style = lw->cell_style[EDV_HISTORY_CELL_STYLE_SUCCESS];
		    break;

		  case -1:
                    status_str = "Error";
                    style = lw->cell_style[EDV_HISTORY_CELL_STYLE_ERROR];
                    break;

                  case -2:
                    status_str = "Ambiguous/BadValue";
                    style = lw->cell_style[EDV_HISTORY_CELL_STYLE_ERROR];
                    break;

                  case -3:
                    status_str = "System Error";
                    style = lw->cell_style[EDV_HISTORY_CELL_STYLE_ERROR];
                    break;

                  case -4:
                    status_str = "User Aborted";
                    style = lw->cell_style[EDV_HISTORY_CELL_STYLE_CANCEL];
                    break;

                  case -5:
                    status_str = "User Cancel/No";
                    style = lw->cell_style[EDV_HISTORY_CELL_STYLE_CANCEL];
                    break;

                  case -6:
                    status_str = "Operation Re-Entry";
                    style = lw->cell_style[EDV_HISTORY_CELL_STYLE_ERROR];
                    break;
		}
                gtk_clist_set_text(
                    clist, row, 3, status_str
                );
		if(style != NULL)
		    gtk_clist_set_cell_style(clist, row, 3, style);
            }
            /* Set column 4 as start time. */
            if(clist->columns > 4)
            {
		const gchar *cstrptr = EDVDateFormatString(
		    h_ptr->time_start, date_format, date_relativity
		);
		if(cstrptr != NULL)
		    gtk_clist_set_text(clist, row, 4, cstrptr);
	    }
            /* Set column 5 as end time. */
            if(clist->columns > 5)
            {
                const gchar *cstrptr = EDVDateFormatString(
                    h_ptr->time_end, date_format, date_relativity
                );
                if(cstrptr != NULL)
                    gtk_clist_set_text(clist, row, 5, cstrptr);
            }


	}
}

/*
 *	Regets list of history events from the core structure on the
 *	given list window.
 */
void EDVHistoryListWinFetchValues(
        edv_history_listwin_struct *lw
)
{
	gint i, row;
	gchar **strv;
	GtkCList *clist;
	edv_core_struct *core_ptr;
	edv_history_struct *h_ptr;


	if(lw == NULL)
	    return;

	core_ptr = (edv_core_struct *)lw->core_ptr;
	if(core_ptr == NULL)
	    return;

	clist = (GtkCList *)lw->history_clist;
	if(clist == NULL)
	    return;


	/* Allocate values list for one row. */
	strv = (gchar **)g_malloc(clist->columns * sizeof(gchar *));
	if(strv != NULL)
	{
	    for(i = 0; i < clist->columns; i++)
		strv[i] = g_strdup("");
	}


	/* Begin updating MIME Types clist. */

	gtk_clist_freeze(clist);

	/* Remove existing rows on clist. */
	gtk_clist_clear(clist);

	/* Iterate through all history events on the core structure. */
	for(i = 0; i < core_ptr->total_history_events; i++)
	{
	    h_ptr = core_ptr->history_event[i];
	    if(h_ptr == NULL)
		continue;

	    /* Append a new clist row. */
	    row = gtk_clist_append(
		clist, strv
	    );

	    /* Set new clist row values with the current history event
	     * structure's values.
	     */
	    EDVHistoryListWinSetRow(
		lw, row, h_ptr
	    );
	}

	gtk_clist_thaw(clist);


        /* Deallocate valies array for clist row. */
	if(strv != NULL)
	{
            for(i = 0; i < clist->columns; i++)
                g_free(strv[i]);

	    g_free(strv);
	    strv = NULL;
        }


        EDVHistoryListWinUpdateMenus(lw);
}


/*
 *	Creates a new history list window.
 */
edv_history_listwin_struct *EDVHistoryListWinNew(
        gpointer core_ptr
)
{
        gint /* border_minor = 2, */ border_major = 5;
	gchar *heading[6];
        gpointer mclient_data;
	gpointer entry_rtn;
	GdkColormap *colormap = NULL;
        GdkWindow *window;
        GtkAccelGroup *accelgrp;
	GtkStyle *style, *src_style;
        GtkWidget *w, *fw, *menu;
	GtkWidget *parent, *parent2;
	GtkEntry *entry;
	GtkCList *clist;
        edv_history_listwin_struct *lw = (edv_history_listwin_struct *)g_malloc0(
            sizeof(edv_history_listwin_struct)
        );
        if(lw == NULL)
            return(lw);


        /* Reset values. */
        lw->initialized = TRUE;
        lw->map_state = FALSE;
	lw->busy_count = 0;
        lw->core_ptr = core_ptr;


        /* Keyboard accelerator group. */
        lw->accelgrp = accelgrp = gtk_accel_group_new();


        /* Toplevel. */
        lw->toplevel = w = gtk_window_new(GTK_WINDOW_DIALOG);
        gtk_widget_set_usize(w, LISTWIN_WIDTH, LISTWIN_HEIGHT);
        gtk_widget_realize(w);
        gtk_window_set_title(GTK_WINDOW(w), LISTWIN_TITLE);
	style = gtk_widget_get_style(w);
        window = w->window;
        if(window != NULL)
        {
            gdk_window_set_decorations(
                window,
                GDK_DECOR_TITLE | GDK_DECOR_MENU | GDK_DECOR_MINIMIZE
            );
            gdk_window_set_functions(
                window,
                GDK_FUNC_MOVE | GDK_FUNC_MINIMIZE | GDK_FUNC_CLOSE
            );
            colormap = gdk_window_get_colormap(window);
            GUISetWMIcon(window, (u_int8_t **)icon_processes_48x48_xpm);
        }
        gtk_signal_connect(
            GTK_OBJECT(w), "delete_event",
            GTK_SIGNAL_FUNC(EDVHistoryListWinDeleteEventCB), lw
        );
        gtk_container_border_width(GTK_CONTAINER(w), 0);
        gtk_accel_group_attach(accelgrp, GTK_OBJECT(w));
        parent = w;


	/* Load pixmap and mask pairs for use in the history_clist. */
        if((window != NULL) && (style != NULL))
        {
	    GdkPixmap *pixmap;
	    GdkBitmap *mask;
	    u_int8_t **icon_data;

#define DO_LOAD_PIXMAP	\
{ \
 mask = NULL; \
 pixmap = gdk_pixmap_create_from_xpm_d( \
  window, &mask, \
  &style->bg[GTK_STATE_NORMAL], \
  (gchar **)icon_data \
 ); \
}

	    icon_data = (u_int8_t **)icon_new_20x20_xpm;
	    DO_LOAD_PIXMAP
	    lw->object_create_pixmap = pixmap;
            lw->object_create_mask = mask;

            icon_data = (u_int8_t **)icon_copy_file_20x20_xpm;
	    DO_LOAD_PIXMAP
            lw->object_copy_pixmap = pixmap;
            lw->object_copy_mask = mask;

            icon_data = (u_int8_t **)icon_move_file_20x20_xpm;
	    DO_LOAD_PIXMAP
            lw->object_move_pixmap = pixmap;
            lw->object_move_mask = mask;

            icon_data = (u_int8_t **)icon_link2_20x20_xpm;
            DO_LOAD_PIXMAP
            lw->object_link_pixmap = pixmap;
            lw->object_link_mask = mask;

            icon_data = (u_int8_t **)icon_owned_20x20_xpm;
            DO_LOAD_PIXMAP
            lw->object_chown_pixmap = pixmap;
            lw->object_chown_mask = mask;

            icon_data = (u_int8_t **)icon_chmod_20x20_xpm;
            DO_LOAD_PIXMAP
            lw->object_chmod_pixmap = pixmap;
            lw->object_chmod_mask = mask;

            icon_data = (u_int8_t **)icon_planet_20x20_xpm;
            DO_LOAD_PIXMAP
            lw->object_download_pixmap = pixmap;
            lw->object_download_mask = mask;

            icon_data = (u_int8_t **)icon_cancel_20x20_xpm;
            DO_LOAD_PIXMAP
            lw->object_delete_pixmap = pixmap;
            lw->object_delete_mask = mask;

            icon_data = (u_int8_t **)icon_recover_20x20_xpm;
            DO_LOAD_PIXMAP
            lw->recobj_recover_pixmap = pixmap;
            lw->recobj_recover_mask = mask;

            icon_data = (u_int8_t **)icon_purge_20x20_xpm;
            DO_LOAD_PIXMAP
            lw->recobj_purge_pixmap = pixmap;
            lw->recobj_purge_mask = mask;

            icon_data = (u_int8_t **)icon_archive_add_20x20_xpm;
            DO_LOAD_PIXMAP
            lw->arcobj_add_pixmap = pixmap;
            lw->arcobj_add_mask = mask;

            icon_data = (u_int8_t **)icon_archive_extract_20x20_xpm;
            DO_LOAD_PIXMAP
            lw->arcobj_extract_pixmap = pixmap;
            lw->arcobj_extract_mask = mask;

            icon_data = (u_int8_t **)icon_cancel_20x20_xpm;
            DO_LOAD_PIXMAP
            lw->arcobj_delete_pixmap = pixmap;
            lw->arcobj_delete_mask = mask;

#undef DO_LOAD_PIXMAP
	}



        /* Main vbox. */
        lw->main_vbox = w = gtk_vbox_new(FALSE, border_major);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_container_add(GTK_CONTAINER(parent), w);
        gtk_widget_show(w);
        parent = w;


	/* Hbox for find prompt. */
	w = gtk_hbox_new(FALSE, border_major);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent2 = w;

        w = (GtkWidget *)GUIPromptBar(
            NULL, "Find:", NULL, &entry_rtn
        );
        lw->find_entry = (GtkWidget *)entry_rtn;
	entry = (GtkEntry *)entry_rtn;
        gtk_signal_connect(
            GTK_OBJECT(entry), "activate",
            GTK_SIGNAL_FUNC(EDVHistoryListWinFindCB), lw
        );
	EDVEntrySetDND((edv_core_struct *)core_ptr, w);
        gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
        gtk_widget_show(w);


	/* Scrolled window for history clist. */
        w = gtk_scrolled_window_new(NULL, NULL);
        gtk_scrolled_window_set_policy(
            GTK_SCROLLED_WINDOW(w),
            GTK_POLICY_AUTOMATIC,
            GTK_POLICY_AUTOMATIC
        );
        gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
        gtk_widget_show(w);
        parent2 = w;

        /* Contents clist. */
	heading[0] = g_strdup("Type");
	heading[1] = g_strdup("Source");
        heading[2] = g_strdup("Target");
        heading[3] = g_strdup("Status");
        heading[4] = g_strdup("Start");
        heading[5] = g_strdup("End");
	lw->history_clist = w = gtk_clist_new_with_titles(6, heading);
	g_free(heading[0]);
        g_free(heading[1]);
        g_free(heading[2]);
        g_free(heading[3]);
        g_free(heading[4]);
        g_free(heading[5]);
        clist = GTK_CLIST(w);
        gtk_widget_add_events(
            w,
            GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK |
            GDK_BUTTON_PRESS_MASK
        );
        gtk_signal_connect(
            GTK_OBJECT(w), "key_press_event",
            GTK_SIGNAL_FUNC(EDVHistoryListWinKeyEventCB), lw
        );
        gtk_signal_connect(
            GTK_OBJECT(w), "key_release_event",
            GTK_SIGNAL_FUNC(EDVHistoryListWinKeyEventCB), lw
        );
        gtk_signal_connect_after(
            GTK_OBJECT(w), "button_press_event",
            GTK_SIGNAL_FUNC(EDVHistoryListWinButtonPressEventCB), lw
        );
	gtk_clist_set_selection_mode(clist, GTK_SELECTION_SINGLE);
	gtk_clist_set_column_width(clist, 0, 90);
        gtk_clist_set_column_width(clist, 1, 120);
        gtk_clist_set_column_width(clist, 2, 120);
        gtk_clist_set_column_width(clist, 3, 70);
        gtk_clist_set_column_width(clist, 4, 100);
        gtk_clist_set_column_width(clist, 5, 100);
	gtk_clist_column_titles_passive(clist);
        gtk_clist_set_row_height(clist, EDV_LIST_ROW_SPACING);
        gtk_clist_set_shadow_type(clist, GTK_SHADOW_IN);
/*	gtk_widget_set_usize(w, -1, LISTWIN_HEIGHT * 0.5); */
        gtk_container_add(GTK_CONTAINER(parent2), w);
        gtk_signal_connect(
            GTK_OBJECT(w), "select_row",
            GTK_SIGNAL_FUNC(EDVHistoryListWinSelectRowCB), lw
        );
        gtk_signal_connect(
            GTK_OBJECT(w), "unselect_row",
            GTK_SIGNAL_FUNC(EDVHistoryListWinUnselectRowCB), lw
        );
        gtk_widget_show(w);


        /* Get source style from history clist as a template. */
        src_style = gtk_widget_get_style(lw->history_clist);

        /* Begin creating cell styles. */
        /* Success. */
        style = (src_style != NULL) ? gtk_style_copy(src_style) : NULL;
        if(style != NULL)
        {
            gint state = GTK_STATE_NORMAL;
            GdkColor *c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 0.0 * (guint16)-1;
            c->green = 0.75 * (guint16)-1;
            c->blue = 0.0 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);

            state = GTK_STATE_ACTIVE;
            c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 0.0 * (guint16)-1;
            c->green = 1.0 * (guint16)-1;
            c->blue = 0.0 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);

            state = GTK_STATE_SELECTED;
            c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 0.0 * (guint16)-1;
            c->green = 1.0 * (guint16)-1;
            c->blue = 0.0 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);

            state = GTK_STATE_PRELIGHT;
            c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 0.0 * (guint16)-1;
            c->green = 1.0 * (guint16)-1;
            c->blue = 0.0 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);

            state = GTK_STATE_INSENSITIVE;
            c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 0.0 * (guint16)-1;
            c->green = 0.5 * (guint16)-1;
            c->blue = 0.0 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);

            lw->cell_style[EDV_HISTORY_CELL_STYLE_SUCCESS] = style;
        }

        /* Error (general/ambiguous/system). */
        style = (src_style != NULL) ? gtk_style_copy(src_style) : NULL;
        if(style != NULL)
        {
            gint state = GTK_STATE_NORMAL;
            GdkColor *c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 1.0 * (guint16)-1;
            c->green = 0.0 * (guint16)-1;
            c->blue = 0.0 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);

            state = GTK_STATE_ACTIVE;
            c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 1.0 * (guint16)-1;
            c->green = 0.0 * (guint16)-1;
            c->blue = 0.0 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);

            state = GTK_STATE_PRELIGHT;
            c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 1.0 * (guint16)-1;
            c->green = 0.0 * (guint16)-1;
            c->blue = 0.0 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);

            state = GTK_STATE_SELECTED;
            c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 1.0 * (guint16)-1;
            c->green = 0.0 * (guint16)-1;
            c->blue = 0.0 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);

            state = GTK_STATE_INSENSITIVE;
            c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 0.5 * (guint16)-1;
            c->green = 0.0 * (guint16)-1;
            c->blue = 0.0 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);

            lw->cell_style[EDV_HISTORY_CELL_STYLE_ERROR] = style;
        }

        /* User aborted (responded no/cancel/abort). */
        style = (src_style != NULL) ? gtk_style_copy(src_style) : NULL;
        if(style != NULL)
        {
            gint state = GTK_STATE_NORMAL;
            GdkColor *c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 0.75 * (guint16)-1;
            c->green = 0.75 * (guint16)-1;
            c->blue = 0.0 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);

            state = GTK_STATE_ACTIVE;
            c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 1.0 * (guint16)-1;
            c->green = 1.0 * (guint16)-1;
            c->blue = 0.0 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);

            state = GTK_STATE_PRELIGHT;
            c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 1.0 * (guint16)-1;
            c->green = 1.0 * (guint16)-1;
            c->blue = 0.0 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);

            state = GTK_STATE_SELECTED;
            c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 1.0 * (guint16)-1;
            c->green = 1.0 * (guint16)-1;
            c->blue = 0.0 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);

            state = GTK_STATE_INSENSITIVE;
            c = &style->fg[state];
            gdk_colormap_free_colors(colormap, c, 1);
            c->red = 0.5 * (guint16)-1;
            c->green = 0.5 * (guint16)-1;
            c->blue = 0.0 * (guint16)-1;
            gdk_colormap_alloc_color(colormap, c, TRUE, TRUE);

            lw->cell_style[EDV_HISTORY_CELL_STYLE_CANCEL] = style;
        }


	/* Hbox for buttons. */
	w = gtk_hbox_new(TRUE, 0);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent2 = w;

        /* Refresh button. */
        lw->refresh_btn = w = GUIButtonPixmapLabelH(
            (u_int8_t **)icon_reload_20x20_xpm, "Refresh", NULL
        );
        gtk_widget_set_usize(w, LISTWIN_BTN_WIDTH, LISTWIN_BTN_HEIGHT);
        GTK_WIDGET_SET_FLAGS(w, GTK_CAN_DEFAULT);
        gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, FALSE, 0);
        gtk_signal_connect(
            GTK_OBJECT(w), "clicked",
            GTK_SIGNAL_FUNC(EDVHistoryListWinRefreshCB), lw
        );
        gtk_accel_group_add(
            accelgrp, GDK_F5, 0, GTK_ACCEL_VISIBLE,
            GTK_OBJECT(w), "clicked"
        );
        gtk_widget_show(w);

        /* Save button. */
        lw->save_btn = w = GUIButtonPixmapLabelH(
            (u_int8_t **)icon_save_20x20_xpm, "Save...", NULL
        );
        gtk_widget_set_usize(w, LISTWIN_BTN_WIDTH, LISTWIN_BTN_HEIGHT);
        GTK_WIDGET_SET_FLAGS(w, GTK_CAN_DEFAULT);
        gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, FALSE, 0);
        gtk_signal_connect(
            GTK_OBJECT(w), "clicked",
            GTK_SIGNAL_FUNC(EDVHistoryListWinSaveCB), lw
        );
        gtk_widget_show(w);

        /* Clear button. */
        lw->clear_btn = w = GUIButtonPixmapLabelH(
            (u_int8_t **)icon_clear_20x20_xpm, "Clear", NULL
        );
        gtk_widget_set_usize(w, LISTWIN_BTN_WIDTH, LISTWIN_BTN_HEIGHT);
        GTK_WIDGET_SET_FLAGS(w, GTK_CAN_DEFAULT);
        gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, FALSE, 0);
        gtk_signal_connect(
            GTK_OBJECT(w), "clicked",
            GTK_SIGNAL_FUNC(EDVHistoryListWinClearCB), lw
        );
        gtk_widget_show(w);


#if 0
        /* Horizontal separator. */
        w = gtk_hseparator_new();
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);


	/* Parent vbox for displaying selected MIME Type. */
	lw->display_parent = w = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
        gtk_widget_show(w);
	parent2 = w;

	/* Client vbox that is parented to the display_parent, leave this
	 * NULL, it'll be created when needed.
	 */
	lw->display_client = NULL;
#endif

	/* Horizontal separator. */
	w = gtk_hseparator_new();
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);


	/* Hbox for buttons. */
	w = gtk_hbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
	parent2 = w;

	/* Alignment. */
	w = gtk_alignment_new(1.0, 0.5, 0.0, 0.0);
	gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
        gtk_widget_show(w);
        parent2 = w;

	/* Hbox for buttons set. */
        w = gtk_hbox_new(FALSE, border_major);
        gtk_container_add(GTK_CONTAINER(parent2), w);
        gtk_widget_show(w);
        parent2 = w;

        /* Close button. */
        lw->close_btn = w = GUIButtonPixmapLabelH(
            (u_int8_t **)icon_close_20x20_xpm, "Close", NULL
        );
        gtk_widget_set_usize(w, LISTWIN_BTN_WIDTH, LISTWIN_BTN_HEIGHT);
        GTK_WIDGET_SET_FLAGS(w, GTK_CAN_DEFAULT);
        gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, FALSE, 0);
        gtk_signal_connect(
            GTK_OBJECT(w), "clicked",
            GTK_SIGNAL_FUNC(EDVHistoryListWinCloseCB), lw
        );
        gtk_accel_group_add(
            accelgrp, GDK_Escape, 0, GTK_ACCEL_VISIBLE,
            GTK_OBJECT(w), "clicked"
        );
        gtk_widget_show(w);



	/* Right click menu. */
        lw->menu = menu = (GtkWidget *)GUIMenuCreate();
        mclient_data = lw;
        if(menu != NULL)
        {
            u_int8_t **icon;
            gint accel_key;
            guint accel_mods;
            const gchar *label;
            void (*func_cb)(GtkWidget *, gpointer);

#define DO_ADD_MENU_ITEM_LABEL  \
{ \
 w = GUIMenuItemCreate( \
  menu, GUI_MENU_ITEM_TYPE_LABEL, accelgrp, \
  icon, label, accel_key, accel_mods, (void **)&fw, \
  mclient_data, func_cb \
 ); \
}
#define DO_ADD_MENU_SEP \
{ \
 w = GUIMenuItemCreate( \
  menu, GUI_MENU_ITEM_TYPE_SEPARATOR, NULL, \
  NULL, NULL, 0, 0, NULL, \
  NULL, NULL \
 ); \
}
            icon = (u_int8_t **)icon_reload_20x20_xpm;
            label = "Refresh";
            accel_key = GDK_F5;
            accel_mods = 0;
            func_cb = EDVHistoryListWinRefreshCB;
            DO_ADD_MENU_ITEM_LABEL
	    lw->refresh_mi = w;

	    DO_ADD_MENU_SEP

            icon = (u_int8_t **)icon_save_20x20_xpm;
            label = "Save...";
            accel_key = 0;
            accel_mods = 0;
            func_cb = EDVHistoryListWinSaveCB;
            DO_ADD_MENU_ITEM_LABEL
            lw->save_mi = w;

	    DO_ADD_MENU_SEP

            icon = (u_int8_t **)icon_clear_20x20_xpm;
            label = "Clear";
            accel_key = 0;
            accel_mods = 0;
            func_cb = EDVHistoryListWinClearCB;
            DO_ADD_MENU_ITEM_LABEL
            lw->clear_mi = w;


#undef DO_ADD_MENU_ITEM_LABEL
#undef DO_ADD_MENU_SEP
        }




        EDVHistoryListWinUpdateMenus(lw);

	return(lw);
}

/*
 *	Updates menus and other widgets on the given history list
 *	window to reflect its current data.
 */
void EDVHistoryListWinUpdateMenus(
        edv_history_listwin_struct *lw
)
{
/*	gbool sensitive; */
	gint sel_row;
/*	GtkWidget *w; */
	GtkCList *clist;


        if(lw == NULL)
            return;


	/* Get selected row on clist. */
	clist = (GtkCList *)lw->history_clist;
	sel_row = EDVCListGetSelectedLast(clist, NULL);

#define DO_SET_SENSITIVE	\
{ \
 if(w != NULL) \
  gtk_widget_set_sensitive(w, sensitive); \
}



#undef DO_SET_SENSITIVE
}

/*
 *	Maps the MIME Types list window.
 */
void EDVHistoryListWinMap(
        edv_history_listwin_struct *lw
)
{
        GtkWidget *w;

        if(lw == NULL)
            return;

	/* Set close button as the default on map. */
        w = lw->close_btn;
        if(w != NULL)
        {
            gtk_widget_grab_focus(w);
            gtk_widget_grab_default(w);
        }

	w = lw->toplevel;
	gtk_widget_show_raise(w);
	lw->map_state = TRUE;
}

/*
 *	Marks the history list window as busy or ready.
 */
void EDVHistoryListWinSetBusy(
        edv_history_listwin_struct *lw, gbool is_busy
)
{
        GdkCursor *cursor;
        GtkWidget *w;
        edv_core_struct *core_ptr;


        if(lw == NULL)
            return;

        if(!lw->initialized)
            return;

        core_ptr = (edv_core_struct *)lw->core_ptr;
        if(core_ptr == NULL)
            return;

        w = lw->toplevel;
        if(w != NULL)
        {
            if(is_busy)
            {
                /* Increase busy count. */
                lw->busy_count++;

                /* If already busy then don't change anything. */
                if(lw->busy_count > 1)
                    return;

                cursor = EDVGetCursor(core_ptr, EDV_CURSOR_CODE_BUSY);
            }
            else
            {
                /* Reduce busy count. */
                lw->busy_count--;
                if(lw->busy_count < 0)
                    lw->busy_count = 0;

                /* If still busy do not change anything. */
                if(lw->busy_count > 0)
                    return;

                cursor = NULL;  /* Use default cursor. */
            }

            /* Update toplevel window's cursor. */
            if(w->window != NULL)
            {
                gdk_window_set_cursor(w->window, cursor);
                gdk_flush();
            }
        }
}

/*
 *	Unmaps the MIME Types list window.
 */
void EDVHistoryListWinUnmap(
        edv_history_listwin_struct *lw
)
{
	GtkWidget *w;

	if(lw == NULL)
	    return;

	w = lw->toplevel;
	if(w == NULL)
	    return;

	if(lw->map_state)
	{
	    gtk_widget_hide(w);
	    lw->map_state = FALSE;
	}
}

/*
 *	Deallocates all resources of the given MIME Types list window and
 *	deallocates the structure itself.
 */
void EDVHistoryListWinDelete(
        edv_history_listwin_struct *lw
)
{
	gint i;
	GtkStyle **style;
        GtkWidget **w;
	GdkPixmap **pixmap;
	GdkBitmap **mask;


        if(lw == NULL)
            return;

        if(lw->initialized)
        {
#define DO_UNREF_STYLE		\
{ \
 if((*style) != NULL) \
 { \
  GtkStyle *ts = *style; \
  (*style) = NULL; \
  gtk_style_unref(ts); \
 } \
}

#define DO_DESTROY_WIDGET       \
{ \
 if((*w) != NULL) \
 { \
  GtkWidget *tmp_w = *w; \
  (*w) = NULL; \
  gtk_widget_destroy(tmp_w); \
 } \
}

#define DO_UNREF_PIXMAP_PAIR	\
{ \
 if((*pixmap) != NULL) \
 { \
  GdkPixmap *tpm = *pixmap; \
  (*pixmap) = NULL; \
  gdk_pixmap_unref(tpm); \
 } \
 if((*mask) != NULL) \
 { \
  GdkBitmap *tbm = *mask; \
  (*mask) = NULL; \
  gdk_bitmap_unref(tbm); \
 } \
}

	    /* Destroy right click menu. */
            w = &lw->menu;
            lw->refresh_mi = NULL;
            lw->save_mi = NULL;
            lw->clear_mi = NULL;
            DO_DESTROY_WIDGET


	    /* Begin destroying widgets. */
#if 0
	    w = &lw->display_client;
	    DO_DESTROY_WIDGET

	    w = &lw->display_parent;
	    DO_DESTROY_WIDGET
#endif

            w = &lw->find_entry;
            DO_DESTROY_WIDGET

            w = &lw->history_clist;
            DO_DESTROY_WIDGET

            w = &lw->refresh_btn;
            DO_DESTROY_WIDGET
            w = &lw->save_btn;
            DO_DESTROY_WIDGET
            w = &lw->clear_btn;
            DO_DESTROY_WIDGET
            w = &lw->close_btn;
            DO_DESTROY_WIDGET

            w = &lw->toplevel;
            DO_DESTROY_WIDGET

            if(lw->accelgrp != NULL)
            {
                gtk_accel_group_unref(lw->accelgrp);
                lw->accelgrp = NULL;
            }
/*
if(1)
{
GdkWindowPrivate *private = (GdkWindowPrivate *)lw->system_object_pixmap;
printf("Pixmap refcount = %i\n", private->ref_count - 1);
}
 */
	    pixmap = &lw->object_create_pixmap;
            mask = &lw->object_create_mask;
	    DO_UNREF_PIXMAP_PAIR
            pixmap = &lw->object_copy_pixmap;
            mask = &lw->object_copy_mask;
	    DO_UNREF_PIXMAP_PAIR
            pixmap = &lw->object_move_pixmap;
            mask = &lw->object_move_mask;
	    DO_UNREF_PIXMAP_PAIR
            pixmap = &lw->object_link_pixmap;
            mask = &lw->object_link_mask;
            DO_UNREF_PIXMAP_PAIR
            pixmap = &lw->object_chown_pixmap;
            mask = &lw->object_chown_mask;
            DO_UNREF_PIXMAP_PAIR
            pixmap = &lw->object_chmod_pixmap;
            mask = &lw->object_chmod_mask;
            DO_UNREF_PIXMAP_PAIR
            pixmap = &lw->object_download_pixmap;
            mask = &lw->object_download_mask;
            DO_UNREF_PIXMAP_PAIR
            pixmap = &lw->object_delete_pixmap;
            mask = &lw->object_delete_mask;
            DO_UNREF_PIXMAP_PAIR
            pixmap = &lw->recobj_recover_pixmap;
            mask = &lw->recobj_recover_mask;
            DO_UNREF_PIXMAP_PAIR
            pixmap = &lw->recobj_purge_pixmap;
            mask = &lw->recobj_purge_mask;
            DO_UNREF_PIXMAP_PAIR
            pixmap = &lw->arcobj_add_pixmap;
            mask = &lw->arcobj_add_mask;
            DO_UNREF_PIXMAP_PAIR
            pixmap = &lw->arcobj_extract_pixmap;
            mask = &lw->arcobj_extract_mask;
            DO_UNREF_PIXMAP_PAIR
            pixmap = &lw->arcobj_delete_pixmap;
            mask = &lw->arcobj_delete_mask;
            DO_UNREF_PIXMAP_PAIR

            /* Unref all cell styles. */
            for(i = 0; i < EDV_HISTORY_TOTAL_CELL_STYLES; i++)
            {
                style = &lw->cell_style[i];
                DO_UNREF_STYLE
            }

#undef DO_UNREF_PIXMAP_PAIR
#undef DO_DESTROY_WIDGET
#undef DO_UNREF_STYLE
        }

        /* Deallocate structure itself. */
	g_free(lw);
}
