#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#ifdef HAVE_IMLIB
# include <Imlib.h>
#endif
#include <gtk/gtk.h>

#include "imgview.h"

#include "edvtypes.h"
#include "edvcfg.h"
#include "edvobj.h"
#include "imbr.h"
#include "imbrtlist.h"
#include "imbrimgview.h"
#include "endeavour.h"
#include "edvutils.h"
#include "edvutilsgtk.h"
#include "edvcfglist.h"
#include "config.h"



void EDVImbrImgViewClear(edv_imbr_struct *imbr);
void EDVImbrImgViewLoad(edv_imbr_struct *imbr, const gchar *path);


/*
 *	Clears the image viewer.
 */
void EDVImbrImgViewClear(edv_imbr_struct *imbr)
{
	imgview_struct *iv;


	if(imbr == NULL)
	    return;

	iv = imbr->imgview;
	if(iv == NULL)
	    return;

	ImgViewClear(iv);
}


/*
 *	Loads the image file specified by path to the image viewer.
 *
 *	This function will automatically call EDVImbrImgViewClear()
 *	first.
 */
void EDVImbrImgViewLoad(edv_imbr_struct *imbr, const gchar *path)
{
	imgview_struct *iv;
	GdkWindow *window;
	GtkWidget *w;
	guint8 *data_rgba;
	gint width, height, bpl;
	gbool need_zoom_to_fit = FALSE;


	if(imbr == NULL)
	    return;

	EDVImbrImgViewClear(imbr);

	if(path == NULL)
	    return;

        iv = imbr->imgview;
        if(iv == NULL)
            return;

	/* Check if this is not an image supported by Imlib. */
	if(!EDVCheckImlibImage(
	    (edv_core_struct *)imbr->core_ptr, path
	))
	    return;


	EDVImbrSetBusy(imbr, TRUE);

	/* Get image viewer's view widget and window. */
	w = (GtkWidget *)ImgViewGetViewWidget(iv);
	window = (w != NULL) ? w->window : NULL;

        /* Load image data. */
        data_rgba = EDVImbrTListLoadImageRGBA(
            (edv_core_struct *)imbr->core_ptr,
            path, &width, &height, &bpl, window
        );
        if(data_rgba == NULL)
        {
            EDVImbrSetBusy(imbr, FALSE);
            return;
        }

	/* Check if image viewer's view widget is larger in any
	 * one dimension than the image viewer's view widget.
	 * This is to determine if we need to 'zoom to fit'.
	 */
        if(w != NULL)
        {
            gint	wwidth = w->allocation.width,
			wheight = w->allocation.height;
            if((width > wwidth) || (height > wheight))
		need_zoom_to_fit = TRUE;
        }

	/* Set loaded image data to image viewer. */
	if(need_zoom_to_fit)
	    ImgViewLoadToFit(
                iv,
                width, height,
                bpl,
                IMGVIEW_FORMAT_RGBA,
                data_rgba
            );
	else
	    ImgViewLoad(
		iv,
		width, height,
		bpl,
		IMGVIEW_FORMAT_RGBA,
		data_rgba
	    );

	/* Deallocate loaded image data, it is no longer needed. */
	g_free(data_rgba);
	data_rgba = NULL;


	EDVImbrSetBusy(imbr, FALSE);
}
