/*
                Endeavour Image Browser Operation Callbacks
 */

#ifndef IMBROPCB_H
#define IMBROPCB_H


#include <gtk/gtk.h>
#include "edvtypes.h"
#include "edvdevices.h"
#include "imbr.h"


extern void EDVImbrMenuItemCB(GtkWidget *widget, gpointer data);
extern gint EDVImbrMenuItemEnterCB(
        GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern gint EDVImbrMenuItemLeaveCB(
        GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern void EDVImbrOPCB(gpointer data);
extern void EDVImbrOPEnterCB(gpointer data);
extern void EDVImbrOPLeaveCB(gpointer data);

extern void EDVImbrMountBarMountCB(
	gpointer mb, gint dev_num, edv_device_struct *dev_ptr,
	gpointer data
);
extern void EDVImbrMountBarEjectCB(
        gpointer mb, gint dev_num, edv_device_struct *dev_ptr,
        gpointer data
);
extern void EDVImbrMountBarGoToCB(
        gpointer mb, gint dev_num, edv_device_struct *dev_ptr,
        gpointer data
);

extern gchar *EDVImbrFindBarLocationCB(gpointer fb, gpointer data);
extern void EDVImbrFindBarStartCB(gpointer fb, gpointer data);
extern void EDVImbrFindBarEndCB(
	gpointer fb, gint total_matches, gpointer data
);
extern void EDVImbrFindBarMatchCB(
        const gchar *path, const struct stat *lstat_buf, const gchar *excerpt,
	gpointer data
);

extern void EDVImbrBarStatusMessageCB(
        gpointer mb, const gchar *message, gpointer data
);
extern void EDVImbrBarStatusProgressCB(
        gpointer bar, gfloat progress, gpointer data
);

extern void EDVImbrOPSyncDisks(edv_imbr_struct *imbr);
extern void EDVImbrOPWriteProtect(edv_imbr_struct *imbr);

extern void EDVImbrOPClose(edv_imbr_struct *imbr);
extern void EDVImbrOPExit(edv_imbr_struct *imbr);

extern void EDVImbrOPNewFile(edv_imbr_struct *imbr);
extern void EDVImbrOPNewDirectory(edv_imbr_struct *imbr);
extern void EDVImbrOPNewLink(edv_imbr_struct *imbr);
extern void EDVImbrOPNewFifo(edv_imbr_struct *imbr);
extern void EDVImbrOPNewDeviceBlock(edv_imbr_struct *imbr);
extern void EDVImbrOPNewDeviceCharacter(edv_imbr_struct *imbr);
extern void EDVImbrOPNewSocket(edv_imbr_struct *imbr);

extern void EDVImbrOPOpen(edv_imbr_struct *imbr);
extern void EDVImbrOPOpenWith(edv_imbr_struct *imbr);

extern void EDVImbrOPMove(edv_imbr_struct *imbr);
extern void EDVImbrOPCopy(edv_imbr_struct *imbr);
extern void EDVImbrOPLink(edv_imbr_struct *imbr);
extern void EDVImbrOPRename(edv_imbr_struct *imbr);
extern void EDVImbrOPDelete(edv_imbr_struct *imbr);
extern void EDVImbrOPProperties(edv_imbr_struct *imbr);

extern void EDVImbrOPStop(edv_imbr_struct *imbr);
extern void EDVImbrOpContinue(edv_imbr_struct *imbr);
extern void EDVImbrOPRefresh(edv_imbr_struct *imbr);
extern void EDVImbrOPRefreshAll(edv_imbr_struct *imbr);


#endif	/* IMBROPCB_H */
