/*
 *	Prints a list of all configuration parameters that you can use
 *	with EDVGet*() functions.
 */

#include <stdio.h>
#include <glib.h>
#include <endeavour2.h>

int main(int argc, char *argv[])
{
	gchar **params;
	gint i, total = 0;

	edv_context_struct *ctx = EDVContextNew();
	EDVContextLoadConfigurationFile(ctx, NULL);

	/* Get a list of all configuration parameters, then print
	 * and deallocate the returned strings and pointer array.
	 *
	 * Note that you must call EDVContextLoadConfigurationFile()
	 * at least once before calling this function to ensure that
	 * the configuration values are loaded.
	 *
	 * All the params listed are what is actually defined in the
	 * configuration, where as those defined in edvcfglist.h are
	 * all possible params.
	 */
	params = EDVGetConfigurationParameters(ctx, &total);
	for(i = 0; i < total; i++)
	{
	    printf("%s\n", params[i]);
	    g_free(params[i]);
	}
	g_free(params);

	printf("%i parameters found\n", i);

	EDVContextSync(ctx);
	EDVContextDelete(ctx);

	return(0);
}
