/*
 *	Signal/event/message sending
 *
 *	For notifying the Endeavour program of when something happening
 *	that is caused by an external program.
 */

#ifndef EDVNOTIFY_H
#define EDVNOTIFY_H

#include "edvcontext.h"

/*
 *      Queues an "object_added_notify" command.
 */
extern void EDVNotifyQueueObjectAdded(
	edv_context_struct *ctx, const gchar *path
);

/*
 *      Queues an "object_modified_notify" command.
 *
 *      If new_path is NULL then only path will be sent (hinting that
 *      the name of the object was not modified).
 */
extern void EDVNotifyQueueObjectModified(
        edv_context_struct *ctx, const gchar *path, const gchar *new_path
);

/*
 *      Queues an "object_removed_notify" command.
 */
extern void EDVNotifyQueueObjectRemoved(
        edv_context_struct *ctx, const gchar *path
);

/*
 *      Queues an "object_mounted_notify" command.
 */
extern void EDVNotifyQueueObjectMounted(
        edv_context_struct *ctx, const gchar *path
);

/*
 *      Queues an "object_unmounted_notify" command.
 */
extern void EDVNotifyQueueObjectUnmounted(
        edv_context_struct *ctx, const gchar *path
);

/*
 *      Queues a "recycled_object_added_notify" command.
 */
extern void EDVNotifyQueueRecycledObjectAdded(
        edv_context_struct *ctx, guint index
);

/*
 *      Queues a "recycled_object_removed_notify" command.
 */
extern void EDVNotifyQueueRecycledObjectRemoved(
        edv_context_struct *ctx, guint index
);


/*
 *      Sends all queued notifies to Endeavour.
 *
 *      If there is no lock link in the local Endeavour data directory
 *      then the queued commands will not be sent.
 *
 *      All queued commands will be removed from the ctx regardless of
 *      error or success.
 */
extern void EDVNotifyFlush(edv_context_struct *ctx);


#endif	/* EDVNOTIFY_H */
