#include <limits.h>
#include <unistd.h>
#include <glib.h>
#include "../../include/string.h"
#include "../edvinterps.h"
#include "../edvcfg.h"
#include "edvcontext.h"
#include "edvutils.h"
#include "edvopen.h"
#include "config.h"

void EDVOpen(
	edv_context_struct *ctx,
	const gchar *path, const gchar *command_name
);

/*
 *      Instructs the Endeavour program to open an object by checking
 *      the object's extension and matching it through its MIME Types
 *      list.  If a method to open the object is found, then that method
 *      will be used to open the object.
 *
 *	If command_name is not NULL then the specific command's name
 *	(defined by the matched MIME Type) will be used (otherwise the
 *	default command will be used).
 *
 *      Typical values for command_name are; "default", "view",
 *      and "edit". However it is difficult to know what the user has
 *      set so it is recommended that command_name be left NULL.
 */
void EDVOpen(
	edv_context_struct *ctx,
	const gchar *path, const gchar *command_name
)
{
	gint p;

	if((ctx == NULL) || (path == NULL))
	    return;

	p = EDVInterPSGetLock(
	    (edv_cfg_item_struct *)ctx->cfg_list
	);
	if(p > 0)
	{
	    gchar *cmdv[1], *cmd, *dpath;
	    gchar cwd[PATH_MAX];

	    dpath = EDVCopyEvaluateInputPath(
		getcwd(cwd, PATH_MAX), path
	    );
	    if(command_name != NULL)
		cmd = g_strdup_printf(
		    "open_object %s %s", dpath, command_name
		);
	    else
                cmd = g_strdup_printf(
                    "open_object %s", dpath
                );
	    cmdv[0] = cmd;
	    EDVInterPSSendCommand(
		(edv_cfg_item_struct *)ctx->cfg_list, p,
		cmdv, 1
	    );
	    g_free(cmd);
	    g_free(dpath);
	}
}
