/*
                            Endeavour Mount Bar
 */

#ifndef MOUNTBAR_H
#define MOUNTBAR_H

#include <gtk/gtk.h>

#include "edvtypes.h"
#include "edvdevices.h"


/*
 *	Mount bar structure:
 */
typedef struct {

	gbool initialized;
	gbool map_state;

	gpointer core_ptr;

	GtkWidget *toplevel;

	GdkGC *gc;

	GtkWidget *dev_da;
        GtkWidget *map_btn;	/* Map devices popup list button. */
	GtkWidget *mount_btn;	/* Mount/unmount button. */
	GtkWidget *eject_btn;
	GtkWidget *goto_btn;
        GtkWidget *refresh_stats_btn;
	GtkWidget *capacity_pbar;
	GtkWidget *stats_label;

	/* Last mount button state, -1 for undefined, 0 for mount,
	 * 1 for unmount
	 */
	gint last_mount_btn_state;

	gchar *dev_text;
	GdkPixmap *dev_pixmap;
	GdkBitmap *dev_mask;

	gint selected_dev_num;	/* Selected device number or -1 for none. */

        void (*mount_cb)(gpointer, gint, edv_device_struct *, gpointer);
	void (*eject_cb)(gpointer, gint, edv_device_struct *, gpointer);
        void (*goto_cb)(gpointer, gint, edv_device_struct *, gpointer);
        void (*status_message_cb)(gpointer, const gchar *, gpointer);
        gpointer client_data;

} edv_mountbar_struct;


extern edv_mountbar_struct *EDVMountBarNew(
	gpointer core_ptr, GtkWidget *parent,
        void (*mount_cb)(gpointer, gint, edv_device_struct *, gpointer),
	void (*eject_cb)(gpointer, gint, edv_device_struct *, gpointer),
        void (*goto_cb)(gpointer, gint, edv_device_struct *, gpointer),
        void (*status_message_cb)(gpointer, const gchar *, gpointer),
        gpointer client_data
);
extern void EDVMountBarUpdateMenus(edv_mountbar_struct *mb);
extern void EDVMountBarMap(edv_mountbar_struct *mb);
extern void EDVMountBarUnmap(edv_mountbar_struct *mb);
extern void EDVMountBarDelete(edv_mountbar_struct *mb);






#endif	/* MOUNTBAR_H */
