/*
                     Endeavour General Options Window
 */

#ifndef OPTWIN_H
#define OPTWIN_H

#include <gtk/gtk.h>
#include "stacklist.h"
#include "edvtypes.h"
#include "edvcfg.h"


/*
 *	Widget to configuration list parameter reference:
 */
typedef struct {

	GtkWidget *w;		/* Widget that holds the value (shared). */
	GtkWidget *browse;	/* Browse button (shared). */
	gchar *cfg_parm;	/* Configuration parameter name. */

	/* Following are members use in special or extended cases. */
	gint radio_value;	/* This value is used if radio button is
				 * active.
				 */

	/* Stack list, used instead of the GtkWidget w if not NULL. */
	stack_list_struct *slist;

} edv_cfg_wref_struct;


/*
 *	Options window structure:
 */
typedef struct {

	gbool initialized;
	gbool map_state;
	gbool processing;
	gpointer core_ptr;

	GtkAccelGroup *accelgrp;

	GtkWidget *toplevel;

	GtkWidget *notebook;

	GtkWidget **page;
	gint total_pages;

	GtkWidget *ok_btn, *apply_btn, *save_btn, *cancel_btn;

	edv_cfg_wref_struct **wref;
	gint total_wrefs;

} edv_optwin_struct;


extern edv_cfg_wref_struct *OptWinWRefNew(
	GtkWidget *w,		/* Widget that holds the value. */
	GtkWidget *browse,	/* Browse button. */
	const gchar *cfg_parm	/* Configuration parameter name. */
);
extern void OptWinWRefDelete(edv_cfg_wref_struct *wref);
extern edv_cfg_wref_struct *OptWinWRefAppend(
	edv_optwin_struct *optwin,
        GtkWidget *w,           /* Widget that holds the value. */
        GtkWidget *browse,      /* Browse button. */
	const gchar *cfg_parm	/* Configuration parameter name. */
);

extern edv_optwin_struct *OptWinNew(
        gpointer core_ptr, const gchar *title, guint8 **icon_data
);
extern GtkWidget *OptWinPageAppend(
	edv_optwin_struct *optwin, GtkWidget *w
);
extern void OptWinMap(edv_optwin_struct *optwin);
extern void OptWinUnmap(edv_optwin_struct *optwin);
extern void OptWinDelete(edv_optwin_struct *optwin);






#endif	/* OPTWIN_H */
