/*
                                Prompt Dialog
 */

#ifndef PDIALOG_H
#define PDIALOG_H

#include <sys/types.h>

#include <gtk/gtk.h>

#ifndef gbool
# define gbool	gboolean
#endif


/*
 *	Response codes:
 */
#define PDIALOG_RESPONSE_NOT_AVAILABLE	-1
#define PDIALOG_RESPONSE_CANCEL		0
#define PDIALOG_RESPONSE_SUBMIT 	1	/* OK. */
#define PDIALOG_RESPONSE_HELP		2


/*
 *	Prompt icon codes, specifies the icon displayed next to
 *	the prompts:
 */
#define PDIALOG_ICON_INFO	0	/* 0 to 49 are generic icons */
#define PDIALOG_ICON_WARNING    1
#define PDIALOG_ICON_ERROR	2
#define PDIALOG_ICON_QUESTION	3
#define PDIALOG_ICON_HELP	4
#define PDIALOG_ICON_WIZARD	5	/* Wand. */
#define PDIALOG_ICON_SEARCH	6	/* Magnifying glass. */
#define PDIALOG_ICON_SECURITY	7	/* Padlock with key. */
#define PDIALOG_ICON_PRINTER	8
#define PDIALOG_ICON_SPEAKER	9
#define PDIALOG_ICON_BULB	10
#define PDIALOG_ICON_POWER	11	/* Battery and A/C plug. */
#define PDIALOG_ICON_LINUX	12	/* Tux the Linux penguin. */
#define PDIALOG_ICON_TERMINAL	13
#define PDIALOG_ICON_SETTINGS	14	/* Gears. */
#define PDIALOG_ICON_TOOLS	15
#define PDIALOG_ICON_MONITOR	16
#define PDIALOG_ICON_CLIPBOARD_EMPTY	17
#define PDIALOG_ICON_CLIPBOARD_FULL	18
#define PDIALOG_ICON_EDIT	19
/* 50 - 69 are object type icons */
#define PDIALOG_ICON_FILE	50
#define PDIALOG_ICON_FOLDER_CLOSER	51
#define PDIALOG_ICON_FOLDER_OPENED	52
#define PDIALOG_ICON_LINK	53
#define PDIALOG_ICON_PIPE	54
#define PDIALOG_ICON_DEVICE	55
#define PDIALOG_ICON_DEVICE_BLOCK	56
#define PDIALOG_ICON_DEVICE_CHARACTER	57
#define PDIALOG_ICON_SOCKET	58
/* 70 - 89 are file op icons */
#define PDIALOG_ICON_FILE_MOVE	71
#define PDIALOG_ICON_FILE_COPY	72
#define PDIALOG_ICON_FILE_PROPERTIES	75
/* 90 to 99 are reserved */
/* 100 - 129 are net icons */
#define PDIALOG_ICON_PLANET	100
#define PDIALOG_ICON_FTP	101
#define PDIALOG_ICON_CHAT	102
#define PDIALOG_ICON_FILE_WWW	103


/*
 *	Button display flags:
 */
#define PDIALOG_BTNFLAG_SUBMIT	(1 << 1)
#define PDIALOG_BTNFLAG_CANCEL	(1 << 2)
#define PDIALOG_BTNFLAG_HELP	(1 << 3)


extern gint PDialogInit(void);

extern void PDialogSetTransientFor(GtkWidget *w);
extern gbool PDialogIsQuery(void);
extern void PDialogBreakQuery(void);

extern void PDialogAddPrompt(
	const u_int8_t **icon_data,	/* Can be NULL. */
        const gchar *label,		/* Can be NULL. */
        const gchar *value		/* Can be NULL. */
);
extern void PDialogAddPromptPassword(
        const u_int8_t **icon_data,
        const gchar *label,
        const gchar *value
);
extern void PDialogAddPromptWithBrowse(
	const u_int8_t **icon_data,	/* Can be NULL. */
	const gchar *label,		/* Can be NULL. */
	const gchar *value,		/* Can be NULL. */
	gpointer client_data,		/* Can be NULL. */
	gchar *(*browse_cb)(gpointer, gpointer, gint)	/* Can be NULL. */
);
extern void PDialogAddPromptSpin(
        const u_int8_t **icon_data,
        const gchar *label,
        gfloat value, gfloat lower, gfloat upper,
        gfloat step_increment, gfloat page_increment,
        gdouble climb_rate, guint digits
);
extern void PDialogAddPromptScale(
        const u_int8_t **icon_data,
        const gchar *label,
        gfloat value, gfloat lower, gfloat upper,
        gfloat step_increment, gfloat page_increment,
        gbool show_value, guint digits
);
extern void PDialogAddPromptCombo(
        const u_int8_t **icon_data,
        const gchar *label,
        const gchar *value,
        GList *list,
        gbool editable, gbool case_sensitive
);
extern void PDialogAddPromptRadio(
        const u_int8_t **icon_data,
        const gchar *label,
        GList *list,            /* List of radio button names. */
        gint start_num          /* Initial radio button to select. */
);
extern void PDialogAddPromptToggle(
        const u_int8_t **icon_data,
        const gchar *label, gboolean value
);
extern void PDialogSetPromptValue(
	gint prompt_num,
	const u_int8_t **icon_data,
	const gchar *label,
	const gchar *value
);
extern void PDialogSetPromptTip(gint prompt_num, const gchar *tip);
extern gchar *PDialogGetPromptValue(gint prompt_num);
extern void PDialogDeleteAllPrompts(void);

extern gchar **PDialogGetResponse(
	const gchar *title,
	const gchar *message,
	const gchar *explaination,
	gint icon_code,
	const gchar *submit_label,
	const gchar *cancel_label,
	guint show_buttons,	/* Any of PDIALOG_BTNFLAG_*. */
	guint default_button,	/* One of PDIALOG_BTNFLAG_*. */
	gint *nvalues
);

extern void PDialogSetSize(gint width, gint height);

extern void PDialogMap(void);
extern void PDialogUnmap(void);

extern void PDialogShutdown(void);


#endif	/* PDIALOG_H */
