/*
                       Recycle Bin Desktop Icon
 */

#ifndef RECBINDESKICON_H
#define RECBINDESKICON_H

#include <gtk/gtk.h>
#include "deskicon.h"


/*
 *	Recycle bin desktop icon structure:
 */
typedef struct {

	gpointer core_ptr;

	deskicon_struct *deskicon;

        /* Last known items in recycle bin, this is used as a quick access
         * value to check if the recycle bin has contents or not. Can be
         * -1 to indicate undefined.
         */
        gint last_recbin_items;

} edv_recbin_deskicon_struct;


extern edv_recbin_deskicon_struct *EDVRecBinDeskIconNew(
	gpointer core_ptr
);
extern void EDVRecBinDeskIconUpdate(edv_recbin_deskicon_struct *rbdi);
extern void EDVRecBinDeskIconMap(edv_recbin_deskicon_struct *rbdi);
extern void EDVRecBinDeskIconUnmap(edv_recbin_deskicon_struct *rbdi);
extern void EDVRecBinDeskIconDelete(edv_recbin_deskicon_struct *rbdi);


#endif	/* RECBINDESKICON_H */
