/*
		      Endeavour Utility Functions

	These utils do not depend on any Endeavour or GTK resources.
 */

#ifndef EDVUTILS_H
#define EDVUTILS_H

#include <glib.h>


extern gchar *EDVSizeStrDelim(gulong i);

extern const gchar *EDVGetPathName(const gchar *path);

extern void EDVSimplifyPath(gchar *path);

extern gboolean EDVIsParentPath(const gchar *parent, const gchar *child);
extern gboolean EDVIsExtension(const gchar *name, const gchar *ext);

extern gchar *EDVCopyShortenPath(const gchar *path, gint max);
extern gchar *EDVCopyEvaluateInputPath(
	const gchar *parent, const gchar *input_path
);
extern gint EDVCHDir(const gchar *path);
extern gchar *EDVGetCWD(void);
extern gchar *EDVTmpName(const gchar *dir);
extern gchar *EDVWhich(const gchar *name);

extern void EDVGetDeviceNumbers(gint rdev, gint *major, gint *minor);
extern gint EDVFormatDeviceNumbers(gint major, gint minor);

extern gboolean EDVProcessIsRunning(gint pid);

extern gint EDVSystem(const gchar *cmd);
extern gint EDVSystemBlock(const gchar *cmd, gint *status);

extern GList *EDVOpenFileGList(const gchar *path, gint max_lines);
extern void EDVSaveFileGList(const gchar *path, const GList *glist);


#endif	/* EDVUTILS_H */
