/*
			  Endeavour Find Bar
 */

#ifndef FINDBAR_H
#define FINDBAR_H

#include <sys/stat.h>
#include <gtk/gtk.h>

#include "edvtypes.h"


/*
 *      Find operation codes:
 */
#define EDV_FINDBAR_FIND_OBJECT_NAME		0
#define EDV_FINDBAR_FIND_OBJECT_CONTENT		1

/*
 *	Find roles:
 */
#define EDV_FINDBAR_ROLE_DISK_OBJECT		0
#define EDV_FINDBAR_ROLE_RECYCLED_OBJECT	1
#define EDV_FINDBAR_ROLE_ARCHIVE_OBJECT		2


/*
 *	Find bar structure:
 */
typedef struct {

	gboolean	initialized,
			map_state,
			processing;
	gpointer	core_ptr;
	gint		role;		/* One of EDV_FINDBAR_ROLE_* */
	gint		stop_count;
	GtkWidget	*toplevel,
			*find_op_combo,
			*search_combo,
			*case_sensitive_check,
			*stop_btn;

	/* Status bar message callback */
	void	(*status_message_cb)(
		gpointer,		/* Find bar */
		const gchar *,		/* Message */
		gpointer		/* Data */
	);

	/* Status bar progress callback */
	void	(*status_progress_cb)(
		gpointer,		/* Find bar */
		gfloat,			/* Progress */
		gpointer		/* Data */
	);

	/* Current location callback
	 *
	 * Returns a string of the current location
	 *
	 * Note that this function is only called if the role is set to
	 * EDV_FINDBAR_ROLE_DISK_OBJECT
	 */
	gchar	*(*get_location_cb)(
		gpointer,		/* Find bar */
		gpointer		/* Data */
	);

	/* Find start callback */
	void	(*start_cb)(
		gpointer,		/* Find bar */
		gpointer		/* Data */
	);

	/* Find end callback */
	void	(*end_cb)(
		gpointer,		/* Find bar */
		gint,			/* Total matches */
		gpointer		/* Data */
	);

	/* Matched path callback
	 *
	 * If the role is set to EDV_FINDBAR_ROLE_RECYCLED_OBJECT then
	 * the path is a string containing the index of the recycled
	 * object
	 */
	void	(*match_cb)(
		const gchar *,		/* Path */
		const struct stat *,	/* Local Stats */
		const gchar *,		/* Excerpt */
		gint,			/* Line Index */
		gpointer		/* Data */
	);

	gpointer	client_data;

} edv_findbar_struct;
#define EDV_FINDBAR(p)	((edv_findbar_struct *)(p))


extern void EDVFindBarSetSearch(
	edv_findbar_struct *fb, const gchar *s,
	gboolean record_history
);
extern gint EDVFindBarCurrentFindOP(edv_findbar_struct *fb);

extern edv_findbar_struct *EDVFindBarNew(
	gpointer core_ptr, GtkWidget *parent,
	gint role,		/* One of EDV_FINDBAR_ROLE_* */
	void (*status_message_cb)(gpointer, const gchar *, gpointer),
	void (*status_progress_cb)(gpointer, gfloat, gpointer),
	gchar *(*get_location_cb)(gpointer, gpointer),
	void (*start_cb)(gpointer, gpointer),
	void (*end_cb)(gpointer, gint, gpointer),
	void (*match_cb)(
	    const gchar *, const struct stat *,
	    const gchar *, gint,
	    gpointer
	),
	gpointer client_data
);
extern void EDVFindBarUpdateMenus(edv_findbar_struct *fb);
extern void EDVFindBarMap(edv_findbar_struct *fb);
extern void EDVFindBarUnmap(edv_findbar_struct *fb);
extern void EDVFindBarDelete(edv_findbar_struct *fb);


#endif	/* FINDBAR_H */
