/*
                      Endeavour Configuration List
 */

#ifndef EDVCFGLIST_H
#define EDVCFGLIST_H


/*
 *	Configuration item parameter names:
 */
#define EDV_CFG_PARM_VERSION_MAJOR		"VersionMajor"
#define EDV_CFG_PARM_VERSION_MINOR		"VersionMinor"
#define EDV_CFG_PARM_VERSION_RELEASE		"VersionRelease"

#define EDV_CFG_PARM_DIR_START_UP		"DirectoryStartUp"
#define EDV_CFG_PARM_DIR_LOCAL			"DirectoryLocal"
#define EDV_CFG_PARM_DIR_GLOBAL			"DirectoryGlobal"
#define EDV_CFG_PARM_DIR_TMP			"DirectoryTmp"

#define EDV_CFG_PARM_FILE_RECYCLED_INDEX	"FileRecycledIndex"
#define EDV_CFG_PARM_FILE_MIME_TYPES		"FileMIMETypes"
#define EDV_CFG_PARM_FILE_MIME_TYPES_GLOBAL	"FileMIMETypesGlobal"
#define EDV_CFG_PARM_FILE_DEVICES		"FileDevices"
#define EDV_CFG_PARM_FILE_HISTORY		"FileHistory"
#define EDV_CFG_PARM_FILE_BROWSER_LOCATION_HISTORY	\
						"FileBrowserLocationHistory"
#define EDV_CFG_PARM_FILE_IMBR_LOCATION_HISTORY		\
						"FileImageBrowserLocationHistory"
#define EDV_CFG_PARM_FILE_ARCHIVER_LOCATION_HISTORY	\
						"FileArchiverLocationHistory"
#define EDV_CFG_PARM_FILE_RUNDLG_HISTORY	"FileRunDlgHistory"

#define EDV_CFG_PARM_PROG_DEF_VIEWER		"ProgramDefViewer"
#define EDV_CFG_PARM_PROG_TERMINAL		"ProgramTerminal"
#define EDV_CFG_PARM_PROG_TERMINAL_RUN		"ProgramTerminalRun"
#define EDV_CFG_PARM_PROG_ARJ			"ProgramARJ"
#define EDV_CFG_PARM_PROG_LHA			"ProgramLHA"
#define EDV_CFG_PARM_PROG_RAR			"ProgramRAR"
#define EDV_CFG_PARM_PROG_RPM			"ProgramRPM"
#define EDV_CFG_PARM_PROG_TAR			"ProgramTAR"
#define EDV_CFG_PARM_PROG_ZIP			"ProgramZIP"
#define EDV_CFG_PARM_PROG_UNZIP			"ProgramUnZIP"
#define EDV_CFG_PARM_PROG_COMPRESS		"ProgramCompress"
#define EDV_CFG_PARM_PROG_UNCOMPRESS		"ProgramUnCompress"
#define EDV_CFG_PARM_PROG_GZIP			"ProgramGZIP"
#define EDV_CFG_PARM_PROG_GUNZIP		"ProgramGUNZIP"
#define EDV_CFG_PARM_PROG_BZIP2			"ProgramBZIP2"
#define EDV_CFG_PARM_PROG_BUNZIP2		"ProgramBUNZIP2"
#define EDV_CFG_PARM_PROG_NET_DOWNLOAD		"ProgramNetDownload"
#define EDV_CFG_PARM_PROG_MAIL_CLIENT		"ProgramMailClient"

#define EDV_CFG_PARM_GTK_STYLE_OVERRIDE		"GTKStyleOverride"
#define EDV_CFG_PARM_STYLE_STANDARD		"StyleStandard"
#define EDV_CFG_PARM_STYLE_LISTS		"StyleLists"

#define EDV_CFG_PARM_WRITE_PROTECT		"WriteProtect"

#define EDV_CFG_PARM_RECORD_START_UP_DIR	"RecordStartUpDirectory"

#define EDV_CFG_PARM_LISTS_MIDDLE_CLICK_SCROLL	"ListsMiddleClickScroll"
#define EDV_CFG_PARM_RIGHT_CLICK_MENU_SELECTS	"RightClickMenuSelects"

#define EDV_CFG_PARM_DATE_RELATIVITY		"DateRelativity"
#define EDV_CFG_PARM_DATE_FORMAT		"DateFormat"

#define EDV_CFG_PARM_CONSERVE_MEMORY		"ConserveMemory"
#define EDV_CFG_PARM_IMAGE_QUALITY		"ImageQuality"
#define EDV_CFG_PARM_LISTS_DOUBLE_BUFFER	"ListsDoubleBuffer"
#define EDV_CFG_PARM_LISTS_ANIMATE_UPDATES	"ListsAnimateUpdates"
#define EDV_CFG_PARM_TREE_EXPAND_OPTIMIZE_POS	"TreeExpandOptimizePos"
#define EDV_CFG_PARM_SHOW_TOOLTIPS		"ShowTooltips"
#define EDV_CFG_PARM_SHOW_TEXTTIPS		"ShowTexttips"
#define EDV_CFG_PARM_WINDOW_CASCADE_OFFSET_X	"WindowCascadeOffsetX"
#define EDV_CFG_PARM_WINDOW_CASCADE_OFFSET_Y	"WindowCascadeOffsetY"

#define EDV_CFG_PARM_CONFIRM_COPY		"ConfirmCopy"
#define EDV_CFG_PARM_CONFIRM_MOVE		"ConfirmMove"
#define EDV_CFG_PARM_CONFIRM_LINK		"ConfirmLink"
#define EDV_CFG_PARM_CONFIRM_DELETE		"ConfirmDelete"
#define EDV_CFG_PARM_CONFIRM_ARCHIVE_ADD	"ConfirmArchiveAdd"
#define EDV_CFG_PARM_CONFIRM_ARCHIVE_EXTRACT	"ConfirmArchiveExtract"
#define EDV_CFG_PARM_CONFIRM_ARCHIVE_DELETE	"ConfirmArchiveDelete"
#define EDV_CFG_PARM_CONFIRM_RECOVER		"ConfirmRecover"
#define EDV_CFG_PARM_CONFIRM_PURGE		"ConfirmPurge"
#define EDV_CFG_PARM_CONFIRM_DOWNLOAD		"ConfirmDownload"

#define EDV_CFG_PARM_HISTORY_EVENTS_MAX		"HistoryEventsMax"

#define EDV_CFG_PARM_RECBIN_SIZE_WARN		"RecBinSizeWarn"

#define EDV_CFG_PARM_DELETE_METHOD		"DeleteMethod"

#define EDV_CFG_PARM_ARCHIVE_ADD_COMPRESSION	"ArchiveAddCompression"
#define EDV_CFG_PARM_ARCHIVE_ADD_RECURSIVE	"ArchiveAddRecursive"
#define EDV_CFG_PARM_ARCHIVE_ADD_DEREFERENCE_LINKS	\
						"ArchiveAddDereferenceLinks"
#define EDV_CFG_PARM_ARCHIVE_EXTRACT_PRESERVE_DIR	\
						"ArchiveExtractPreserveDir"
#define EDV_CFG_PARM_ARCHIVE_EXTRACT_PRESERVE_TIMESTAMPS	\
						"ArchiveExtractPreserveTimeStamps"

#define EDV_CFG_PARM_MAILCAP_IMPORT_UPDATE	"MailcapImportUpdate"
#define EDV_CFG_PARM_MAILCAP_IMPORT_ONLY_NEWER	"MailcapImportOnlyNewer"
#define EDV_CFG_PARM_MEDIA_TYPES_IMPORT_UPDATE	"MediaTypesImportUpdate"
#define EDV_CFG_PARM_MEDIA_TYPES_IMPORT_ONLY_NEWER	\
						"MediaTypesImportOnlyNewer"

#define EDV_CFG_PARM_SOUND_USE_SYSTEM		"SoundUseSystem"
#define EDV_CFG_PARM_SOUND_PLAY_BEEP		"SoundPlayBeep"
#define EDV_CFG_PARM_SOUND_PLAY_INFO		"SoundPlayInfo"
#define EDV_CFG_PARM_SOUND_PLAY_QUESTION	"SoundPlayQuestion"
#define EDV_CFG_PARM_SOUND_PLAY_WARNING		"SoundPlayWarning"
#define EDV_CFG_PARM_SOUND_PLAY_ERROR		"SoundPlayError"
#define EDV_CFG_PARM_SOUND_PLAY_COMPLETED	"SoundPlayCompleted"

#define EDV_CFG_PARM_STARTUP_BROWSER		"StartupBrowser"
#define EDV_CFG_PARM_STARTUP_IMBR		"StartupImageBrowser"
#define EDV_CFG_PARM_STARTUP_ARCHIVER		"StartupArchiver"
#define EDV_CFG_PARM_STARTUP_RECBIN		"StartupRecBin"

#define EDV_CFG_PARM_BROWSER_X			"BrowserX"
#define EDV_CFG_PARM_BROWSER_Y			"BrowserY"
#define EDV_CFG_PARM_BROWSER_WIDTH		"BrowserWidth"
#define EDV_CFG_PARM_BROWSER_HEIGHT		"BrowserHeight"
#define EDV_CFG_PARM_BROWSER_PANED_POSITION	"BrowserPanedPosition"
#define EDV_CFG_PARM_BROWSER_TITLE_WITH_USER	"BrowserTitleWithUser"
#define EDV_CFG_PARM_BROWSER_TITLE_WITH_LOCATION	\
						"BrowserTitleWithLocation"
#define EDV_CFG_PARM_BROWSER_SHOW_TOOL_BAR	"BrowserShowToolBar"
#define EDV_CFG_PARM_BROWSER_SHOW_LOCATION_BAR	"BrowserShowLocationBar"
#define EDV_CFG_PARM_BROWSER_SHOW_MOUNT_BAR	"BrowserShowMountBar"
#define EDV_CFG_PARM_BROWSER_SHOW_FIND_BAR	"BrowserShowFindBar"
#define EDV_CFG_PARM_BROWSER_SHOW_STATUS_BAR	"BrowserShowStatusBar"
#define EDV_CFG_PARM_BROWSER_TOOL_BAR		"BrowserToolBar"
#define EDV_CFG_PARM_BROWSER_TOOL_BAR_DISPLAY	"BrowserToolBarDisplay"
#define EDV_CFG_PARM_BROWSER_TOOL_BAR_RELIEF	"BrowserToolBarRelief"
#define EDV_CFG_PARM_BROWSER_DIR_TREE_ORIGIN	"BrowserDirTreeOrigin"
#define EDV_CFG_PARM_BROWSER_CONTENTS_HIDE_DIR_SIZE	\
						"BrowserContentsHideDirSize"
#define EDV_CFG_PARM_BROWSER_CONTENTS_HIDE_LINK_SIZE	\
						"BrowserContentsHideLinkSize"
#define EDV_CFG_PARM_BROWSER_CONTENTS_HIDE_LINK_PERMISSIONS	\
						"BrowserContentsHideLinkPermissions"
#define EDV_CFG_PARM_BROWSER_CONTENTS_COLUMN	"BrowserContentsColumn"
#define EDV_CFG_PARM_BROWSER_CONTENTS_COLUMN_WIDTH	\
						"BrowserContentsColumnWidth"
#define EDV_CFG_PARM_BROWSER_SHOW_OBJECT_HIDDEN	"BrowserShowObjectHidden"
#define EDV_CFG_PARM_BROWSER_SHOW_OBJECT_NOACCESS	\
						"BrowserShowObjectNoAccess"

#define EDV_CFG_PARM_IMBR_X			"ImageBrowserX"
#define EDV_CFG_PARM_IMBR_Y          		"ImageBrowserY"
#define EDV_CFG_PARM_IMBR_WIDTH			"ImageBrowserWidth"
#define EDV_CFG_PARM_IMBR_HEIGHT		"ImageBrowserHeight"
#define EDV_CFG_PARM_IMBR_PANED_POSITION	"ImageBrowserPanedPosition"
#define EDV_CFG_PARM_IMBR_TITLE_WITH_USER	"ImageBrowserTitleWithUser"
#define EDV_CFG_PARM_IMBR_TITLE_WITH_LOCATION	"ImageBrowserTitleWithLocation"
#define EDV_CFG_PARM_IMBR_SHOW_TOOL_BAR		"ImageBrowserShowToolBar"
#define EDV_CFG_PARM_IMBR_SHOW_LOCATION_BAR	"ImageBrowserShowLocationBar"
#define EDV_CFG_PARM_IMBR_SHOW_MOUNT_BAR	"ImageBrowserShowMountBar"
#define EDV_CFG_PARM_IMBR_SHOW_FIND_BAR		"ImageBrowserShowFindBar"
#define EDV_CFG_PARM_IMBR_SHOW_STATUS_BAR	"ImageBrowserShowStatusBar"
#define EDV_CFG_PARM_IMBR_TOOL_BAR		"ImageBrowserToolBar"
#define EDV_CFG_PARM_IMBR_TOOL_BAR_DISPLAY	"ImageBrowserToolBarDisplay"
#define EDV_CFG_PARM_IMBR_TOOL_BAR_RELIEF	"ImageBrowserToolBarRelief"
#define EDV_CFG_PARM_IMBR_COLOR_FG		"ImageBrowserColorFG"
#define EDV_CFG_PARM_IMBR_COLOR_BG		"ImageBrowserColorBG"
#define EDV_CFG_PARM_IMBR_COLOR_BORDER		"ImageBrowserColorBorder"
#define EDV_CFG_PARM_IMBR_THUMB_LIST_HORIZONTAL	"ImageBrowserThumbListHorizontal"
#define EDV_CFG_PARM_IMBR_THUMB_SHOW_FRAMES	"ImageBrowserThumbShowFrames"
#define EDV_CFG_PARM_IMBR_THUMB_SHOW_LABELS	"ImageBrowserThumbShowLabels"
#define EDV_CFG_PARM_IMBR_THUMB_WIDTH		"ImageBrowserThumbWidth"
#define EDV_CFG_PARM_IMBR_THUMB_HEIGHT		"ImageBrowserThumbHeight"
#define EDV_CFG_PARM_IMBR_THUMB_BORDER		"ImageBrowserThumbBorder"
#define EDV_CFG_PARM_IMBR_THUMB_NO_ENLARGE	"ImageBrowserThumbNoEnlarge"
#define EDV_CFG_PARM_IMBR_SHOW_OBJECT_HIDDEN	"ImageBrowserShowObjectHidden"
#define EDV_CFG_PARM_IMBR_SHOW_OBJECT_NOACCESS	"ImageBrowserShowObjectNoAccess"
#define EDV_CFG_PARM_IMBR_SHOW_OBJECT_NONIMAGE	"ImageBrowserShowObjectNonImage"

#define EDV_CFG_PARM_RECBIN_X			"RecBinX"
#define EDV_CFG_PARM_RECBIN_Y			"RecBinY"
#define EDV_CFG_PARM_RECBIN_WIDTH		"RecBinWidth"
#define EDV_CFG_PARM_RECBIN_HEIGHT		"RecBinHeight"
#define EDV_CFG_PARM_RECBIN_SHOW_DESKTOP_ICON	"RecBinShowDesktopIcon"
#define EDV_CFG_PARM_RECBIN_DESKTOP_ICON_X	"RecBinDesktopIconX"
#define EDV_CFG_PARM_RECBIN_DESKTOP_ICON_Y	"RecBinDesktopIconY"
#define EDV_CFG_PARM_RECBIN_TITLE_WITH_USER	"RecBinTitleWithUser"
#define EDV_CFG_PARM_RECBIN_SHOW_TOOL_BAR	"RecBinShowToolBar"
#define EDV_CFG_PARM_RECBIN_SHOW_FIND_BAR	"RecBinShowFindBar"
#define EDV_CFG_PARM_RECBIN_SHOW_STATUS_BAR	"RecBinShowStatusBar"
#define EDV_CFG_PARM_RECBIN_TOOL_BAR		"RecBinToolBar"
#define EDV_CFG_PARM_RECBIN_TOOL_BAR_DISPLAY	"RecBinToolBarDisplay"
#define EDV_CFG_PARM_RECBIN_TOOL_BAR_RELIEF	"RecBinToolBarRelief"
#define EDV_CFG_PARM_RECBIN_CONTENTS_HIDE_DIR_SIZE	\
						"RecBinContentsHideDirSize"
#define EDV_CFG_PARM_RECBIN_CONTENTS_HIDE_LINK_SIZE	\
						"RecBinContentsHideLinkSize"
#define EDV_CFG_PARM_RECBIN_CONTENTS_HIDE_LINK_PERMISSIONS	\
						"RecBinContentsHideLinkPermissions"
#define EDV_CFG_PARM_RECBIN_CONTENTS_COLUMN	"RecBinContentsColumn"
#define EDV_CFG_PARM_RECBIN_CONTENTS_COLUMN_WIDTH	\
						"RecBinContentsColumnWidth"

#define EDV_CFG_PARM_ARCHIVER_X			"ArchiverX"
#define EDV_CFG_PARM_ARCHIVER_Y			"ArchiverY"
#define EDV_CFG_PARM_ARCHIVER_WIDTH		"ArchiverWidth"
#define EDV_CFG_PARM_ARCHIVER_HEIGHT		"ArchiverHeight"
#define EDV_CFG_PARM_ARCHIVER_TITLE_WITH_USER	"ArchiverTitleWithUser"
#define EDV_CFG_PARM_ARCHIVER_TITLE_WITH_LOCATION	\
						"ArchiverTitleWithLocation"
#define EDV_CFG_PARM_ARCHIVER_SHOW_ARCHIVE_INFO_ON_OPEN	\
						"ArchiverShowArchiveInfoOnOpen"
#define EDV_CFG_PARM_ARCHIVER_SHOW_TOOL_BAR	"ArchiverShowToolBar"
#define EDV_CFG_PARM_ARCHIVER_SHOW_LOCATION_BAR	"ArchiverShowLocationBar"
#define EDV_CFG_PARM_ARCHIVER_SHOW_FIND_BAR	"ArchiverShowFindBar"
#define EDV_CFG_PARM_ARCHIVER_SHOW_STATUS_BAR	"ArchiverShowStatusBar"
#define EDV_CFG_PARM_ARCHIVER_TOOL_BAR		"ArchiverToolBar"
#define EDV_CFG_PARM_ARCHIVER_TOOL_BAR_DISPLAY	"ArchiverToolBarDisplay"
#define EDV_CFG_PARM_ARCHIVER_TOOL_BAR_RELIEF	"ArchiverToolBarRelief"
#define EDV_CFG_PARM_ARCHIVER_CONTENTS_HIDE_DIR_SIZE	\
						"ArchiverContentsHideDirSize"
#define EDV_CFG_PARM_ARCHIVER_CONTENTS_HIDE_LINK_SIZE	\
						"ArchiverContentsHideLinkSize"
#define EDV_CFG_PARM_ARCHIVER_CONTENTS_HIDE_LINK_PERMISSIONS	\
						"ArchiverContentsHideLinkPermissions"
#define EDV_CFG_PARM_ARCHIVER_CONTENTS_COLUMN	"ArchiverContentsColumn"
#define EDV_CFG_PARM_ARCHIVER_CONTENTS_COLUMN_WIDTH	\
						"ArchiverContentsColumnWidth"

#define EDV_CFG_PARM_FINDWIN_X			"FindWinX"
#define EDV_CFG_PARM_FINDWIN_Y			"FindWinY"
#define EDV_CFG_PARM_FINDWIN_WIDTH		"FindWinWidth"
#define EDV_CFG_PARM_FINDWIN_HEIGHT		"FindWinHeight"
#define EDV_CFG_PARM_FINDWIN_SEARCH_STRING	"FindWinSearchString"
#define EDV_CFG_PARM_FINDWIN_FIND_OP		"FindWinFindOperation"
#define EDV_CFG_PARM_FINDWIN_CASE_SENSITIVE	"FindWinCaseSensitive"
#define EDV_CFG_PARM_FINDWIN_RECURSIVE		"FindWinRecursive"

#define EDV_CFG_PARM_RUNDLG_X			"RunDlgX"
#define EDV_CFG_PARM_RUNDLG_Y			"RunDlgY"
#define EDV_CFG_PARM_RUNDLG_RUN_IN_TERMINAL	"RunDlgRunInTerminal"
#define EDV_CFG_PARM_RUNDLG_KEEP_DIALOG		"RunDlgKeepDialog"
#define EDV_CFG_PARM_RUNDLG_LAST_WORKING_DIR	"RunDlgLastWorkingDir"


/*
 *	Configuration list:
 *
 *	Values are <type> <parm> <value_ptr>.
 *	See edvcfg.h for a list of valid values for <type>.
 *	Initial value for <value_ptr> should always be NULL.
 *
 *	This configuration list should be initialized in
 *	EDVDoCreateStandardConfiguration() in main.c
 */
#define EDV_CONFIGURATION_LIST					\
{								\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_VERSION_MAJOR, NULL },	\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_VERSION_MINOR, NULL },	\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_VERSION_RELEASE, NULL },	\
								\
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_DIR_START_UP, NULL },	\
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_DIR_GLOBAL, NULL },	\
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_DIR_LOCAL, NULL },		\
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_DIR_TMP, NULL },		\
								\
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_FILE_RECYCLED_INDEX, NULL }, \
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_FILE_MIME_TYPES, NULL },	\
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_FILE_MIME_TYPES_GLOBAL, NULL }, \
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_FILE_DEVICES, NULL },	\
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_FILE_HISTORY, NULL },	\
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_FILE_BROWSER_LOCATION_HISTORY, NULL }, \
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_FILE_IMBR_LOCATION_HISTORY, NULL }, \
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_FILE_ARCHIVER_LOCATION_HISTORY, NULL }, \
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_FILE_RUNDLG_HISTORY, NULL }, \
								\
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_PROG_DEF_VIEWER, NULL },	\
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_PROG_TERMINAL, NULL },	\
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_PROG_TERMINAL_RUN, NULL },	\
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_PROG_ARJ, NULL },		\
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_PROG_LHA, NULL },		\
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_PROG_RAR, NULL },		\
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_PROG_RPM, NULL },		\
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_PROG_TAR, NULL },		\
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_PROG_ZIP, NULL },		\
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_PROG_UNZIP, NULL },	\
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_PROG_COMPRESS, NULL },	\
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_PROG_UNCOMPRESS, NULL },	\
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_PROG_GZIP, NULL },		\
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_PROG_GUNZIP, NULL },	\
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_PROG_BZIP2, NULL },	\
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_PROG_BUNZIP2, NULL },	\
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_PROG_NET_DOWNLOAD, NULL }, \
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_PROG_MAIL_CLIENT, NULL },	\
								\
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_GTK_STYLE_OVERRIDE, NULL }, \
{ CFG_ITEM_TYPE_STYLE, EDV_CFG_PARM_STYLE_STANDARD, NULL },	\
{ CFG_ITEM_TYPE_STYLE, EDV_CFG_PARM_STYLE_LISTS, NULL },	\
								\
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_WRITE_PROTECT, NULL },	\
								\
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_RECORD_START_UP_DIR, NULL }, \
								\
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_LISTS_MIDDLE_CLICK_SCROLL, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_RIGHT_CLICK_MENU_SELECTS, NULL }, \
								\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_DATE_RELATIVITY, NULL },	\
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_DATE_FORMAT, NULL },	\
								\
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_CONSERVE_MEMORY, NULL },	\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_IMAGE_QUALITY, NULL },	\
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_LISTS_DOUBLE_BUFFER, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_LISTS_ANIMATE_UPDATES, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_TREE_EXPAND_OPTIMIZE_POS, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_SHOW_TOOLTIPS, NULL },	\
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_SHOW_TEXTTIPS, NULL },	\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_WINDOW_CASCADE_OFFSET_X, NULL }, \
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_WINDOW_CASCADE_OFFSET_Y, NULL }, \
								\
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_CONFIRM_COPY, NULL },	\
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_CONFIRM_MOVE, NULL },	\
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_CONFIRM_LINK, NULL },	\
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_CONFIRM_DELETE, NULL },	\
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_CONFIRM_ARCHIVE_ADD, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_CONFIRM_ARCHIVE_EXTRACT, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_CONFIRM_ARCHIVE_DELETE, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_CONFIRM_RECOVER, NULL },	\
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_CONFIRM_PURGE, NULL },	\
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_CONFIRM_DOWNLOAD, NULL },	\
								\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_HISTORY_EVENTS_MAX, NULL },	\
{ CFG_ITEM_TYPE_UINT64, EDV_CFG_PARM_RECBIN_SIZE_WARN, NULL },	\
								\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_DELETE_METHOD, NULL},	\
								\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_ARCHIVE_ADD_COMPRESSION, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_ARCHIVE_ADD_RECURSIVE, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_ARCHIVE_ADD_DEREFERENCE_LINKS, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_ARCHIVE_EXTRACT_PRESERVE_DIR, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_ARCHIVE_EXTRACT_PRESERVE_TIMESTAMPS, NULL }, \
								\
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_MAILCAP_IMPORT_UPDATE, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_MAILCAP_IMPORT_ONLY_NEWER, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_MEDIA_TYPES_IMPORT_UPDATE, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_MEDIA_TYPES_IMPORT_ONLY_NEWER, NULL }, \
								\
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_SOUND_USE_SYSTEM, NULL },	\
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_SOUND_PLAY_BEEP, NULL },	\
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_SOUND_PLAY_INFO, NULL },	\
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_SOUND_PLAY_QUESTION, NULL }, \
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_SOUND_PLAY_WARNING, NULL }, \
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_SOUND_PLAY_ERROR, NULL },	\
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_SOUND_PLAY_COMPLETED, NULL }, \
								\
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_STARTUP_BROWSER, NULL },	\
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_STARTUP_IMBR, NULL },	\
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_STARTUP_ARCHIVER, NULL} ,	\
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_STARTUP_RECBIN, NULL },	\
								\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_BROWSER_X, NULL },		\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_BROWSER_Y, NULL },		\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_BROWSER_WIDTH, NULL },	\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_BROWSER_HEIGHT, NULL },	\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_BROWSER_PANED_POSITION, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_BROWSER_TITLE_WITH_USER, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_BROWSER_TITLE_WITH_LOCATION, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_BROWSER_SHOW_TOOL_BAR, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_BROWSER_SHOW_LOCATION_BAR, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_BROWSER_SHOW_MOUNT_BAR, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_BROWSER_SHOW_FIND_BAR, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_BROWSER_SHOW_STATUS_BAR, NULL }, \
{ CFG_ITEM_TYPE_INTLIST, EDV_CFG_PARM_BROWSER_TOOL_BAR, NULL },	\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_BROWSER_TOOL_BAR_DISPLAY, NULL }, \
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_BROWSER_TOOL_BAR_RELIEF, NULL }, \
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_BROWSER_DIR_TREE_ORIGIN, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_BROWSER_CONTENTS_HIDE_DIR_SIZE, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_BROWSER_CONTENTS_HIDE_LINK_SIZE, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_BROWSER_CONTENTS_HIDE_LINK_PERMISSIONS, NULL }, \
{ CFG_ITEM_TYPE_INTLIST, EDV_CFG_PARM_BROWSER_CONTENTS_COLUMN, NULL }, \
{ CFG_ITEM_TYPE_INTLIST, EDV_CFG_PARM_BROWSER_CONTENTS_COLUMN_WIDTH, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_BROWSER_SHOW_OBJECT_HIDDEN, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_BROWSER_SHOW_OBJECT_NOACCESS, NULL }, \
								\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_IMBR_X, NULL },		\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_IMBR_Y, NULL },		\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_IMBR_WIDTH, NULL },		\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_IMBR_HEIGHT, NULL },	\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_IMBR_PANED_POSITION, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_IMBR_TITLE_WITH_USER, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_IMBR_TITLE_WITH_LOCATION, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_IMBR_SHOW_TOOL_BAR, NULL },	\
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_IMBR_SHOW_LOCATION_BAR, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_IMBR_SHOW_MOUNT_BAR, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_IMBR_SHOW_FIND_BAR, NULL },	\
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_IMBR_SHOW_STATUS_BAR, NULL }, \
{ CFG_ITEM_TYPE_INTLIST, EDV_CFG_PARM_IMBR_TOOL_BAR, NULL },	\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_IMBR_TOOL_BAR_DISPLAY, NULL }, \
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_IMBR_TOOL_BAR_RELIEF, NULL }, \
{ CFG_ITEM_TYPE_COLOR, EDV_CFG_PARM_IMBR_COLOR_FG, NULL },	\
{ CFG_ITEM_TYPE_COLOR, EDV_CFG_PARM_IMBR_COLOR_BG, NULL },	\
{ CFG_ITEM_TYPE_COLOR, EDV_CFG_PARM_IMBR_COLOR_BORDER, NULL },	\
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_IMBR_THUMB_LIST_HORIZONTAL, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_IMBR_THUMB_SHOW_FRAMES, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_IMBR_THUMB_SHOW_LABELS, NULL }, \
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_IMBR_THUMB_WIDTH, NULL },	\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_IMBR_THUMB_HEIGHT, NULL },	\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_IMBR_THUMB_BORDER, NULL },	\
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_IMBR_THUMB_NO_ENLARGE, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_IMBR_SHOW_OBJECT_HIDDEN, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_IMBR_SHOW_OBJECT_NOACCESS, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_IMBR_SHOW_OBJECT_NONIMAGE, NULL }, \
								\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_RECBIN_X, NULL },		\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_RECBIN_Y, NULL },		\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_RECBIN_WIDTH, NULL },	\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_RECBIN_HEIGHT, NULL },	\
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_RECBIN_SHOW_DESKTOP_ICON, NULL }, \
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_RECBIN_DESKTOP_ICON_X, NULL }, \
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_RECBIN_DESKTOP_ICON_Y, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_RECBIN_TITLE_WITH_USER, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_RECBIN_SHOW_TOOL_BAR, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_RECBIN_SHOW_FIND_BAR, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_RECBIN_SHOW_STATUS_BAR, NULL }, \
{ CFG_ITEM_TYPE_INTLIST, EDV_CFG_PARM_RECBIN_TOOL_BAR, NULL },	\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_RECBIN_TOOL_BAR_DISPLAY, NULL }, \
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_RECBIN_TOOL_BAR_RELIEF, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_RECBIN_CONTENTS_HIDE_DIR_SIZE, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_RECBIN_CONTENTS_HIDE_LINK_SIZE, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_RECBIN_CONTENTS_HIDE_LINK_PERMISSIONS, NULL }, \
{ CFG_ITEM_TYPE_INTLIST, EDV_CFG_PARM_RECBIN_CONTENTS_COLUMN, NULL }, \
{ CFG_ITEM_TYPE_INTLIST, EDV_CFG_PARM_RECBIN_CONTENTS_COLUMN_WIDTH, NULL }, \
								\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_ARCHIVER_X, NULL },		\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_ARCHIVER_Y, NULL },		\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_ARCHIVER_WIDTH, NULL },	\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_ARCHIVER_HEIGHT, NULL },	\
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_ARCHIVER_TITLE_WITH_USER, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_ARCHIVER_TITLE_WITH_LOCATION, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_ARCHIVER_SHOW_ARCHIVE_INFO_ON_OPEN, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_ARCHIVER_SHOW_TOOL_BAR, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_ARCHIVER_SHOW_LOCATION_BAR, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_ARCHIVER_SHOW_FIND_BAR, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_ARCHIVER_SHOW_STATUS_BAR, NULL }, \
{ CFG_ITEM_TYPE_INTLIST, EDV_CFG_PARM_ARCHIVER_TOOL_BAR, NULL }, \
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_ARCHIVER_TOOL_BAR_DISPLAY, NULL }, \
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_ARCHIVER_TOOL_BAR_RELIEF, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_ARCHIVER_CONTENTS_HIDE_DIR_SIZE, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_ARCHIVER_CONTENTS_HIDE_LINK_SIZE, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_ARCHIVER_CONTENTS_HIDE_LINK_PERMISSIONS, NULL }, \
{ CFG_ITEM_TYPE_INTLIST, EDV_CFG_PARM_ARCHIVER_CONTENTS_COLUMN, NULL }, \
{ CFG_ITEM_TYPE_INTLIST, EDV_CFG_PARM_ARCHIVER_CONTENTS_COLUMN_WIDTH, NULL }, \
								\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_FINDWIN_X, NULL },		\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_FINDWIN_Y, NULL },		\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_FINDWIN_WIDTH, NULL },	\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_FINDWIN_HEIGHT, NULL },	\
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_FINDWIN_SEARCH_STRING, NULL }, \
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_FINDWIN_FIND_OP, NULL },	\
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_FINDWIN_CASE_SENSITIVE, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_FINDWIN_RECURSIVE, NULL },	\
								\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_RUNDLG_X, NULL },		\
{ CFG_ITEM_TYPE_INT32, EDV_CFG_PARM_RUNDLG_Y, NULL },		\
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_RUNDLG_RUN_IN_TERMINAL, NULL }, \
{ CFG_ITEM_TYPE_UINT8, EDV_CFG_PARM_RUNDLG_KEEP_DIALOG, NULL },	\
{ CFG_ITEM_TYPE_STRING, EDV_CFG_PARM_RUNDLG_LAST_WORKING_DIR, NULL }, \
								\
/* Last item must be all 0's. */				\
{ CFG_ITEM_TYPE_NONE, NULL, NULL }				\
}


/*
 *	Configuration Get Macros:
 */
#define EDV_GET_B(_parm_)	( \
 (CFGItemListGetValueI(cfg_list, (_parm_))) ? (TRUE) : (FALSE) \
)
#define EDV_GET_I(_parm_)	(CFGItemListGetValueI(cfg_list, (_parm_)))
#define EDV_GET_L(_parm_)	(CFGItemListGetValueL(cfg_list, (_parm_)))
#define EDV_GET_UL(_parm_)	(CFGItemListGetValueUL(cfg_list, (_parm_)))
#define EDV_GET_F(_parm_)	(CFGItemListGetValueF(cfg_list, (_parm_)))
#define EDV_GET_D(_parm_)	(CFGItemListGetValueD(cfg_list, (_parm_)))
#define EDV_GET_S(_parm_)	(CFGItemListGetValueS(cfg_list, (_parm_)))
#define EDV_GET_COLOR(_parm_)	(CFGItemListGetValueColor(cfg_list, (_parm_)))
#define EDV_GET_INTLIST(_parm_)	(CFGItemListGetValueIntList(cfg_list, (_parm_)))
#define EDV_GET_STYLE(_parm_)	(CFGItemListGetValueStyle(cfg_list, (_parm_)))

/*
 *	Configuration Set Macros:
 */
#define EDV_SET_B(_parm_,_v_)	(CFGItemListSetValueI( \
 cfg_list, (_parm_), (_v_) ? (TRUE) : (FALSE), (FALSE) \
))
#define EDV_SET_I(_parm_,_v_)	(CFGItemListSetValueI( \
 cfg_list, (_parm_), (_v_), (FALSE) \
))
#define EDV_SET_L(_parm_,_v_)	(CFGItemListSetValueL( \
 cfg_list, (_parm_), (_v_), (FALSE) \
))
#define EDV_SET_UL(_parm_,_v_)	(CFGItemListSetValueUL( \
 cfg_list, (_parm_), (_v_), (FALSE) \
))
#define EDV_SET_F(_parm_,_v_)	(CFGItemListSetValueF( \
 cfg_list, (_parm_), (_v_), (FALSE) \
))
#define EDV_SET_D(_parm_,_v_)	(CFGItemListSetValueD( \
 cfg_list, (_parm_), (_v_), (FALSE) \
))
#define EDV_SET_S(_parm_,_v_)	(CFGItemListSetValueS( \
 cfg_list, (_parm_), (_v_), (FALSE) \
))
#define EDV_SET_COLOR(_parm_,_v_)	(CFGItemListSetValueColor( \
 cfg_list, (_parm_), (_v_), (FALSE) \
))
#define EDV_SET_INTLIST(_parm_,_v_)	(CFGItemListSetValueIntList( \
 cfg_list, (_parm_), (_v_), (FALSE) \
))
#define EDV_SET_STYLE(_parm_,_v_)	(CFGItemListSetValueStyle( \
 cfg_list, (_parm_), (_v_), (FALSE) \
))


#endif	/* EDVCFGLIST_H */
