/*
                               Open Objects
 */

#ifndef EDVOPEN_H
#define EDVOPEN_H

#include <glib.h>
#include "edvcontext.h"


/*
 *      Instructs the Endeavour program to open an object by checking
 *      the object's extension and matching it through its MIME Types
 *      list.  If a method to open the object is found, then that method
 *      will be used to open the object.
 *
 *      If command_name is not NULL then the specific command's name
 *      (defined by the matched MIME Type) will be used (otherwise the
 *      default command will be used).
 *
 *	Typical values for command_name are; "default", "view",
 *	and "edit". However it is difficult to know what the user has
 *	set so it is recommended that command_name be left NULL.
 */
extern void EDVOpen(
	edv_context_struct *ctx,
	const gchar *path, const gchar *command_name
);


#endif	/* EDVOPEN_H */
