/*
           Endeavour Download Front End Compile Time Configuration
 */

#ifndef CONFIG_DOWNLOAD_H
#define CONFIG_DOWNLOAD_H

#include "../config.h"


/*
 *      Program name and version:
 */
#ifdef PROG_NAME
# undef PROG_NAME
#endif
#define PROG_NAME	"Download"

#ifdef PROG_NAME_FULL
# undef PROG_NAME_FULL
#endif
#define PROG_NAME_FULL	"Download"



/*
 *	Standard output help message:
 */
#ifdef PROG_HELP_MESG
# undef PROG_HELP_MESG
#endif

#ifdef PROG_LANGUAGE_ENGLISH
#define PROG_HELP_MESG  "\
Usage: download.front <source_url> <target_path> [options] [GUI_options]\n\
\n\
    <source_url> specifies the url of the object to download.\n\
\n\
    <target_path> specifies the path to the destination object.\n\
\n\
    [options] can be any of the following:\n\
\n\
        -b, --beep              Beep when download is complete.\n\
        -c, --confirm           Query user for confirmation before download.\n\
        -o, --open              Open object (if download was successful).\n\
        -l, --last              (Re)download last object.\n\
        --help                  Prints (this) help screen and exits.\n\
        --version               Prints version information and exits.\n\
\n\
    [GUI_options] can be any options standard to your GUI, consult\n\
    your GUI's manual for available options.\n\
\n"
#endif
#ifdef PROG_LANGUAGE_SPANISH
#define PROG_HELP_MESG	"\
El uso: download.front <source_url> <target_path> [options] [GUI_options]\n\
\n\
    <source_url> especifica el url del objeto para cargar.\n\
\n\
    <target_path> especifica el sendero al objeto del destino.\n\
\n\
    [options] puede ser cualquiera de lo Siguiente:\n\
\n\
	-b, --beep              Pip pip cuando carga es completo.\n\
        -c, --confirm           El usuario de la pregunta para la confirmacin carga antes.\n\
        -o, --open              El objeto abierto (si carga tuvo xito).\n\
        -l, --last              (Re)cargar ltimo objeto.\n\
        --help                  Pantalla de ayuda de Impresiones (esto) de ayuda y salidas.\n\
        --version               Versin Imprime informacin de versin y salidas.\n\
\n\
    [GUI_options] puede ser cualquier estndar de las opcin a su GUI,\n\
    consulta su manual de GUI para opciones disponibles.\n\
\n"
#endif
#ifdef PROG_LANGUAGE_FRENCH
#define PROG_HELP_MESG  "\
L'usage: download.front <source_url> <target_path> [options] [GUI_options]\n\
\n\
    <source_url> spcifie le url de l'objet pour charger.\n\
\n\
    <target_path> spcifie le sentier  l'objet de destination.\n\
\n\
    [options] peut tre n'importe quel du suivre:\n\
\n\
        -b, --beep              La sonnerie quand charge est complet.\n\
        -c, --confirm           L'utilisateur de question pour la confirmation avant le chargement.\n\
        -o, --open              L'objet ouvert (si charge russissait).\n\
        -l, --last              (Re)charger dernier objet.\n\
        --help                  Caractres (ceci) aide cran et sorties.\n\
        --version               Caractres information de version et sorties.\n\
\n\
    [GUI_options] peut tre n'importe quelle norme d'options  votre\n\
    GUI, consulter le manuel de votre GUI pour les options disponibles.\n\
\n"
#endif


/* 
 *	Download programs:
 *
 *	Do not specify full path in order to allow automatic locating
 *	by checking locations specified in the PATH environment.
 */
#define WGET_PROG		"wget"


#endif	/* CONFIG_DOWNLOAD_H */
