/*
		Endeavour Image Browser Operation Callbacks
 */

#ifndef IMBROPCB_H
#define IMBROPCB_H

#include <gtk/gtk.h>
#include "toolbar.h"
#include "edvtypes.h"
#include "edvdevices.h"
#include "mountbar.h"
#include "findbar.h"
#include "statusbar.h"
#include "imbr.h"


extern void EDVImbrMenuItemCB(GtkWidget *widget, gpointer data);
extern gint EDVImbrMenuItemEnterCB(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern gint EDVImbrMenuItemLeaveCB(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);

extern void EDVImbrOPCB(
	toolbar_item_struct *item, gint id, gpointer data
);
extern void EDVImbrOPEnterCB(
	toolbar_item_struct *item, gint id, gpointer data
);
extern void EDVImbrOPLeaveCB(
	toolbar_item_struct *item, gint id, gpointer data
);

extern void EDVImbrMountBarMountCB(
	edv_mountbar_struct *mb, gint dev_num, edv_device_struct *dev,
	gpointer data
);
extern void EDVImbrMountBarEjectCB(
	edv_mountbar_struct *mb, gint dev_num, edv_device_struct *dev,
	gpointer data
);
extern void EDVImbrMountBarGoToCB(
	edv_mountbar_struct *mb, gint dev_num, edv_device_struct *dev,
	gpointer data
);

extern const gchar *EDVImbrFindBarLocationCB(
	edv_findbar_struct *fb, gpointer data
);
extern void EDVImbrFindBarStartCB(edv_findbar_struct *fb, gpointer data);
extern void EDVImbrFindBarEndCB(
	edv_findbar_struct *fb, gint total_matches, gpointer data
);
extern void EDVImbrFindBarMatchCB(
	const gchar *path, const struct stat *lstat_buf,
	const gchar *excerpt, gint line_index,
	gpointer data
);

extern void EDVImbrStatusMessageCB(const gchar *message, gpointer data);
extern void EDVImbrStatusProgressCB(gfloat progress, gpointer data);

extern void EDVImbrOPSyncDisks(edv_imbr_struct *imbr);
extern void EDVImbrOPWriteProtect(edv_imbr_struct *imbr);

extern void EDVImbrOPClose(edv_imbr_struct *imbr);
extern void EDVImbrOPExit(edv_imbr_struct *imbr);

extern void EDVImbrOPNewObject(
	edv_imbr_struct *imbr, toolbar_item_struct *item
);
extern void EDVImbrOPNewFile(edv_imbr_struct *imbr);
extern void EDVImbrOPNewDirectory(edv_imbr_struct *imbr);
extern void EDVImbrOPNewLink(edv_imbr_struct *imbr);
extern void EDVImbrOPNewFifo(edv_imbr_struct *imbr);
extern void EDVImbrOPNewDeviceBlock(edv_imbr_struct *imbr);
extern void EDVImbrOPNewDeviceCharacter(edv_imbr_struct *imbr);
extern void EDVImbrOPNewSocket(edv_imbr_struct *imbr);

extern void EDVImbrOPOpen(edv_imbr_struct *imbr);
extern void EDVImbrOPOpenWith(edv_imbr_struct *imbr);

extern void EDVImbrOPMove(edv_imbr_struct *imbr);
extern void EDVImbrOPCopy(edv_imbr_struct *imbr);
extern void EDVImbrOPLink(edv_imbr_struct *imbr);
extern void EDVImbrOPRename(edv_imbr_struct *imbr);
extern void EDVImbrOPDelete(edv_imbr_struct *imbr);
extern void EDVImbrOPProperties(edv_imbr_struct *imbr);

extern void EDVImbrOPCopyPath(edv_imbr_struct *imbr);
extern void EDVImbrOPCopyURL(edv_imbr_struct *imbr);

extern void EDVImbrOPRefresh(edv_imbr_struct *imbr);
extern void EDVImbrOPRefreshAll(edv_imbr_struct *imbr);
extern void EDVImbrOPStop(edv_imbr_struct *imbr);
extern void EDVImbrOpContinue(edv_imbr_struct *imbr);
extern void EDVImbrOpPresentationMode(edv_imbr_struct *imbr);

extern void EDVImbrOPDownload(edv_imbr_struct *imbr);


#endif	/* IMBROPCB_H */
