/*
			       Open Objects
 */

#ifndef EDVOPEN_H
#define EDVOPEN_H

#include <glib.h>
#include "edvcontext.h"


/*
 *	Opens the object(s) specified by the list of strings paths_list.
 *
 *	If command_name is not NULL then the command on the associated
 *	MIME Type who's name matches command_name will be used.
 *
 *	Typical values for command_name are; "default", "view",
 *	and "edit". However it is difficult to know what the user has
 *	set so it is recommended that you pass command_name as NULL
 *	when unsure.
 *
 *	Returns:
 *
 *	0	Success.
 *	-1	General error.
 *	-2	Bad value or no MIME Type found.
 *	-3	System error.
 */
extern gint EDVOpen(
	edv_context_struct *ctx,
	GList *paths_list, const gchar *command_name
);


#endif	/* EDVOPEN_H */
