/*
		      Universal Resource Location
 */

#ifndef URL_H
#define URL_H

#include <glib.h>


/*
 *	URL Flags:
 */
typedef enum {

	URL_PATH_RELATIVE		= (1 << 0)

} url_flags;

/*
 *	URL:
 */
typedef struct _url_struct		url_struct;
struct _url_struct {

	url_flags	flags;

	/* Protocol ("file", "ftp", "http", "https", etc) */
	gchar		*protocol;

	/* User & Password (may be NULL for none) */
	gchar		*user,
			*password;

	/* Host & Port Number (host may be NULL for none and port
	 * may be 0 for default)
	 */
	gchar		*host;
	gint		port;

	/* Path or Marker (may be NULL for none) */
	gchar		*path;

	/* Path argument, after the '?' character (may be NULL for
	 * none)
	 */
	gchar		*path_arg;

};
#define URL(p)	((url_struct *)(p))


extern url_struct *URLNew(void);
extern url_struct *URLNewWithValues(
	url_flags flags,
	const gchar *protocol,
	const gchar *user,
	const gchar *password,
	const gchar *host,
	gint port,
	const gchar *path,
	const gchar *path_arg
);
extern url_struct *URLNewFromURLString(const gchar *url_str);
extern url_struct *URLCopy(const url_struct *url);
extern void URLDelete(url_struct *url);

extern guint8 *URLEncode(GList *glist, gint *buf_len);
extern GList *URLDecode(const guint8 *buf, gint buf_len);
extern GList *URLDecodeString(const gchar *s);

extern gchar *URLTokenize(const gchar *url_str);
extern gchar *URLDetokenize(const gchar *url_str);


#endif	/* URL_H */
