/*
                            Endeavour Object
 */

#ifndef EDV_OBJ_H
#define EDV_OBJ_H

#include <sys/types.h>
#include <sys/stat.h>
#include <glib.h>
#include "edv_types.h"


typedef struct _edv_object_struct	edv_object_struct;
#define EDV_OBJECT(p)	((edv_object_struct *)(p))


/*
 *	Link Flags:
 */
typedef enum {
	EDV_OBJECT_LINK_VALID		= (1 << 0),	/* Not dangling */
	EDV_OBJECT_LINK_TAR_DIRECTORY	= (1 << 1),	/* Ultimately links to
							 * a directory */
	EDV_OBJECT_LINK_TAR_GRAND_PARENT = (1 << 2)	/* Target is a grand
							 * parent, hints
							 * infinate recursion */
} edv_object_link_flags;


/*
 *	Object:
 */
struct _edv_object_struct {

	edv_object_type	type;

	gchar		*name;
	gchar		*full_path;

	gchar		*link_value;	/* Only for type EDV_OBJECT_TYPE_LINK */
	edv_object_link_flags	link_flags;	/* Only for type
						 * EDV_OBJECT_TYPE_LINK */

	edv_permission_flags	permissions;

	gulong		access_time,	/* In systime seconds */
			modify_time,
			change_time;

	gint		owner_id,
			group_id;

	gint		hard_links;	/* Number of hard links */

	gulong		size;		/* In bytes */

	gulong		device;		/* Device address */
	gulong		inode;		/* Address on device */

	gint		device_type;	/* Device major and minor numbers
					 * (used only if object type is
					 * one of EDV_OBJECT_TYPE_DEVICE_*
					 *
					 * Use EDVGetDeviceNumbers() to
					 * parse this value casted as a
					 * (dev_t)
					 */

	gulong		block_size;	/* Optimul block transfer size,
					 * in bytes 
					 */

	gulong		blocks;		/* Blocks allocated to this object */

};

#define EDV_OBJECT_IS_FILE(p)		(((p) != NULL) ? \
 ((p)->type == EDV_OBJECT_TYPE_FILE) : FALSE)
#define EDV_OBJECT_IS_DIRECTORY(p)	(((p) != NULL) ? \
 ((p)->type == EDV_OBJECT_TYPE_DIRECTORY) : FALSE)
#define EDV_OBJECT_IS_LINK(p)		(((p) != NULL) ? \
 ((p)->type == EDV_OBJECT_TYPE_LINK) : FALSE)
#define EDV_OBJECT_IS_DEVICE_BLOCK(p)	(((p) != NULL) ? \
 ((p)->type == EDV_OBJECT_TYPE_DEVICE_BLOCK) : FALSE)
#define EDV_OBJECT_IS_DEVICE_CHARACTER(p)	(((p) != NULL) ? \
 ((p)->type == EDV_OBJECT_TYPE_DEVICE_CHARACTER) : FALSE)
#define EDV_OBJECT_IS_FIFO(p)		(((p) != NULL) ? \
 ((p)->type == EDV_OBJECT_TYPE_FIFO) : FALSE)
#define EDV_OBJECT_IS_SOCKET(p)           (((p) != NULL) ? \
 ((p)->type == EDV_OBJECT_TYPE_SOCKET) : FALSE)

#define EDV_OBJECT_IS_LINK_VALID(p)	(((p) != NULL) ? \
 ((p)->link_flags & EDV_OBJECT_LINK_VALID) : FALSE)
#define EDV_OBJECT_IS_LINK_TAR_DIRECTORY(p)	(((p) != NULL) ? \
 ((p)->link_flags & EDV_OBJECT_LINK_TAR_DIRECTORY) : FALSE)      
#define EDV_OBJECT_IS_LINK_TAR_GRAND_PARENT(p)	(((p) != NULL) ? \
 ((p)->link_flags & EDV_OBJECT_LINK_TAR_GRAND_PARENT) : FALSE)


extern edv_object_type EDVObjectGetTypeFromStatMode(const mode_t m);
extern mode_t EDVObjectGetTypeFromEDVType(const edv_object_type type);
extern const gchar *EDVObjectGetTypeName(const edv_object_type type);
extern const gchar *EDVObjectGetTypeNameLower(const edv_object_type type);

extern edv_permission_flags EDVObjectGetPermissionsFromStatMode(
	const mode_t m
);
extern mode_t EDVObjectGetPermissionsFromEDVPermissions(
	const edv_permission_flags permissions
);


extern edv_object_struct *EDVObjectNew(void);
extern edv_object_struct *EDVObjectCopy(const edv_object_struct *obj);
extern void EDVObjectSetPath(
	edv_object_struct *obj, const gchar *path
);
extern void EDVObjectSetPath2(
	edv_object_struct *obj,
	const gchar *parent, const gchar *name
);
extern void EDVObjectSetStat(
	edv_object_struct *obj, const struct stat *lstat_buf
);
extern void EDVObjectUpdateLinkFlags(edv_object_struct *obj);
extern void EDVObjectDelete(edv_object_struct *obj);


#endif	/* EDV_OBJ_H */
