/*
		    Endeavour Image Browser Thumbs List
 */

#ifndef IMBR_TLIST_H
#define IMBR_TLIST_H

#include <gtk/gtk.h>
#include "imbr.h"


/* Selection */
extern GList *EDVImbrTListGetSelectedPaths(edv_imbr_struct *imbr);

/* Finding */
extern gint EDVImbrTListFindThumbByIndex(
	edv_imbr_struct *imbr,
	const gulong device_index, const gulong index
);
extern gint EDVImbrTListFindThumbByPath(
	edv_imbr_struct *imbr, const gchar *path
);

/* Image Loading */
extern GList *EDVImbrTListLoadImageRGBA(
	tlist_struct *tlist, const gchar *path,
	gint *width, gint *height, gint *bpl,
	gint *nframes, GList **delay_list,
	const gboolean resize_for_thumb,	/* Resize for tlist thumb */
	const gboolean no_enlarge,		/* No enlarge if smaller
						 * than req size */
	GdkWindow *window			/* Reference window */
);

/* Realize Listing */
extern void EDVImbrTListRealizeListing(edv_imbr_struct *imbr);

/* Get Listing */
extern void EDVImbrTListGetListing(
	edv_imbr_struct *imbr, const gchar *path,
	const gboolean update_status_bar
);
extern void EDVImbrTlistClear(edv_imbr_struct *imbr);

/* Thumb Image Load Iteration */
extern gint EDVImbrTListLoadIterate(
	edv_imbr_struct *imbr,
	const gboolean update_status_bar,
	const gboolean no_enlarge
);

/* Opening */
extern void EDVImbrTListOpen(
	edv_imbr_struct *imbr, const gint thumb_num,
	const guint state			/* Key modifiers */
);
extern void EDVImbrTListOpenWith(
	edv_imbr_struct *imbr, const gint thumb_num
);

/* Renaming */
extern void EDVImbrTListDoFPromptRename(
	edv_imbr_struct *imbr, const gint thumb_num
);

/* Object Callbacks */
extern void EDVImbrTListObjectAddedNotify(
	edv_imbr_struct *imbr, const gchar *path,
	const struct stat *lstat_buf
);
extern void EDVImbrTListObjectModifiedNotify(
	edv_imbr_struct *imbr, const gchar *path,
	const gchar *new_path,
	const struct stat *lstat_buf
);
extern void EDVImbrTListObjectRemovedNotify(
	edv_imbr_struct *imbr, const gchar *path
);

/* Mount Callbacks */
extern void EDVImbrTListMountNotify(
	edv_imbr_struct *imbr, edv_device_struct *dev_ptr,
	gboolean is_mounted
);


#endif	/* IMBR_TLIST_H */
