#include <unistd.h>
#include <gtk/gtk.h>
#include "../progressdialog.h"
#include "../config.h"

#include "../images/pdi_file01_20x20.xpm"
#include "../images/pdi_file02_20x20.xpm"
#include "../images/pdi_file03_20x20.xpm"
#include "../images/pdi_file04_20x20.xpm"
#include "../images/pdi_file05_20x20.xpm"
#include "../images/pdi_file06_20x20.xpm"

#include "../images/pdi_mail01_20x20.xpm"
#include "../images/pdi_mail02_20x20.xpm"
#include "../images/pdi_mail03_20x20.xpm"
#include "../images/pdi_mail04_20x20.xpm"
#include "../images/pdi_mail05_20x20.xpm"
#include "../images/pdi_mail06_20x20.xpm"

#include "../images/pdi_folder_32x32.xpm"
#include "../images/pdi_folderfile_32x32.xpm"
#include "../images/pdi_package_32x32.xpm"
#include "../images/pdi_packagefile_32x32.xpm"
#include "../images/pdi_mailbagfull_32x32.xpm"
#include "../images/pdi_mailbox_32x32.xpm"
#include "../images/pdi_mailboxfull_32x32.xpm"
#include "../images/icon_trash_32x32.xpm"
#include "../images/icon_trash_empty_32x32.xpm"

#include "../images/pdi_trash01_20x20.xpm"
#include "../images/pdi_trash02_20x20.xpm"
#include "../images/pdi_trash03_20x20.xpm"
#include "../images/pdi_trash04_20x20.xpm"
#include "../images/pdi_trash05_20x20.xpm"
#include "../images/pdi_trash06_20x20.xpm"


/*
 *	Progress Dialog Styles:
 */
#define DIALOG_STYLE_STANDARD		0
#define DIALOG_STYLE_ANIMATED		1

/*
 *	Animation Type:
 */
#define ANIMATION_MOVE			0
#define ANIMATION_COPY			1
#define ANIMATION_RECYCLE		2
#define ANIMATION_PURGE			3
#define ANIMATION_ARCHIVE		4
#define ANIMATION_MAIL			5


int main(int argc, char *argv[])
{
	gint	dialog_style = DIALOG_STYLE_ANIMATED,
		animation = ANIMATION_MOVE;
	const gchar	*dialog_style_str,
			*animation_str = "";
	gchar *s;
	gfloat progress = 0.0f;
	guint8	**start_icon_data[3],
		**icon_data[6],
		**end_icon_data[3];


	if(argc < 2)
	{
	    /* Print usage if no arguments are given but do not
	     * exit
	     */
	    g_print(
"Usage: %s [dialog_style] [animation_style]\n\
\n\
    Where [dialog_style] can be any of the following:\n\
\n\
	standard                - Standard style.\n\
	animated                - Animated style.\n\
\n\
    Where [animation_style] can be any of the following:\n\
\n\
	move                    - Move object.\n\
	copy                    - Copy object.\n\
	recycle                 - Recycle object.\n\
	purge                   - Purge recycle bin.\n\
	archive                 - Extract archive.\n\
	mail                    - Download mail.\n\
\n",
		argv[0]
	    );
	}

	/* Begin parsing arguments */
	/* Dialog Style */
	if(argc > 1)
	{
	    const gchar *s = argv[1];
	    if(!g_strcasecmp(s, "standard"))
		dialog_style = DIALOG_STYLE_STANDARD;
	    else if(!g_strcasecmp(s, "animated"))
		dialog_style = DIALOG_STYLE_ANIMATED;
	}
	/* Animation */
	if(argc > 2)
	{
	    const gchar *s = argv[2];
	    if(!g_strcasecmp(s, "move"))
		animation = ANIMATION_MOVE;
	    else if(!g_strcasecmp(s, "copy"))
		animation = ANIMATION_COPY;
	    else if(!g_strcasecmp(s, "recycle"))
		animation = ANIMATION_RECYCLE;
	    else if(!g_strcasecmp(s, "purge"))
		animation = ANIMATION_PURGE;
	    else if(!g_strcasecmp(s, "archive"))
		animation = ANIMATION_ARCHIVE;
	    else if(!g_strcasecmp(s, "mail"))
		animation = ANIMATION_MAIL;
	}



	gtk_init(&argc, &argv);

	ProgressDialogInit();

	/* Set start icon */
	switch(animation)
	{
	  case ANIMATION_MOVE:
	    animation_str = "move";
	    start_icon_data[0] = (guint8 **)pdi_folderfile_32x32_xpm;
	    start_icon_data[1] = (guint8 **)pdi_folder_32x32_xpm;
	    start_icon_data[2] = (guint8 **)pdi_folder_32x32_xpm;
	    break;
	  case ANIMATION_COPY:
	    animation_str = "copy";
	    start_icon_data[0] = (guint8 **)pdi_folderfile_32x32_xpm;
	    start_icon_data[1] = (guint8 **)pdi_folderfile_32x32_xpm;
	    start_icon_data[2] = (guint8 **)pdi_folderfile_32x32_xpm;
	    break;
	  case ANIMATION_RECYCLE:
	    animation_str = "recycle";
	    start_icon_data[0] = (guint8 **)pdi_folderfile_32x32_xpm;
	    start_icon_data[1] = (guint8 **)pdi_folder_32x32_xpm;
	    start_icon_data[2] = (guint8 **)pdi_folder_32x32_xpm;
	    break;
	  case ANIMATION_PURGE:
	    animation_str = "purge";
	    start_icon_data[0] = (guint8 **)icon_trash_32x32_xpm;
	    start_icon_data[1] = (guint8 **)icon_trash_empty_32x32_xpm;
	    start_icon_data[2] = (guint8 **)icon_trash_empty_32x32_xpm;
	    break;
	  case ANIMATION_ARCHIVE:
	    animation_str = "archive";
	    start_icon_data[0] = (guint8 **)pdi_packagefile_32x32_xpm;
	    start_icon_data[1] = (guint8 **)pdi_package_32x32_xpm;
	    start_icon_data[2] = (guint8 **)pdi_package_32x32_xpm;
	    break;
	  case ANIMATION_MAIL:
	    animation_str = "mail";
	    start_icon_data[0] = (guint8 **)pdi_mailbagfull_32x32_xpm;
	    start_icon_data[1] = (guint8 **)pdi_mailbagfull_32x32_xpm;
	    start_icon_data[2] = (guint8 **)pdi_mailbagfull_32x32_xpm;
	    break;
	}

	/* Set intermediate icons */
	switch(animation)
	{
	  case ANIMATION_MOVE:
	  case ANIMATION_COPY:
	  case ANIMATION_RECYCLE:
	  case ANIMATION_ARCHIVE:
	    icon_data[0] = (guint8 **)pdi_file01_20x20_xpm;
	    icon_data[1] = (guint8 **)pdi_file02_20x20_xpm;
	    icon_data[2] = (guint8 **)pdi_file03_20x20_xpm;
	    icon_data[3] = (guint8 **)pdi_file04_20x20_xpm;
	    icon_data[4] = (guint8 **)pdi_file05_20x20_xpm;
	    icon_data[5] = (guint8 **)pdi_file06_20x20_xpm;
	    break;
	  case ANIMATION_PURGE:
	    icon_data[0] = (guint8 **)pdi_trash01_20x20_xpm;
	    icon_data[1] = (guint8 **)pdi_trash02_20x20_xpm;
	    icon_data[2] = (guint8 **)pdi_trash03_20x20_xpm;
	    icon_data[3] = (guint8 **)pdi_trash04_20x20_xpm;
	    icon_data[4] = (guint8 **)pdi_trash05_20x20_xpm;
	    icon_data[5] = (guint8 **)pdi_trash06_20x20_xpm;
	    break;
	  case ANIMATION_MAIL:
	    icon_data[0] = (guint8 **)pdi_mail01_20x20_xpm;
	    icon_data[1] = (guint8 **)pdi_mail02_20x20_xpm;
	    icon_data[2] = (guint8 **)pdi_mail03_20x20_xpm;
	    icon_data[3] = (guint8 **)pdi_mail04_20x20_xpm;
	    icon_data[4] = (guint8 **)pdi_mail05_20x20_xpm;
	    icon_data[5] = (guint8 **)pdi_mail06_20x20_xpm;
	    break;
	}

	/* Set end icon */
	switch(animation)
	{
	  case ANIMATION_MOVE:
	    end_icon_data[0] = (guint8 **)pdi_folder_32x32_xpm;
	    end_icon_data[1] = (guint8 **)pdi_folder_32x32_xpm;
	    end_icon_data[2] = (guint8 **)pdi_folderfile_32x32_xpm;
	    break;
	  case ANIMATION_COPY:
	    end_icon_data[0] = (guint8 **)pdi_folder_32x32_xpm;
	    end_icon_data[1] = (guint8 **)pdi_folder_32x32_xpm;
	    end_icon_data[2] = (guint8 **)pdi_folderfile_32x32_xpm;
	    break;
	  case ANIMATION_RECYCLE:
	    end_icon_data[0] = (guint8 **)icon_trash_empty_32x32_xpm;
	    end_icon_data[1] = (guint8 **)icon_trash_empty_32x32_xpm;
	    end_icon_data[2] = (guint8 **)icon_trash_32x32_xpm;
	    break;
	  case ANIMATION_PURGE:
	    end_icon_data[0] = NULL;
	    end_icon_data[1] = NULL;
	    end_icon_data[2] = NULL;
	    break;
	  case ANIMATION_ARCHIVE:
	    end_icon_data[0] = (guint8 **)pdi_folder_32x32_xpm;
	    end_icon_data[1] = (guint8 **)pdi_folder_32x32_xpm;
	    end_icon_data[2] = (guint8 **)pdi_folderfile_32x32_xpm;
	    break;
	  case ANIMATION_MAIL:
	    end_icon_data[0] = (guint8 **)pdi_mailbox_32x32_xpm;
	    end_icon_data[1] = (guint8 **)pdi_mailbox_32x32_xpm;
	    end_icon_data[2] = (guint8 **)pdi_mailboxfull_32x32_xpm;
	    break;
	}

	/* Map Progress Dialog based on the dialog style */
	switch(dialog_style)
	{
	  case DIALOG_STYLE_ANIMATED:
	    dialog_style_str = "animated";
	    s = g_strdup_printf(
"This is a sample Progress Dialog\n\
\n\
Dialog Style: \"%s\"\n\
\n\
Animation: \"%s\"\n",
		dialog_style_str, animation_str
	    );
	    ProgressDialogMapAnimation(
		"Progress Dialog",
		s,
		"Stop",
		start_icon_data,
		sizeof(start_icon_data) / sizeof(guint **),
		icon_data,
		sizeof(icon_data) / sizeof(guint **),
		end_icon_data,
		sizeof(end_icon_data) / sizeof(guint **),
		EDV_DEF_PROGRESS_DLG_ANIM_INT,
		EDV_DEF_PROGRESS_DLG_ANIM_INC
	    );
	    g_free(s);
	    break;
	  default:
	    dialog_style_str = "standard";
	    s = g_strdup_printf(
"This is a sample Progress Dialog\n\
\n\
Dialog Style: \"%s\"\n",
		dialog_style_str
	    );
	    ProgressDialogMap(
		"Progress Dialog",
		"This is a sample Progress Dialog",
		(const guint8 **)pdi_folderfile_32x32_xpm,
		"Stop"
	    );
	    g_free(s);
	    break;
	}

	gdk_flush();

	/* Begin updating progress */
	while(TRUE)
	{
	    /* User clicked on stop? */
	    if(ProgressDialogStopCount() > 0)
	    {
		ProgressDialogBreakQuery(TRUE);
		break;
	    }

	    /* Manage GTK events */
	    if(gtk_events_pending() > 0)
		gtk_main_iteration();

	    /* Increment progress */
	    progress += 0.005f;

	    /* Progress warped? */
	    if(progress > 1.0f)
		progress = 0.0f;

	    /* Update Progress Dialog */
	    ProgressDialogUpdate(
		NULL, NULL, NULL, NULL, progress,
		20, TRUE
	    );
#if 0
	    ProgressDialogUpdateUnknown(
		NULL, NULL, NULL, NULL,
		TRUE
	    );
#endif
	    usleep(20000);
	}

	ProgressDialogShutdown();

	return(0);
}
