/*
                    Endeavour Generic Options Window

	This is not the Options Window itself, but rather a generic
	options window that the Options Window and Customize Windows are
	based on (see opt_win.h and customize_win.h).
 */

#ifndef EDV_GENERIC_OPTIONS_WIN_H
#define EDV_GENERIC_OPTIONS_WIN_H

#include <gtk/gtk.h>
#include "edv_types.h"


typedef struct _edv_gen_opt_win_struct	edv_gen_opt_win_struct;
#define EDV_GEN_OPT_WIN(p)		((edv_gen_opt_win_struct *)(p))
typedef struct _edv_gen_opt_wref_struct	edv_gen_opt_wref_struct;
#define EDV_GEN_OPT_WREF(p)		((edv_gen_opt_wref_struct *)(p))


/*
 *	Widget Types:
 */
typedef enum {

	EDV_GEN_OPT_WIDGET_UNKNOWN,

	EDV_GEN_OPT_WIDGET_DRAWING_AREA,
	EDV_GEN_OPT_WIDGET_BUTTON,
	EDV_GEN_OPT_WIDGET_TOGGLE_BUTTON,
	EDV_GEN_OPT_WIDGET_RADIO_BUTTON,
	EDV_GEN_OPT_WIDGET_RANGE,
	EDV_GEN_OPT_WIDGET_EDITABLE,
	EDV_GEN_OPT_WIDGET_SPIN_BUTTON,
	EDV_GEN_OPT_WIDGET_COMBO,
	EDV_GEN_OPT_WIDGET_CLIST,

	EDV_GEN_OPT_WIDGET_COLOR_BUTTON,
	EDV_GEN_OPT_WIDGET_POPUP_LIST_BOX,
	EDV_GEN_OPT_WIDGET_STYLE_EDIT,
	EDV_GEN_OPT_WIDGET_STACK_LIST,
	EDV_GEN_OPT_WIDGET_KEYMAP_LIST,
	EDV_GEN_OPT_WIDGET_MENUCFG_LIST

} edv_gen_opt_widget_type;


/*
 *	Widget Reference:
 *
 *	References a widget with a configuration parameter.
 */
struct _edv_gen_opt_wref_struct {

	edv_gen_opt_widget_type	type;
	gpointer	w;		/* Referenced "Widget" */

	GtkWidget	*browse;	/* Browse GtkButton */

	gchar		*cfg_parm;	/* Configuration parameter name */

	gpointer	optwin;
	gboolean	has_changes,
			ignore_changes;

	/* Following are members use in special or extended cases */
	gint		radio_value;	/* For EDV_GEN_OPT_WIDGET_RADIO_BUTTON */

};


/*
 *	Options Window:
 */
struct _edv_gen_opt_win_struct {

	GtkWidget       *toplevel;
	GtkAccelGroup   *accelgrp;
	gboolean	has_changes;
	gint            freeze_count,
			busy_count;
	gchar		*title;
	guint8		**icon_data;
	edv_core_struct *core;

	GtkWidget	*notebook,
			*ok_btn,
			*apply_btn,
			*save_btn,
			*cancel_btn,
			*close_btn;

	/* Page toplevel GtkWidgets list, GList of GtkWidget * */
	GList		*page_toplevels_list,

	/* Widget references list, GList of edv_gen_opt_wref_struct * */
			*wrefs_list;

};


/* Wref Utilities */
extern edv_gen_opt_wref_struct *EDVGenOptWinWRefNew(
        const edv_gen_opt_widget_type type,
        gpointer w,
        GtkWidget *browse,	/* Browse GtkButton */
        const gchar *cfg_parm,	/* Configuration item parameter */
        gpointer optwin
);
extern void EDVGenOptWinWRefDelete(edv_gen_opt_wref_struct *wref);
extern edv_gen_opt_wref_struct *EDVGenOptWinWRefAppend(
        edv_gen_opt_win_struct *optwin,
        const edv_gen_opt_widget_type type,
        gpointer w,
        GtkWidget *browse,	/* Browse button */
        const gchar *cfg_parm	/* Cfg item parameter */
);

/* Options Window */
extern edv_gen_opt_win_struct *EDVGenOptWinNew(
	edv_core_struct *core,
	const gchar *title, guint8 **icon_data
);
extern GtkWidget *EDVGenOptWinPageAppend(
	edv_gen_opt_win_struct *optwin, GtkWidget *w
);
extern void EDVGenOptWinUpdateMenus(edv_gen_opt_win_struct *optwin);
extern void EDVGenOptWinSetBusy(edv_gen_opt_win_struct *optwin, gboolean is_busy);
extern gboolean EDVGenOptWinIsMapped(edv_gen_opt_win_struct *optwin);
extern void EDVGenOptWinMap(edv_gen_opt_win_struct *optwin);
extern void EDVGenOptWinUnmap(edv_gen_opt_win_struct *optwin);
extern void EDVGenOptWinDelete(edv_gen_opt_win_struct *optwin);


#endif	/* EDV_GENERIC_OPTIONS_WIN_H */
