#ifndef EDV_HISTORY_LIST_H
#define EDV_HISTORY_LIST_H

#include <stdio.h>
#include <glib.h>
#include "edv_types.h"
#include "edv_history.h"


extern edv_history_struct *EDVHistoryListAppend(
	edv_history_struct ***list, gint *total,
	gint *n, const gint max
);

extern GList *EDVHistoryListOpen(
	const gchar *path,
	gint (*progress_cb)(gpointer, const gulong, const gulong),
	gpointer data
);
extern void EDVHistoryAppendToStream(
	FILE *fp, const edv_history_struct *h
);
extern void EDVHistoryAppendToFile(
	const gchar *path, const edv_history_struct *h
);
extern void EDVHistoryListSave(
	const gchar *path,
	edv_history_struct **list, const gint total,
	gint (*progress_cb)(gpointer, const gulong, const gulong),
	gpointer data
);


#endif	/* EDV_HISTORY_LIST_H */
