/*
			      Properties Dialog
 */

#ifndef PROPDLG_H
#define PROPDLG_H

#include <gtk/gtk.h>
#include "pie_chart.h"
#include "edv_types.h"
#include "edv_obj.h"


typedef struct _edv_propdlg_struct      edv_propdlg_struct;
#define EDV_PROPDLG(p)			((edv_propdlg_struct *)(p))


/*
 *	Properties Dialog:
 */
struct _edv_propdlg_struct {

	GtkWidget       *toplevel;
	GtkAccelGroup   *accelgrp;
	gint            busy_count,
			freeze_count;
	gboolean	has_changes;
	gchar		*title;
	edv_core_struct *core;

	GtkWidget	*main_vbox,
			*notebook,
			*ok_btn,
			*apply_btn,
			*cancel_btn,
			*close_btn;

	/* Information about the object being displayed */
	gchar		*path;		/* Absolute path */
	edv_object_type	type;
	gchar		*mime_type;
	GList		*ext_props_list;	/* Coppied GList of
						 * edv_object_prop_struct * */

	/* General Page */
	GtkWidget	*gen_toplevel,
			*gen_icon_pm,
			*gen_name_label,
			*gen_location_label,
			*gen_type_label,
			*gen_size_label,
			*gen_timestamps_frame,
			*gen_date_access_label,
			*gen_date_modify_label,
			*gen_date_change_label,
			*gen_date_touch_btn,
			*gen_ownership_frame,
			*gen_owner_entry,
			*gen_owner_btn,
			*gen_group_entry,
			*gen_group_btn,
			*gen_permissions_frame,
			*gen_ur_check,
			*gen_uw_check,
			*gen_ux_check,
			*gen_gr_check,
			*gen_gw_check,
			*gen_gx_check,
			*gen_or_check,
			*gen_ow_check,
			*gen_ox_check,
			*gen_suid_check,
			*gen_sgid_check,
			*gen_sticky_check;

	/* Details Page */
	GtkWidget 	*det_toplevel,
			*det_verbose_radio,
			*det_raw_radio,
			*det_clist;

	/* Link Page */
	GtkWidget	*link_toplevel,
			*link_target_icon_pm,
			*link_target_entry,
			*link_target_make_relative_path_btn,
			*link_target_properties_btn;

	/* Device Page (for device nodes, see Device Node Page) */
	gint		dev_num;
	GtkWidget	*dev_toplevel,
			*dev_icon_pm,
			*dev_device_path_label,
			*dev_mount_path_label,
			*dev_fs_type_label,
			*dev_usage_frame,
			*dev_usage_vbox;
	pie_chart_struct	*dev_usage_pc;
	GtkWidget       *dev_mount_btn,
			*dev_eject_btn,
			*dev_check_btn,
			*dev_tools_btn,
			*dev_format_btn;

	/* Device Node Page */
	GtkWidget	*dev_node_toplevel,
			*dev_node_major_entry,	/* Major number */
			*dev_node_minor_entry;	/* Minor number */

};


/* Callbacks */
extern void EDVPropDlgObjectAddedNotifyCB(
        edv_propdlg_struct *pd, const gchar *path,
        const struct stat *lstat_buf
);
extern void EDVPropDlgObjectModifiedNotifyCB(
	edv_propdlg_struct *pd,
	const gchar *path, const gchar *new_path,
	const struct stat *lstat_buf
);
extern void EDVPropDlgObjectRemovedNotifyCB(
	edv_propdlg_struct *pd, const gchar *path
);
extern void EDVPropDlgMIMETypeAddedNotifyCB(
        edv_propdlg_struct *pd,
        gint mt_num, edv_mime_type_struct *m
);
extern void EDVPropDlgMIMETypeModifiedNotifyCB(
        edv_propdlg_struct *pd,
        gint mt_num, edv_mime_type_struct *m
);
extern void EDVPropDlgMIMETypeRemovedNotifyCB(
        edv_propdlg_struct *pd,
        gint mt_num
);
extern void EDVPropDlgMountNotifyCB(
        edv_propdlg_struct *pd, 
        gint dev_num, edv_device_struct *dev,
        gboolean is_mounted
);
extern void EDVPropDlgWriteProtectChangedCB(
	edv_propdlg_struct *pd, gboolean state
);
extern void EDVPropDlgReconfiguredNotifyCB(edv_propdlg_struct *pd);

/* Properties Dialog */
extern edv_propdlg_struct *EDVPropDlgNew(
	edv_core_struct *core, edv_object_struct *obj
);
extern void EDVPropDlgSetHasChanges(
	edv_propdlg_struct *pd, const gboolean has_changes
);
extern void EDVPropDlgUpdateMenus(edv_propdlg_struct *pd);
extern void EDVPropDlgSetBusy(edv_propdlg_struct *pd, const gboolean busy);
extern gboolean EDVPropDlgIsMapped(edv_propdlg_struct *pd);
extern void EDVPropDlgMap(edv_propdlg_struct *pd);
extern void EDVPropDlgUnmap(edv_propdlg_struct *pd);
extern void EDVPropDlgDelete(edv_propdlg_struct *pd);


#endif	/* PROPDLG_H */
