#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "../guiutils.h"
#include "../cdialog.h"
#include "../fprompt.h"
#include "../fb.h"
#include "../csd.h"
#include "../fsd.h"
#include "../style_edit.h"
#include "../config.h"

#include "../images/icon_edit_48x48.xpm"

static gint delete_cb(GtkWidget *widget, GdkEvent *event, gpointer data);
static void changed_cb(style_edit_struct *se, gpointer data);


#define ATOI(s)         (((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)         (((s) != NULL) ? atol(s) : 0)
#define ATOF(s)         (((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)       (((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define STRLEN(s)       (((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)   (((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	GtkWindow "delete_event" signal callback.
 */
static gint delete_cb(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	gtk_main_quit();
	return(TRUE);
}

/*
 *	Style Edit changed signal callback.
 */
static void changed_cb(style_edit_struct *se, gpointer data)
{


}

int main(int argc, char *argv[])
{
	gboolean initialized_gtk = FALSE;
	gint i;
	const gchar *arg;
	GdkWindow *window;
	GtkAccelGroup *accelgrp;
	GtkWidget *toplevel, *w, *parent;
	style_edit_struct *se;


	/* Parse arguments */
	for(i = 1; i < argc; i++)
	{
	    arg = argv[i];
	    if(arg == NULL)
		continue;

	    if(!g_strcasecmp(arg, "--help") ||
	       !g_strcasecmp(arg, "-h")
	    )
	    {
		g_print(
"Usage: %s\n",
		    argv[0]
		);
		return(0);
	    }
	}

	/* Initialize GTK+ as needed */
	if(!initialized_gtk)
	{
	    if(!gtk_init_check(&argc, &argv))
	    {
		g_printerr(
 "This program requires X.\n"
		);
		return(1);
	    }
	    initialized_gtk = TRUE;
	}

	gdk_rgb_init();


	/* Initialize dialogs */
	CDialogInit();
	FPromptInit();
	FileBrowserInit();
	CSDInit();
	FSDInit();


	/* Begin creating Style Editor */

	accelgrp = gtk_accel_group_new();

	/* Toplevel */
	toplevel = w = gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_window_set_title(GTK_WINDOW(w), "GTK Style Editor");
	gtk_widget_set_usize(
	    w, 600, 100
	);
	gtk_window_set_policy(
	    GTK_WINDOW(w),
	    TRUE, TRUE, TRUE
	);
	gtk_widget_realize(w);
	window = w->window;
	if(window != NULL)
	{
            gdk_window_set_decorations(
                window,
                GDK_DECOR_BORDER | GDK_DECOR_TITLE | GDK_DECOR_MENU |
		GDK_DECOR_MINIMIZE
            );
            gdk_window_set_functions(
                window,
                GDK_FUNC_MOVE | GDK_FUNC_MINIMIZE | GDK_FUNC_CLOSE
            );
            GUISetWMIcon(
                window,
                (guint8 **)icon_edit_48x48_xpm
            );
	}
	gtk_signal_connect(
	    GTK_OBJECT(w), "delete_event",
	    GTK_SIGNAL_FUNC(delete_cb), NULL
	);
	gtk_container_border_width(GTK_CONTAINER(w), 0);
	gtk_window_add_accel_group(GTK_WINDOW(w), accelgrp);
	parent = w;

	w = gtk_vbox_new(FALSE, 0);
	gtk_container_border_width(GTK_CONTAINER(w), 5);
	gtk_container_add(GTK_CONTAINER(parent), w);
	gtk_widget_show(w);
	parent = w;

	/* Style Edit */
	se = StyleEditNew(parent, "Style");
	StyleEditRestoreDefaultStyle(se);
	StyleEditSetChangedCB(se, changed_cb, NULL);

	/* Show toplevel window */
	gtk_widget_show_raise(toplevel);


	/* Enter GTK main loop */
	gtk_main();


	/* Delete Style Editor */
	StyleEditDelete(se);
	GTK_WIDGET_DESTROY(toplevel);
	GTK_ACCEL_GROUP_UNREF(accelgrp);

	/* Shutdown dialogs */
	FSDShutdown();
	CSDShutdown();
	FileBrowserShutdown();
	FPromptShutdown();
	CDialogShutdown();


	return(0);
}
