/*
		       Endeavour Core Callbacks
 */

#ifndef EDVCB_H
#define EDVCB_H

#include <gtk/gtk.h>

#include "edv_types.h"
#include "edv_obj.h"
#include "edv_device.h"
#include "edv_mime_type.h"
#include "edv_archive_obj.h"
#include "edv_recycled_obj.h"


/* UNIX Signal Callbacks */
extern void EDVSignalCB(int s);

/* Timeout Callbacks */
extern gint EDVManageTimeoutCB(gpointer data);
extern gint EDVCheckDevicesCB(gpointer data);

/* New/Map Window Callbacks */
extern void EDVNewBrowserCB(GtkWidget *widget, gpointer data);
extern void EDVNewImbrCB(GtkWidget *widget, gpointer data);
extern void EDVNewArchiverCB(GtkWidget *widget, gpointer data);
extern void EDVMapRecBinCB(GtkWidget *widget, gpointer data);
extern void EDVDevicesCB(GtkWidget *widget, gpointer data);
extern void EDVMIMETypesCB(GtkWidget *widget, gpointer data);
extern void EDVOptionsCB(GtkWidget *widget, gpointer data);
extern void EDVCustomizeCB(GtkWidget *widget, gpointer data);

/* GtkCList Sort Callbacks */
extern gint EDVCListColumnSortStringCB(
	GtkCList *clist, gconstpointer ptr1, gconstpointer ptr2
);
extern gint EDVCListColumnSortNumberCB(
	GtkCList *clist, gconstpointer ptr1, gconstpointer ptr2
);

/* Refresh & Reset Callbacks */
extern void EDVRefreshCB(GtkWidget *widget, gpointer data);
extern void EDVResetCB(GtkWidget *widget, gpointer data);

/* Clear Callbacks */
extern void EDVPurgeAllRecycledObjectsCB(GtkWidget *widget, gpointer data);
extern void EDVClearHistoryCB(GtkWidget *widget, gpointer data);
extern void EDVClearLocationsHistoryCB(GtkWidget *widget, gpointer data);
extern void EDVClearRunHistoryCB(GtkWidget *widget, gpointer data);

/* GtkEntry DND Callbacks */
extern gboolean EDVEntryDragMotionCB(
	GtkWidget *widget, GdkDragContext *dc, gint x, gint y, guint t,
	gpointer data
);
extern void EDVEntryDragDataReceivedCB(
	GtkWidget *widget, GdkDragContext *dc, gint x, gint y,
	GtkSelectionData *selection_data, guint info, guint t,
	gpointer data
);

/* GtkEntry Complete Path Callback */
extern gint EDVEntryCompletePathCB(
	GtkWidget *widget, GdkEventKey *key, gpointer data
);

/* Location Bar DND Callbacks */
extern void EDVLocBarIconDragDataGet(
	GtkWidget *widget, GdkDragContext *context,
	GtkSelectionData *selection_data, guint info, guint time,
	gpointer data
);

/* File Selector Callbacks */
extern void EDVFileSelectorObjectCreatedCB(
        const gchar *path, gpointer data
);
extern void EDVFileSelectorObjectModifiedCB(
        const gchar *old_path,
        const gchar *new_path,
        gpointer data
);
extern void EDVFileSelectorObjectDeletedCB(
        const gchar *path, gpointer data
);


/* Write Protect Changed Emitters */
extern void EDVWriteProtectChangedEmit(
	edv_core_struct *core, const gboolean state
);

/* Object Emitters */
extern void EDVObjectAddedEmit(
	edv_core_struct *core, const gchar *path,
	struct stat *lstat_buf
);
extern void EDVObjectModifiedEmit(
	edv_core_struct *core, const gchar *path,
	const gchar *new_path,
	struct stat *lstat_buf
);
extern void EDVObjectRemovedEmit(
	edv_core_struct *core, const gchar *path
);

/* Mount/Unmount Emitters */
extern void EDVObjectMountEmit(
	edv_core_struct *core,
	const gint dev_num, edv_device_struct *dev,
	const gboolean is_mounted
);

/* Archive Object Emitters */
extern void EDVArchiveObjectAddedEmit(
	edv_core_struct *core, const gchar *arch_path,
	const gchar *path, edv_archive_object_struct *obj
);
extern void EDVArchiveObjectModifiedEmit(
	edv_core_struct *core, const gchar *arch_path,
	const gchar *path, const gchar *new_path,
	edv_archive_object_struct *obj
);
extern void EDVArchiveObjectRemovedEmit(
	edv_core_struct *core, const gchar *arch_path,
	const gchar *path
);

/* Recycled Object Emitters */
extern void EDVRecycledObjectAddedEmit(
	edv_core_struct *core, const guint index
);
extern void EDVRecycledObjectModifiedEmit(
	edv_core_struct *core, const guint index
);
extern void EDVRecycledObjectRemovedEmit(
	edv_core_struct *core, const guint index
);

/* Reconfigure Emitters */
extern void EDVReconfiguredEmit(edv_core_struct *core);

/* MIME Type Emitters */
extern void EDVMimeTypeAddedEmitCB(
	const gint mt_num, edv_mime_type_struct *mt, gpointer data
);
extern void EDVMimeTypeAddedEmit(
	edv_core_struct *core,
	const gint mt_num, edv_mime_type_struct *mt
);
extern void EDVMimeTypeModifiedEmitCB(
	const gint mt_num, edv_mime_type_struct *mt, gpointer data
);
extern void EDVMimeTypeModifiedEmit(
	edv_core_struct *core,
	const gint mt_num, edv_mime_type_struct *mt
);
extern void EDVMimeTypeRemovedEmitCB(
	const gint mt_num, gpointer data
);
extern void EDVMimeTypeRemovedEmit(
	edv_core_struct *core, const gint mt_num
);

/* Device Emitters */
extern void EDVDeviceAddedEmit(
	edv_core_struct *core,
	const gint dev_num, edv_device_struct *dev
);
extern void EDVDeviceModifiedEmit(
	edv_core_struct *core,
	const gint dev_num, edv_device_struct *dev
);
extern void EDVDeviceRemovedEmit(
	edv_core_struct *core,
	const gint dev_num
);

/* History Event Emitters */
extern void EDVHistoryAddedEmit(
	edv_core_struct *core,
	const gint h_num, edv_history_struct *h
);
extern void EDVHistoryRemovedEmit(
	edv_core_struct *core,
	const gint h_num
);


#endif	/* EDVCB_H */
