/*
			Endeavour Date Formatting
 */

#ifndef EDVDATE_H
#define EDVDATE_H

#include <glib.h>


/*
 *	Date Relativity:
 */
typedef enum {
	EDV_DATE_RELATIVITY_ABSOLUTE,	/* Relative to christian time */
	EDV_DATE_RELATIVITY_CURRENT	/* Relative to current time */
} edv_date_relativity;


extern const gchar *EDVDateFormatString(
	const gulong t,
	const gchar *format,
	const edv_date_relativity relativity
);
extern const gchar *EDVDateStringDuration(const gulong dt);

extern void EDVDateParseDateDMY(
	const gchar *s,
	gint *day, gint *month, gint *year
);
extern void EDVDateParseDateMDY(
	const gchar *s,
	gint *month, gint *day, gint *year
);
extern void EDVDateParseDateYMD(
	const gchar *s,
	gint *year, gint *month, gint *day
);
extern void EDVDateParseDate(
	const gchar *s,
	gint *year, gint *month, gint *day
);
extern void EDVDateParseTime(
	const gchar *s,
	gint *hour, gint *minutes, gint *seconds
);
extern gulong EDVDateParseEPOCH(const gchar *s);


#endif	/* EDVDATE_H */
