/*
		 Endeavour Recycle Bin Contents List
 */

#ifndef RECBINCONTENTS_H
#define RECBINCONTENTS_H

#include <gtk/gtk.h>
#include "recbin.h"


/* Columns */
extern void EDVRecBinContentsResizeColumnOptimul(
	edv_recbin_struct *recbin,
	const gint column_num
);
extern void EDVRecBinContentsResizeColumnsOptimul(edv_recbin_struct *recbin);

/* Finding */
extern gint EDVRecBinContentsFindRowByIndex(
	edv_recbin_struct *recbin,
	const guint index
);

/* Realize Listing */
extern void EDVRecBinContentsRealizeListing(edv_recbin_struct *recbin);

/* Get Listing */
extern void EDVRecBinContentsGetListing(
	edv_recbin_struct *recbin,
	const gboolean update_status_bar
);
extern void EDVRecBinContentsClear(edv_recbin_struct *recbin);

/* Rename */
extern void EDVRecBinContentsPromptRename(
        edv_recbin_struct *recbin,
	const gint row,
	const gint column
);

/* Callbacks */
extern void EDVRecBinContentsObjectAddedNotify(
	edv_recbin_struct *recbin, const guint index
);
extern void EDVRecBinContentsObjectModifiedNotify(
	edv_recbin_struct *recbin, const guint index
);
extern void EDVRecBinContentsObjectRemovedNotify(
	edv_recbin_struct *recbin, const guint index
);


#endif	/* RECBINCONTENTS_H */
