//  ======================================================================== //
//                                                                           //
//    File      : enigma_mapping.cpp                                         //
//    Purpose   :                                                            //
//    Time-stamp: <Sat Jul/05/2003 18:23 MET amgine@reallysoft.de>           //
//                                                                           //
//    (C) May 2003 by Ralf Westram <amgine@rallysoft.de>                     //
//                                                                           //
//    Permission to use, copy, modify, distribute and sell this software     //
//    and its documentation for any purpose is hereby granted without fee,   //
//    provided that the above copyright notice appear in all copies and      //
//    that both that copyright notice and this permission notice appear      //
//    in supporting documentation.                                           //
//                                                                           //
//    Ralf Westram makes no representations about the suitability of this    //
//    software for any purpose.  It is provided "as is" without express or   //
//    implied warranty.                                                      //
//                                                                           //
//  ======================================================================== //

#include "OxydVersion.h"
#include "enigma_mapping.h"
#include <assert.h>

using namespace OxydLib;

#define UNUSED ""

// ---------------------------------------------
// Oxyd1 mapping
// ---------------------------------------------

static const char *Oxyd1_floor_map[256] = {
    "fl-abyss",                 // Oxyd1 floor 0x00
    "fl-gray",                  // Oxyd1 floor 0x01
    "fl-metal",                 // Oxyd1 floor 0x02
    "fl-samba",                 // Oxyd1 floor 0x03 was: checkered floor
    UNUSED,                     // Oxyd1 floor 0x04
    UNUSED,                     // Oxyd1 floor 0x05
    UNUSED,                     // Oxyd1 floor 0x06
    "fl-normal",                // Oxyd1 floor 0x07
    "fl-himalaya",              // Oxyd1 floor 0x08
    "fl-himalaya",              // Oxyd1 floor 0x09
    "fl-himalaya",              // Oxyd1 floor 0x0a
    "fl-himalaya",              // Oxyd1 floor 0x0b
    "fl-inverse2",              // Oxyd1 floor 0x0c
    "fl-acblack",               // Oxyd1 floor 0x0d
    "fl-acwhite",               // Oxyd1 floor 0x0e
    "fl-swamp",                 // Oxyd1 floor 0x0f
    UNUSED,                     // Oxyd1 floor 0x10
    UNUSED,                     // Oxyd1 floor 0x11
    UNUSED,                     // Oxyd1 floor 0x12
    "fl-water",                 // Oxyd1 floor 0x13
    UNUSED,                     // Oxyd1 floor 0x14
    UNUSED,                     // Oxyd1 floor 0x15
    UNUSED,                     // Oxyd1 floor 0x16
    "fl-ice_001",               // Oxyd1 floor 0x17
    UNUSED,                     // Oxyd1 floor 0x18
    UNUSED,                     // Oxyd1 floor 0x19
    UNUSED,                     // Oxyd1 floor 0x1a
    UNUSED,                     // Oxyd1 floor 0x1b
    "fl-space",                 // Oxyd1 floor 0x1c
    "fl-space",                 // Oxyd1 floor 0x1d
    UNUSED,                     // Oxyd1 floor 0x1e
    UNUSED,                     // Oxyd1 floor 0x1f
    "fl-space",                 // Oxyd1 floor 0x20
    "fl-space",                 // Oxyd1 floor 0x21
    "fl-space",                 // Oxyd1 floor 0x22
    "fl-gradient1",             // Oxyd1 floor 0x23
    "fl-gradient2",             // Oxyd1 floor 0x24
    "fl-gradient3",             // Oxyd1 floor 0x25
    "fl-gradient4",             // Oxyd1 floor 0x26
    "fl-gradient5",             // Oxyd1 floor 0x27
    "fl-gradient6",             // Oxyd1 floor 0x28
    "fl-gradient7",             // Oxyd1 floor 0x29
    "fl-gradient8",             // Oxyd1 floor 0x2a
    "fl-gradient9",             // Oxyd1 floor 0x2b
    "fl-gradient10",            // Oxyd1 floor 0x2c
    "fl-gradient11",            // Oxyd1 floor 0x2d
    "fl-gradient12",            // Oxyd1 floor 0x2e
    "fl-gradient13",            // Oxyd1 floor 0x2f
    "fl-gradient14",            // Oxyd1 floor 0x30
    "fl-gradient15",            // Oxyd1 floor 0x31
    "fl-gradient16",            // Oxyd1 floor 0x32
    "fl-brick",                 // Oxyd1 floor 0x33
    "fl-brick",                 // Oxyd1 floor 0x34 (common was 'fl-rough')
    UNUSED,                     // Oxyd1 floor 0x35
    UNUSED,                     // Oxyd1 floor 0x36
    "fl-brick",                 // Oxyd1 floor 0x37
    "fl-brick",                 // Oxyd1 floor 0x38
    UNUSED,                     // Oxyd1 floor 0x39
    UNUSED,                     // Oxyd1 floor 0x3a
    UNUSED,                     // Oxyd1 floor 0x3b
    "fl-rock",                  // Oxyd1 floor 0x3c
    UNUSED,                     // Oxyd1 floor 0x3d
    UNUSED,                     // Oxyd1 floor 0x3e
    UNUSED,                     // Oxyd1 floor 0x3f
    "fl-stwood1",               // Oxyd1 floor 0x40
    "fl-wood",                  // Oxyd1 floor 0x41
    0,                          // Oxyd1 floor 0x42
    UNUSED,                     // Oxyd1 floor 0x43
    UNUSED,                     // Oxyd1 floor 0x44
    UNUSED,                     // Oxyd1 floor 0x45
    "fl-gravel",                // Oxyd1 floor 0x46
    "fl-gravel",                // Oxyd1 floor 0x47
    UNUSED,                     // Oxyd1 floor 0x48
    UNUSED,                     // Oxyd1 floor 0x49
    UNUSED,                     // Oxyd1 floor 0x4a
    UNUSED,                     // Oxyd1 floor 0x4b
    UNUSED,                     // Oxyd1 floor 0x4c
    "fl-tigris",                // Oxyd1 floor 0x4d
    UNUSED,                     // Oxyd1 floor 0x4e
    UNUSED,                     // Oxyd1 floor 0x4f
    UNUSED,                     // Oxyd1 floor 0x50
    UNUSED,                     // Oxyd1 floor 0x51
    "fl-bridge",                // Oxyd1 floor 0x52
    "fl-springboard",           // Oxyd1 floor 0x53
    UNUSED,                     // Oxyd1 floor 0x54
    "fl-gray",                  // Oxyd1 floor 0x55
    "fl-light",                 // Oxyd1 floor 0x56
    0,                          // Oxyd1 floor 0x57 light gray
    0,                          // Oxyd1 floor 0x58 dark gray
    "fl-dunes",                 // Oxyd1 floor 0x59
    "fl-normal",                // Oxyd1 floor 0x5a
    "fl-plank",                 // Oxyd1 floor 0x5b
    // codes >= 0x5c are unused
};

static const char *Oxyd1_stone_map[256] = {
    0,                          // Oxyd1 stone 0x00
    0,                          // Oxyd1 stone 0x01
    0,                          // Oxyd1 stone 0x02
    0,                          // Oxyd1 stone 0x03
    0,                          // Oxyd1 stone 0x04
    0,                          // Oxyd1 stone 0x05
    0,                          // Oxyd1 stone 0x06
    0,                          // Oxyd1 stone 0x07
    0,                          // Oxyd1 stone 0x08
    0,                          // Oxyd1 stone 0x09
    0,                          // Oxyd1 stone 0x0a
    0,                          // Oxyd1 stone 0x0b
    0,                          // Oxyd1 stone 0x0c
    0,                          // Oxyd1 stone 0x0d
    0,                          // Oxyd1 stone 0x0e
    0,                          // Oxyd1 stone 0x0f
    0,                          // Oxyd1 stone 0x10
    "st-fakeoxyd",              // Oxyd1 stone 0x11
    "st-rock3",                 // Oxyd1 stone 0x12
    "st-bigbrick-es",           // Oxyd1 stone 0x13
    "st-bigbrick-sw",           // Oxyd1 stone 0x14
    "st-bigbrick-ne",           // Oxyd1 stone 0x15
    "st-bigbrick-nw",           // Oxyd1 stone 0x16
    0,                          // Oxyd1 stone 0x17
    0,                          // Oxyd1 stone 0x18 invisible, can walk through
    0,                          // Oxyd1 stone 0x19
    "st-grate1",                // Oxyd1 stone 0x1a
    "st-grate2",                // Oxyd1 stone 0x1b
    "st-bug",                   // Oxyd1 stone 0x1c
    0,                          // Oxyd1 stone 0x1d (common was 'st-rock3')
    "st-chameleon",             // Oxyd1 stone 0x1e
    "st-brick",                 // Oxyd1 stone 0x1f
    "st-rock1",                 // Oxyd1 stone 0x20
    "st-rock1",                 // Oxyd1 stone 0x21
    UNUSED,                     // Oxyd1 stone 0x22
    "st-woven",                 // Oxyd1 stone 0x23
    "st-marble",                // Oxyd1 stone 0x24
    "st-glass1",                // Oxyd1 stone 0x25
    "st-glass3",                // Oxyd1 stone 0x26
    "st-glass2",                // Oxyd1 stone 0x27
    0,                          // Oxyd1 stone 0x28 [grey stone, unmoveable, dynamite breaks it, see Level#12]
    "st-rock3_hole",            // Oxyd1 stone 0x29
    "st-rock3_movebreak",       // Oxyd1 stone 0x2a
    "st-wood",                  // Oxyd1 stone 0x2b
    "st-switch",                // Oxyd1 stone 0x2c
    "st-switch_black",          // Oxyd1 stone 0x2d
    "st-switch_white",          // Oxyd1 stone 0x2e
    0,                          // Oxyd1 stone 0x2f fourway stone
    "st-key_a",                 // Oxyd1 stone 0x30
    "st-floppy",                // Oxyd1 stone 0x31
    "st-knight",                // Oxyd1 stone 0x32
    0,                          // Oxyd1 stone 0x33 oscillator
    "st-death",                 // Oxyd1 stone 0x34
    "st-death_invisible",       // Oxyd1 stone 0x35
    "st-oneway-w",              // Oxyd1 stone 0x36
    "st-oneway-e",              // Oxyd1 stone 0x37
    "st-oneway-n",              // Oxyd1 stone 0x38
    "st-oneway-s",              // Oxyd1 stone 0x39 (common was 'st-magic')
    0,                          // Oxyd1 stone 0x3a (common was 'st-magic')
    "st-oneway_black-e",        // Oxyd1 stone 0x3b
    0,                          // Oxyd1 stone 0x3c
    0,                          // Oxyd1 stone 0x3d
    "st-window",                // Oxyd1 stone 0x3e
    "",                         // Oxyd1 stone 0x3f magic stone
    "",                         // Oxyd1 stone 0x40 magic stone
    "",                         // Oxyd1 stone 0x41 magic stone
    "st-actorimpulse",          // Oxyd1 stone 0x42
    "st-actorimpulse_invisible", // Oxyd1 stone 0x43
    "st-laser-1",               // Oxyd1 stone 0x44  The laser-names are fake names!
    "st-laser-2",               // Oxyd1 stone 0x45  Direction and state are generated by Enigma.
    "st-laser-3",               // Oxyd1 stone 0x46
    "st-mirror-p|",             // Oxyd1 stone 0x47
    "st-mirror-p/",             // Oxyd1 stone 0x48
    "st-mirror-p-",             // Oxyd1 stone 0x49
    "st-mirror-p\\",            // Oxyd1 stone 0x4a
    "st-mirror-p|m",            // Oxyd1 stone 0x4b
    "st-mirror-p/m",            // Oxyd1 stone 0x4c
    "st-mirror-p-m",            // Oxyd1 stone 0x4d
    "st-mirror-p\\m",           // Oxyd1 stone 0x4e
    "st-mirror-p|t",            // Oxyd1 stone 0x4f
    "st-mirror-p/t",            // Oxyd1 stone 0x50
    "st-mirror-p-t",            // Oxyd1 stone 0x51
    "st-mirror-p\\t",           // Oxyd1 stone 0x52
    "st-mirror-3>",             // Oxyd1 stone 0x53
    "st-mirror-3^",             // Oxyd1 stone 0x54
    "st-mirror-3<",             // Oxyd1 stone 0x55
    "st-mirror-3v",             // Oxyd1 stone 0x56
    "st-puzzle2-es",            // Oxyd1 stone 0x57
    "st-puzzle2-sw",            // Oxyd1 stone 0x58
    "st-puzzle2-nw",            // Oxyd1 stone 0x59
    "st-puzzle2-ne",            // Oxyd1 stone 0x5a
    "st-puzzle2-ew",            // Oxyd1 stone 0x5b
    "st-puzzle2-ns",            // Oxyd1 stone 0x5c
    "st-puzzle2-n",             // Oxyd1 stone 0x5d
    "st-puzzle2-s",             // Oxyd1 stone 0x5e
    "st-puzzle2-w",             // Oxyd1 stone 0x5f
    "st-puzzle2-e",             // Oxyd1 stone 0x60
    "st-puzzle2-nesw",          // Oxyd1 stone 0x61
    0,                          // Oxyd1 stone 0x62
    "st-rock6",                 // Oxyd1 stone 0x63 (common was 'st-stone_break') (FIXME: has to be laser-breakable (see Level #2))
    0,                          // Oxyd1 stone 0x64 fake oxyd flavor "a"
    UNUSED,                     // Oxyd1 stone 0x65
    "st-disco-dark",            // Oxyd1 stone 0x66
    "st-disco-medium",          // Oxyd1 stone 0x67
    "st-bombs",                 // Oxyd1 stone 0x68 (common was 'st-shogun-l')
    0,                          // Oxyd1 stone 0x69 (common was 'st-shogun-sml')
    "st-coinslot",              // Oxyd1 stone 0x6a
    "st-thief",                 // Oxyd1 stone 0x6b
    "st-shogun-s",              // Oxyd1 stone 0x6c
    "st-stoneimpulse",          // Oxyd1 stone 0x6d
    "st-laserswitch",           // Oxyd1 stone 0x6e
    0,                          // Oxyd1 stone 0x6f
    0,                          // Oxyd1 stone 0x70
    "st-mail-e",                // Oxyd1 stone 0x71
    "st-mail-s",                // Oxyd1 stone 0x72
    "st-door-h",                // Oxyd1 stone 0x73
    "st-door-v",                // Oxyd1 stone 0x74
    "st-rock2",                 // Oxyd1 stone 0x75
    "st-invisible",             // Oxyd1 stone 0x76
    "st-door-h-open",           // Oxyd1 stone 0x77
    "st-door-v-open",           // Oxyd1 stone 0x78
    UNUSED,                     // Oxyd1 stone 0x79
    0,                          // Oxyd1 stone 0x7a
    UNUSED,                     // Oxyd1 stone 0x7b
    UNUSED,                     // Oxyd1 stone 0x7c
    UNUSED,                     // Oxyd1 stone 0x7d
    UNUSED,                     // Oxyd1 stone 0x7e
    UNUSED,                     // Oxyd1 stone 0x7f
    UNUSED,                     // Oxyd1 stone 0x80
    "",                         // Oxyd1 stone 0x81
    UNUSED,                     // Oxyd1 stone 0x82
    UNUSED,                     // Oxyd1 stone 0x83
    UNUSED,                     // Oxyd1 stone 0x84
    UNUSED,                     // Oxyd1 stone 0x85
    "st-rock2_hole",            // Oxyd1 stone 0x86
    "st-metal",                 // Oxyd1 stone 0x87
    UNUSED,                     // Oxyd1 stone 0x88
    UNUSED,                     // Oxyd1 stone 0x89
    "st-stone1",                // Oxyd1 stone 0x8a
    "st-blue-sand",             // Oxyd1 stone 0x8b
    "st-white1",                // Oxyd1 stone 0x8c
    "st-black1",                // Oxyd1 stone 0x8d
    "st-yinyang2",              // Oxyd1 stone 0x8e
    UNUSED,                     // Oxyd1 stone 0x8f
    0,                          // Oxyd1 stone 0x90 stone with four white marbles
    0,                          // Oxyd1 stone 0x91 stone with four black marbles
    0,                          // Oxyd1 stone 0x92
    "st-yinyang1",              // Oxyd1 stone 0x93
    "st-break_acwhite",         // Oxyd1 stone 0x94
    "st-break_acblack",         // Oxyd1 stone 0x95
    "st-chargeplus",            // Oxyd1 stone 0x96
    "st-chargeminus",           // Oxyd1 stone 0x97
    "st-chargezero",            // Oxyd1 stone 0x98
    0,                          // Oxyd1 stone 0x99 (common was 'st-blocker')
    // codes >= 0x9a are unused
};

static const char *Oxyd1_item_map[256] = {
    0,                          // Oxyd1 item 0x00
    "it-extralife",             // Oxyd1 item 0x01
    0,                          // Oxyd1 item 0x02 document 1
    0,                          // Oxyd1 item 0x03 document 2
    "it-hammer",                // Oxyd1 item 0x04
    "it-coffee",                // Oxyd1 item 0x05
    "it-cherry",                // Oxyd1 item 0x06
    "it-umbrella",              // Oxyd1 item 0x07
    "it-glasses",               // Oxyd1 item 0x08 glasses ?
    0,                          // Oxyd1 item 0x09
    "it-dynamite",              // Oxyd1 item 0x0a
    "it-blackbomb",             // Oxyd1 item 0x0b
    "it-whitebomb",             // Oxyd1 item 0x0c
    "it-crack0",                // Oxyd1 item 0x0d
    "it-crack1",                // Oxyd1 item 0x0e
    "it-crack2",                // Oxyd1 item 0x0f
    "it-crack3",                // Oxyd1 item 0x10
    "it-coin1",                 // Oxyd1 item 0x11
    "it-coin2",                 // Oxyd1 item 0x12
    "it-coin4",                 // Oxyd1 item 0x13
    "it-key",                   // Oxyd1 item 0x14
    0,                          // Oxyd1 item 0x15
    0,                          // Oxyd1 item 0x16
    "it-floppy",                // Oxyd1 item 0x17
    "it-sword",                 // Oxyd1 item 0x18
    "it-flagwhite",             // Oxyd1 item 0x19
    "it-flagblack",             // Oxyd1 item 0x1a
    "it-soother",               // Oxyd1 item 0x1b
    "it-pipe-wn",               // Oxyd1 item 0x1c
    "it-pipe-sw",               // Oxyd1 item 0x1d
    "it-pipe-ne",               // Oxyd1 item 0x1e
    "it-pipe-es",               // Oxyd1 item 0x1f
    "it-pipe-v",                // Oxyd1 item 0x20
    "it-pipe-h",                // Oxyd1 item 0x21
    "it-spade",                 // Oxyd1 item 0x22
    0,                          // Oxyd1 item 0x23
    "it-pin",                   // Oxyd1 item 0x24
    "it-seed",                  // Oxyd1 item 0x25
    "it-spring2",               // Oxyd1 item 0x26
    "it-spring1",               // Oxyd1 item 0x27
    0,                          // Oxyd1 item 0x28 (common was 'it-magnet')
    "it-magnet",                // Oxyd1 item 0x29
    "it-inversesensor",         // Oxyd1 item 0x2a
    "it-sensor",                // Oxyd1 item 0x2b
    "it-shogun-s",              // Oxyd1 item 0x2c
    "it-vortex-open",           // Oxyd1 item 0x2d
    "it-vortex-closed",         // Oxyd1 item 0x2e
    "it-wormhole",              // Oxyd1 item 0x2f
    "it-hill",                  // Oxyd1 item 0x30
    "it-tinyhill",              // Oxyd1 item 0x31
    "it-hollow",                // Oxyd1 item 0x32
    "it-tinyhollow",            // Oxyd1 item 0x33
    "it-vstrip",                // Oxyd1 item 0x34
    "it-hstrip",                // Oxyd1 item 0x35
    "it-springboard",           // Oxyd1 item 0x36
    0,                          // Oxyd1 item 0x37
    "it-bridge-oxyd",           // Oxyd1 item 0x38
    0,                          // Oxyd1 item 0x39 walkable bridge (?)
    UNUSED,                     // Oxyd1 item 0x3a
    UNUSED,                     // Oxyd1 item 0x3b
    UNUSED,                     // Oxyd1 item 0x3c
    UNUSED,                     // Oxyd1 item 0x3d
    UNUSED,                     // Oxyd1 item 0x3e
    UNUSED,                     // Oxyd1 item 0x3f
    UNUSED,                     // Oxyd1 item 0x40
    UNUSED,                     // Oxyd1 item 0x41
    UNUSED,                     // Oxyd1 item 0x42
    UNUSED,                     // Oxyd1 item 0x43
    UNUSED,                     // Oxyd1 item 0x44
    UNUSED,                     // Oxyd1 item 0x45
    UNUSED,                     // Oxyd1 item 0x46
    UNUSED,                     // Oxyd1 item 0x47
    UNUSED,                     // Oxyd1 item 0x48
    UNUSED,                     // Oxyd1 item 0x49
    UNUSED,                     // Oxyd1 item 0x4a
    UNUSED,                     // Oxyd1 item 0x4b
    UNUSED,                     // Oxyd1 item 0x4c
    UNUSED,                     // Oxyd1 item 0x4d
    UNUSED,                     // Oxyd1 item 0x4e
    UNUSED,                     // Oxyd1 item 0x4f
    UNUSED,                     // Oxyd1 item 0x50
    UNUSED,                     // Oxyd1 item 0x51
    UNUSED,                     // Oxyd1 item 0x52
    UNUSED,                     // Oxyd1 item 0x53
    UNUSED,                     // Oxyd1 item 0x54
    UNUSED,                     // Oxyd1 item 0x55
    UNUSED,                     // Oxyd1 item 0x56
    UNUSED,                     // Oxyd1 item 0x57
    UNUSED,                     // Oxyd1 item 0x58
    UNUSED,                     // Oxyd1 item 0x59
    UNUSED,                     // Oxyd1 item 0x5a
    UNUSED,                     // Oxyd1 item 0x5b
    UNUSED,                     // Oxyd1 item 0x5c
    UNUSED,                     // Oxyd1 item 0x5d
    UNUSED,                     // Oxyd1 item 0x5e
    0,                          // Oxyd1 item 0x5f
    0,                          // Oxyd1 item 0x60
    // codes >= 0x61 are unused
};

// ---------------------------------------------
// OxydMagnum/OxydMagnumGold mapping
// ---------------------------------------------

static const char *OxydMagnum_floor_map[256] = {
    "fl-abyss",                 // OxydMagnum floor 0x00
    "fl-gray",                  // OxydMagnum floor 0x01 (common was 'fl-gray')
    "fl-metal",                 // OxydMagnum floor 0x02 (This should be "fl-stwood" for #112)
    0,                          // OxydMagnum floor 0x03 (common was 'fl-metal')
    0,                          // OxydMagnum floor 0x04 (common was 'fl-metal')
    0,                          // OxydMagnum floor 0x05 (common was 'fl-metal')
    0,                          // OxydMagnum floor 0x06 (common was 'fl-metal')
    "fl-normal",                // OxydMagnum floor 0x07 (common was 'fl-metal')
    "fl-tigris",                // OxydMagnum floor 0x08 (common was 'fl-rough')
    "fl-tigris",                // OxydMagnum floor 0x09 (common was 'fl-normal')
    "fl-tigris",                // OxydMagnum floor 0x0a (common was 'fl-normal')
    "fl-tigris",                // OxydMagnum floor 0x0b (common was 'fl-stone')
    "fl-inverse",               // OxydMagnum floor 0x0c (common was 'fl-inverse')
    "fl-acblack",               // OxydMagnum floor 0x0d
    "fl-acwhite",               // OxydMagnum floor 0x0e
    "fl-swamp",                 // OxydMagnum floor 0x0f (common was 'fl-swamp')
    UNUSED,                     // OxydMagnum floor 0x10
    UNUSED,                     // OxydMagnum floor 0x11
    UNUSED,                     // OxydMagnum floor 0x12
    "fl-water",                 // OxydMagnum floor 0x13 (common was 'fl-water')
    UNUSED,                     // OxydMagnum floor 0x14
    UNUSED,                     // OxydMagnum floor 0x15
    UNUSED,                     // OxydMagnum floor 0x16
    "fl-ice_001",               // OxydMagnum floor 0x17 (common was 'fl-ice_001')
    UNUSED,                     // OxydMagnum floor 0x18
    UNUSED,                     // OxydMagnum floor 0x19
    UNUSED,                     // OxydMagnum floor 0x1a
    UNUSED,                     // OxydMagnum floor 0x1b
    "fl-space",                 // OxydMagnum floor 0x1c (common was 'fl-space')
    UNUSED,                     // OxydMagnum floor 0x1d
    UNUSED,                     // OxydMagnum floor 0x1e
    UNUSED,                     // OxydMagnum floor 0x1f
    UNUSED,                     // OxydMagnum floor 0x20
    UNUSED,                     // OxydMagnum floor 0x21
    UNUSED,                     // OxydMagnum floor 0x22
    "fl-gradient1",             // OxydMagnum floor 0x23 (common was 'fl-gradient1')
    "fl-gradient2",             // OxydMagnum floor 0x24 (common was 'fl-gradient2')
    "fl-gradient3",             // OxydMagnum floor 0x25 (common was 'fl-gradient3')
    "fl-gradient4",             // OxydMagnum floor 0x26 (common was 'fl-gradient4')
    "fl-gradient5",             // OxydMagnum floor 0x27 (common was 'fl-gradient5')
    "fl-gradient6",             // OxydMagnum floor 0x28 (common was 'fl-gradient6')
    "fl-gradient7",             // OxydMagnum floor 0x29 (common was 'fl-gradient7')
    "fl-gradient8",             // OxydMagnum floor 0x2a (common was 'fl-gradient8')
    "fl-gradient9",             // OxydMagnum floor 0x2b (common was 'fl-gradient9')
    "fl-gradient10",            // OxydMagnum floor 0x2c (common was 'fl-gradient10')
    "fl-gradient11",            // OxydMagnum floor 0x2d (common was 'fl-gradient11')
    "fl-gradient12",            // OxydMagnum floor 0x2e (common was 'fl-gradient12')
    "fl-gradient13",            // OxydMagnum floor 0x2f (common was 'fl-gradient13')
    "fl-gradient14",            // OxydMagnum floor 0x30 (common was 'fl-gradient14')
    "fl-gradient15",            // OxydMagnum floor 0x31 (common was 'fl-gradient15')
    "fl-gradient16",            // OxydMagnum floor 0x32 (common was 'fl-gradient16')
    "fl-brick",                 // OxydMagnum floor 0x33 (common was 'fl-rough')
    "fl-brick",                 // OxydMagnum floor 0x34 (common was 'fl-rough')
    UNUSED,                     // OxydMagnum floor 0x35
    UNUSED,                     // OxydMagnum floor 0x36
    "fl-brick",                 // OxydMagnum floor 0x37
    "fl-brick",                 // OxydMagnum floor 0x38
    UNUSED,                     // OxydMagnum floor 0x39
    UNUSED,                     // OxydMagnum floor 0x3a
    UNUSED,                     // OxydMagnum floor 0x3b
    "fl-rock",                  // OxydMagnum floor 0x3c
    UNUSED,                     // OxydMagnum floor 0x3d
    UNUSED,                     // OxydMagnum floor 0x3e
    0,                          // OxydMagnum floor 0x3f (common was 'fl-wood')
    0,                          // OxydMagnum floor 0x40 (common was 'fl-wood')
    "fl-wood",                  // OxydMagnum floor 0x41 (common was 'fl-wood')
    0,                          // OxydMagnum floor 0x42
    UNUSED,                     // OxydMagnum floor 0x43
    UNUSED,                     // OxydMagnum floor 0x44
    UNUSED,                     // OxydMagnum floor 0x45
    "fl-gravel",                // OxydMagnum floor 0x46
    "fl-gravel",                // OxydMagnum floor 0x47
    UNUSED,                     // OxydMagnum floor 0x48
    UNUSED,                     // OxydMagnum floor 0x49
    UNUSED,                     // OxydMagnum floor 0x4a
    UNUSED,                     // OxydMagnum floor 0x4b
    "fl-stone",                 // OxydMagnum floor 0x4c
    "fl-stone",                 // OxydMagnum floor 0x4d
    UNUSED,                     // OxydMagnum floor 0x4e
    UNUSED,                     // OxydMagnum floor 0x4f
    UNUSED,                     // OxydMagnum floor 0x50
    UNUSED,                     // OxydMagnum floor 0x51
    "fl-bridge",                // OxydMagnum floor 0x52 (common was 'fl-bridge')
    "fl-springboard",           // OxydMagnum floor 0x53
    0,                          // OxydMagnum floor 0x54
    0,                          // OxydMagnum floor 0x55 (common was 'fl-plank')
    0,                          // OxydMagnum floor 0x56
    UNUSED,                     // OxydMagnum floor 0x57
    0,                          // OxydMagnum floor 0x58
    "fl-leaves",                // OxydMagnum floor 0x59
    0,                          // OxydMagnum floor 0x5a
    0,                          // OxydMagnum floor 0x5b
    // codes >= 0x5c are unused
};

static const char *OxydMagnum_stone_map[256] = {
    0,                          // OxydMagnum stone 0x00
    0,0,0,0,0,0,0,0,            // 0x01 -- 0x08  Oxyd stones 
    0,0,0,0,0,0,0,0,            // 0x09 -- 0x10  Oxyd stones
    "st-likeoxydd",             // OxydMagnum stone 0x11
    "st-bluegray",              // OxydMagnum stone 0x12
    "st-bigbrick-es",           // OxydMagnum stone 0x13
    "st-bigbrick-sw",           // OxydMagnum stone 0x14
    "st-bigbrick-ne",           // OxydMagnum stone 0x15
    "st-bigbrick-nw",           // OxydMagnum stone 0x16
    UNUSED,                     // OxydMagnum stone 0x17
    UNUSED,                     // OxydMagnum stone 0x18
    0,                          // OxydMagnum stone 0x19
    "st-grate1",                // OxydMagnum stone 0x1a
    0,                          // OxydMagnum stone 0x1b
    0,                          // OxydMagnum stone 0x1c (common was 'st-rock4')
    UNUSED,                     // OxydMagnum stone 0x1d
    UNUSED,                     // OxydMagnum stone 0x1e
    "st-brick",                 // OxydMagnum stone 0x1f
    "st-rock1",                 // OxydMagnum stone 0x20
    0,                          // OxydMagnum stone 0x21
    0,                          // OxydMagnum stone 0x22 (common was 'st-glass')
    "st-woven",                 // OxydMagnum stone 0x23
    "st-marble",                // OxydMagnum stone 0x24
    "st-glass1",                // OxydMagnum stone 0x25
    "st-glass3",                // OxydMagnum stone 0x26
    "st-glass1",                // OxydMagnum stone 0x27
    "st-rock3_break",           // OxydMagnum stone 0x28
    "st-bluegray_hole",         // OxydMagnum stone 0x29
    0,                          // OxydMagnum stone 0x2a
    "st-wood",                  // OxydMagnum stone 0x2b
    "st-switch",                // OxydMagnum stone 0x2c
    "st-floppy",                // OxydMagnum stone 0x2d
    UNUSED,                     // OxydMagnum stone 0x2e
    0,                          // OxydMagnum stone 0x2f (common was 'st-death')
    "st-key_a",                 // OxydMagnum stone 0x30
    0,                          // OxydMagnum stone 0x31 (common was 'st-oneway_black-w')
    0,                          // OxydMagnum stone 0x32 (common was 'st-oneway_black-e')
    0,                          // OxydMagnum stone 0x33 (common was 'st-oneway_black-n')
    "st-death",                 // OxydMagnum stone 0x34 (common was 'st-oneway_black-s')
    "st-death_invisible",       // OxydMagnum stone 0x35 (common was 'st-oneway_white-w')
    0,                          // OxydMagnum stone 0x36 (common was 'st-oneway_white-e')
    0,                          // OxydMagnum stone 0x37 (common was 'st-oneway_white-n')
    0,                          // OxydMagnum stone 0x38 (common was 'st-oneway_white-s')
    0,                          // OxydMagnum stone 0x39 (common was 'st-magic')
    0,                          // OxydMagnum stone 0x3a (common was 'st-magic')
    0,                          // OxydMagnum stone 0x3b (common was 'st-magic')
    0,                          // OxydMagnum stone 0x3c
    0,                          // OxydMagnum stone 0x3d
    UNUSED,                     // OxydMagnum stone 0x3e
    0,                          // OxydMagnum stone 0x3f
    0,                          // OxydMagnum stone 0x40
    UNUSED,                     // OxydMagnum stone 0x41
    "st-actorimpulse",          // OxydMagnum stone 0x42
    "st-actorimpulse_invisible", // OxydMagnum stone 0x43
    "st-laser-1",               // OxydMagnum stone 0x44  The laser-names are fake names!
    "st-laser-2",               // OxydMagnum stone 0x45  Direction and state are generated by Enigma.
    "st-laser-3",               // OxydMagnum stone 0x46
    "st-mirror-p|",             // OxydMagnum stone 0x47
    "st-mirror-p/",             // OxydMagnum stone 0x48
    "st-mirror-p-",             // OxydMagnum stone 0x49
    "st-mirror-p\\",            // OxydMagnum stone 0x4a
    "st-mirror-p|m",            // OxydMagnum stone 0x4b
    "st-mirror-p/m",            // OxydMagnum stone 0x4c
    "st-mirror-p-m",            // OxydMagnum stone 0x4d
    "st-mirror-p\\m",           // OxydMagnum stone 0x4e
    "st-mirror-p|t",            // OxydMagnum stone 0x4f
    "st-mirror-p/t",            // OxydMagnum stone 0x50
    "st-mirror-p-t",            // OxydMagnum stone 0x51
    "st-mirror-p\\t",           // OxydMagnum stone 0x52
    "st-mirror-3>",             // OxydMagnum stone 0x53
    "st-mirror-3^",             // OxydMagnum stone 0x54
    "st-mirror-3<",             // OxydMagnum stone 0x55
    "st-mirror-3v",             // OxydMagnum stone 0x56
    0,                          // OxydMagnum stone 0x57
    0,                          // OxydMagnum stone 0x58
    0,                          // OxydMagnum stone 0x59
    0,                          // OxydMagnum stone 0x5a
    0,                          // OxydMagnum stone 0x5b
    0,                          // OxydMagnum stone 0x5c
    "st-puzzle2-n",             // OxydMagnum stone 0x5d
    "st-puzzle2-s",             // OxydMagnum stone 0x5e
    0,                          // OxydMagnum stone 0x5f
    0,                          // OxydMagnum stone 0x60
    0,                          // OxydMagnum stone 0x61
    0,                          // OxydMagnum stone 0x62
    0,                          // OxydMagnum stone 0x63 (common was 'st-stone_break')
    0,                          // OxydMagnum stone 0x64
    UNUSED,                     // OxydMagnum stone 0x65
    UNUSED,                     // OxydMagnum stone 0x66
    UNUSED,                     // OxydMagnum stone 0x67
    "st-bombs",                 // OxydMagnum stone 0x68 (common was 'st-shogun-l')
    0,                          // OxydMagnum stone 0x69 (common was 'st-shogun-sml')
    0,                          // OxydMagnum stone 0x6a (common was 'st-shogun-ml')
    0,                          // OxydMagnum stone 0x6b (common was 'st-shogun-sl')
    0,                          // OxydMagnum stone 0x6c (common was 'st-shogun-sm')
    "st-stoneimpulse",          // OxydMagnum stone 0x6d
    "st-timeswitch",            // OxydMagnum stone 0x6e
    0,                          // OxydMagnum stone 0x6f
    0,                          // OxydMagnum stone 0x70
    0,                          // OxydMagnum stone 0x71
    0,                          // OxydMagnum stone 0x72
    0,                          // OxydMagnum stone 0x73 (common was 'st-door-h')
    "st-door-v",                // OxydMagnum stone 0x74 (common was 'st-door-v')
    "st-rock2",                 // OxydMagnum stone 0x75 (common was 'st-rock2')
    "st-invisible",             // OxydMagnum stone 0x76
    UNUSED,                     // OxydMagnum stone 0x77
    0,                          // OxydMagnum stone 0x78
    UNUSED,                     // OxydMagnum stone 0x79
    0,                          // OxydMagnum stone 0x7a
    UNUSED,                     // OxydMagnum stone 0x7b
    UNUSED,                     // OxydMagnum stone 0x7c
    UNUSED,                     // OxydMagnum stone 0x7d
    UNUSED,                     // OxydMagnum stone 0x7e
    UNUSED,                     // OxydMagnum stone 0x7f
    UNUSED,                     // OxydMagnum stone 0x80
    UNUSED,                     // OxydMagnum stone 0x81
    UNUSED,                     // OxydMagnum stone 0x82
    UNUSED,                     // OxydMagnum stone 0x83
    UNUSED,                     // OxydMagnum stone 0x84
    UNUSED,                     // OxydMagnum stone 0x85
    0,                          // OxydMagnum stone 0x86
    "st-rock1",                 // OxydMagnum stone 0x87
    0,                          // OxydMagnum stone 0x88
    0,                          // OxydMagnum stone 0x89
    "st-stone1",                // OxydMagnum stone 0x8a
    "st-rock6",                 // OxydMagnum stone 0x8b
    "st-white1",                // OxydMagnum stone 0x8c
    "st-black1",                // OxydMagnum stone 0x8d
    "st-yinyang2",              // OxydMagnum stone 0x8e
    UNUSED,                     // OxydMagnum stone 0x8f
    0,                          // OxydMagnum stone 0x90
    UNUSED,                     // OxydMagnum stone 0x91
    0,                          // OxydMagnum stone 0x92
    "st-yinyang1",              // OxydMagnum stone 0x93
    "st-break_acwhite",         // OxydMagnum stone 0x94
    "st-break_acblack",         // OxydMagnum stone 0x95
    0,                          // OxydMagnum stone 0x96
    0,                          // OxydMagnum stone 0x97
    0,                          // OxydMagnum stone 0x98
    0,                          // OxydMagnum stone 0x99 (common was 'st-blocker')
    0,                          // OxydMagnum stone 0x9a (common was 'st-grate1')
    0,                          // OxydMagnum stone 0x9b
    0,                          // OxydMagnum stone 0x9c
    0,                          // OxydMagnum stone 0x9d
    0,                          // OxydMagnum stone 0x9e (common was 'st-turnstile')
    UNUSED,                     // OxydMagnum stone 0x9f
    UNUSED,                     // OxydMagnum stone 0xa0
    UNUSED,                     // OxydMagnum stone 0xa1
    UNUSED,                     // OxydMagnum stone 0xa2
    UNUSED,                     // OxydMagnum stone 0xa3
    "st-stoneimpulse-hollow",   // OxydMagnum stone 0xa4
    UNUSED,                     // OxydMagnum stone 0xa5
    UNUSED,                     // OxydMagnum stone 0xa6
    0,                          // OxydMagnum stone 0xa7
    UNUSED,                     // OxydMagnum stone 0xa8
    0,                          // OxydMagnum stone 0xa9
    // codes >= 0xaa are unused
};

static const char *OxydMagnum_item_map[256] = {
    0,                          // OxydMagnum item 0x00
    "it-extralife",             // OxydMagnum item 0x01 (common was 'it-extralife')
    0,                          // OxydMagnum item 0x02 (common was 'it-document')
    0,                          // OxydMagnum item 0x03 (common was 'it-document')
    "it-hammer",                // OxydMagnum item 0x04
    0,                          // OxydMagnum item 0x05
    0,                          // OxydMagnum item 0x06
    "it-umbrella",              // OxydMagnum item 0x07 (common was 'it-umbrella')
    0,                          // OxydMagnum item 0x08
    0,                          // OxydMagnum item 0x09
    "it-dynamite",              // OxydMagnum item 0x0a
    0,                          // OxydMagnum item 0x0b (common was 'it-blackbomb')
    0,                          // OxydMagnum item 0x0c
    "it-crack0",                // OxydMagnum item 0x0d
    0,                          // OxydMagnum item 0x0e
    0,                          // OxydMagnum item 0x0f
    0,                          // OxydMagnum item 0x10
    0,                          // OxydMagnum item 0x11 (common was 'it-coin1')
    0,                          // OxydMagnum item 0x12 (common was 'it-coin2')
    0,                          // OxydMagnum item 0x13 (common was 'it-coin4')
    0,                          // OxydMagnum item 0x14
    0,                          // OxydMagnum item 0x15
    0,                          // OxydMagnum item 0x16
    0,                          // OxydMagnum item 0x17 (common was 'it-floppy')
    0,                          // OxydMagnum item 0x18
    0,                          // OxydMagnum item 0x19
    0,                          // OxydMagnum item 0x1a
    0,                          // OxydMagnum item 0x1b
    0,                          // OxydMagnum item 0x1c
    0,                          // OxydMagnum item 0x1d
    0,                          // OxydMagnum item 0x1e
    0,                          // OxydMagnum item 0x1f
    0,                          // OxydMagnum item 0x20
    0,                          // OxydMagnum item 0x21 (common was 'it-spade')
    0,                          // OxydMagnum item 0x22
    UNUSED,                     // OxydMagnum item 0x23
    0,                          // OxydMagnum item 0x24 (common was 'it-seed')
    "it-seed",                  // OxydMagnum item 0x25
    "it-spring2",               // OxydMagnum item 0x26
    "it-spring1",               // OxydMagnum item 0x27
    0,                          // OxydMagnum item 0x28 (common was 'it-magnet')
    0,                          // OxydMagnum item 0x29
    "it-inversesensor",         // OxydMagnum item 0x2a
    "it-sensor",                // OxydMagnum item 0x2b (common was 'it-shogun-s')
    "it-shogun-s",              // OxydMagnum item 0x2c
    "it-vortex-open",           // OxydMagnum item 0x2d
    0,                          // OxydMagnum item 0x2e
    0,                          // OxydMagnum item 0x2f (common was 'it-wormhole')
    "it-hill",                  // OxydMagnum item 0x30
    "it-tinyhill",              // OxydMagnum item 0x31
    "it-hollow",                // OxydMagnum item 0x32
    "it-tinyhollow",            // OxydMagnum item 0x33
    0,                          // OxydMagnum item 0x34
    0,                          // OxydMagnum item 0x35
    "it-springboard",           // OxydMagnum item 0x36
    0,                          // OxydMagnum item 0x37
    0,                          // OxydMagnum item 0x38
    UNUSED,                     // OxydMagnum item 0x39
    UNUSED,                     // OxydMagnum item 0x3a
    UNUSED,                     // OxydMagnum item 0x3b
    UNUSED,                     // OxydMagnum item 0x3c
    UNUSED,                     // OxydMagnum item 0x3d
    UNUSED,                     // OxydMagnum item 0x3e
    UNUSED,                     // OxydMagnum item 0x3f
    UNUSED,                     // OxydMagnum item 0x40
    UNUSED,                     // OxydMagnum item 0x41
    UNUSED,                     // OxydMagnum item 0x42
    UNUSED,                     // OxydMagnum item 0x43
    UNUSED,                     // OxydMagnum item 0x44
    UNUSED,                     // OxydMagnum item 0x45
    UNUSED,                     // OxydMagnum item 0x46
    UNUSED,                     // OxydMagnum item 0x47
    UNUSED,                     // OxydMagnum item 0x48
    UNUSED,                     // OxydMagnum item 0x49
    UNUSED,                     // OxydMagnum item 0x4a
    UNUSED,                     // OxydMagnum item 0x4b
    "it-springboard",           // OxydMagnum item 0x4c
    UNUSED,                     // OxydMagnum item 0x4d
    UNUSED,                     // OxydMagnum item 0x4e
    UNUSED,                     // OxydMagnum item 0x4f
    UNUSED,                     // OxydMagnum item 0x50
    UNUSED,                     // OxydMagnum item 0x51
    UNUSED,                     // OxydMagnum item 0x52
    UNUSED,                     // OxydMagnum item 0x53
    UNUSED,                     // OxydMagnum item 0x54
    UNUSED,                     // OxydMagnum item 0x55
    UNUSED,                     // OxydMagnum item 0x56
    UNUSED,                     // OxydMagnum item 0x57
    UNUSED,                     // OxydMagnum item 0x58
    UNUSED,                     // OxydMagnum item 0x59
    UNUSED,                     // OxydMagnum item 0x5a
    UNUSED,                     // OxydMagnum item 0x5b
    UNUSED,                     // OxydMagnum item 0x5c
    UNUSED,                     // OxydMagnum item 0x5d
    UNUSED,                     // OxydMagnum item 0x5e
    0,                          // OxydMagnum item 0x5f
    0,                          // OxydMagnum item 0x60
    UNUSED,                     // OxydMagnum item 0x61
    UNUSED,                     // OxydMagnum item 0x62
    0,                          // OxydMagnum item 0x63 (common was 'it-trigger')
    "it-puller-n",              // OxydMagnum item 0x64
    "it-puller-s",              // OxydMagnum item 0x65
    "it-puller-w",              // OxydMagnum item 0x66
    "it-puller-e",              // OxydMagnum item 0x67
    // codes >= 0x68 are unused
};

// ---------------------------------------------
// PerOxyd mapping
// ---------------------------------------------

static const char *PerOxyd_floor_map[256] = {
    "fl-abyss",                 // PerOxyd floor 0x00
    "fl-gray",                  // PerOxyd floor 0x01
    "fl-metal",                 // PerOxyd floor 0x02
    0,                          // PerOxyd floor 0x03 (common was 'fl-metal')
    0,                          // PerOxyd floor 0x04 (common was 'fl-metal')
    0,                          // PerOxyd floor 0x05 (common was 'fl-metal')
    0,                          // PerOxyd floor 0x06 (common was 'fl-metal')
    0,                          // PerOxyd floor 0x07 (common was 'fl-metal')
    "fl-rough-red",             // PerOxyd floor 0x08 (common was 'fl-rough')
    "fl-rough-blue",            // PerOxyd floor 0x09 (common was 'fl-normal')
    "fl-rough-blue",            // PerOxyd floor 0x0a (common was 'fl-normal')
    "fl-rough-red",             // PerOxyd floor 0x0b (common was 'fl-stone')
    0,                          // PerOxyd floor 0x0c (common was 'fl-inverse')
    "fl-acblack",               // PerOxyd floor 0x0d
    "fl-acwhite",               // PerOxyd floor 0x0e
    "fl-swamp",                 // PerOxyd floor 0x0f
    UNUSED,                     // PerOxyd floor 0x10
    UNUSED,                     // PerOxyd floor 0x11
    UNUSED,                     // PerOxyd floor 0x12
    "fl-water",                 // PerOxyd floor 0x13
    0,                          // PerOxyd floor 0x14 (common was 'fl-water')
    UNUSED,                     // PerOxyd floor 0x15
    UNUSED,                     // PerOxyd floor 0x16
    0,                          // PerOxyd floor 0x17 (common was 'fl-ice_001')
    UNUSED,                     // PerOxyd floor 0x18
    UNUSED,                     // PerOxyd floor 0x19
    UNUSED,                     // PerOxyd floor 0x1a
    UNUSED,                     // PerOxyd floor 0x1b
    0,                          // PerOxyd floor 0x1c (common was 'fl-space')
    UNUSED,                     // PerOxyd floor 0x1d
    UNUSED,                     // PerOxyd floor 0x1e
    UNUSED,                     // PerOxyd floor 0x1f
    UNUSED,                     // PerOxyd floor 0x20
    0,                          // PerOxyd floor 0x21 (common was 'fl-space')
    UNUSED,                     // PerOxyd floor 0x22
    "fl-gradient1",             // PerOxyd floor 0x23
    "fl-gradient2",             // PerOxyd floor 0x24
    "fl-gradient3",             // PerOxyd floor 0x25
    "fl-gradient4",             // PerOxyd floor 0x26
    "fl-gradient5",             // PerOxyd floor 0x27
    "fl-gradient6",             // PerOxyd floor 0x28
    "fl-gradient7",             // PerOxyd floor 0x29
    "fl-gradient8",             // PerOxyd floor 0x2a
    "fl-gradient9",             // PerOxyd floor 0x2b
    "fl-gradient10",            // PerOxyd floor 0x2c
    "fl-gradient11",            // PerOxyd floor 0x2d
    "fl-gradient12",            // PerOxyd floor 0x2e
    "fl-gradient13",            // PerOxyd floor 0x2f
    "fl-gradient14",            // PerOxyd floor 0x30
    "fl-gradient15",            // PerOxyd floor 0x31
    "fl-gradient16",            // PerOxyd floor 0x32
    0,                          // PerOxyd floor 0x33 (common was 'fl-rough')
    "fl-rough",                 // PerOxyd floor 0x34
    UNUSED,                     // PerOxyd floor 0x35
    UNUSED,                     // PerOxyd floor 0x36
    UNUSED,                     // PerOxyd floor 0x37
    "fl-concrete",              // PerOxyd floor 0x38
    0,                          // PerOxyd floor 0x39
    UNUSED,                     // PerOxyd floor 0x3a
    UNUSED,                     // PerOxyd floor 0x3b
    0,                          // PerOxyd floor 0x3c
    "fl-samba",                 // PerOxyd floor 0x3d (common was 'fl-wood')
    0,                          // PerOxyd floor 0x3e (common was 'fl-wood')
    0,                          // PerOxyd floor 0x3f (common was 'fl-wood')
    UNUSED,                     // PerOxyd floor 0x40
    UNUSED,                     // PerOxyd floor 0x41
    0,                          // PerOxyd floor 0x42
    "fl-bumps",                 // PerOxyd floor 0x43
    UNUSED,                     // PerOxyd floor 0x44
    UNUSED,                     // PerOxyd floor 0x45
    UNUSED,                     // PerOxyd floor 0x46
    UNUSED,                     // PerOxyd floor 0x47
    "fl-concrete",              // PerOxyd floor 0x48
    UNUSED,                     // PerOxyd floor 0x49
    UNUSED,                     // PerOxyd floor 0x4a
    UNUSED,                     // PerOxyd floor 0x4b
    "fl-bridge-open",           // PerOxyd floor 0x4c
    UNUSED,                     // PerOxyd floor 0x4d
    0,                          // PerOxyd floor 0x4e
    0,                          // PerOxyd floor 0x4f
    "fl-black",                 // PerOxyd floor 0x50
    "fl-white",                 // PerOxyd floor 0x51
    "fl-black",                 // PerOxyd floor 0x52 (was 'fl-bridge')
    0,                          // PerOxyd floor 0x53
    UNUSED,                     // PerOxyd floor 0x54
    0,                          // PerOxyd floor 0x55 (common was 'fl-plank')
    UNUSED,                     // PerOxyd floor 0x56
    0,                          // PerOxyd floor 0x57
    UNUSED,                     // PerOxyd floor 0x58
    UNUSED,                     // PerOxyd floor 0x59
    UNUSED,                     // PerOxyd floor 0x5a
    "fl-gravel",                // PerOxyd floor 0x5b
    UNUSED,                     // PerOxyd floor 0x5c
    UNUSED,                     // PerOxyd floor 0x5d
    0,                          // PerOxyd floor 0x5e
    // codes >= 0x5f are unused
};

static const char *PerOxyd_stone_map[256] = {
    0,                   // PerOxyd stone 0x00 ??
    0,0,0,0,0,0,0,0,     // PerOxyd stone 0x01 - 0x08   oxyd stones
    0,0,0,0,0,0,0,0,     // PerOxyd stone 0x08 - 0x10   oxyd stones
    "st-likeoxydc",      // PerOxyd stone 0x11
    "st-likeoxydc-open", // PerOxyd stone 0x12
    "st-rock4",          // PerOxyd stone 0x13
    "st-beads",          // PerOxyd stone 0x14
    0,                   // PerOxyd stone 0x15 (common was 'st-rock5')
    "st-rock7",          // PerOxyd stone 0x16
    0,                   // PerOxyd stone 0x17
    "st-grate1",         // PerOxyd stone 0x18
    UNUSED,              // PerOxyd stone 0x19
    0,                   // PerOxyd stone 0x1a
    0,                   // PerOxyd stone 0x1b
    "st-rock4",          // PerOxyd stone 0x1c
    "st-rock3",          // PerOxyd stone 0x1d
    0,                   // PerOxyd stone 0x1e
    UNUSED,              // PerOxyd stone 0x1f
    "st-stone2",         // PerOxyd stone 0x20
    0,                   // PerOxyd stone 0x21
    "st-glass",          // PerOxyd stone 0x22
    0,                   // PerOxyd stone 0x23
    0,                   // PerOxyd stone 0x24
    "st-bluegray_hole",  // PerOxyd stone 0x25
    0,                   // PerOxyd stone 0x26
    "st-wood",           // PerOxyd stone 0x27
    "st-switch",         // PerOxyd stone 0x28
    "st-switch_black",   // PerOxyd stone 0x29
    "st-switch_white",   // PerOxyd stone 0x2a
    "st-fourswitch",     // PerOxyd stone 0x2b
    "st-switch",         // PerOxyd stone 0x2c
    "st-floppy",         // PerOxyd stone 0x2d
    "st-timer",          // PerOxyd stone 0x2e
    "st-death",          // PerOxyd stone 0x2f
    "st-death_invisible",// PerOxyd stone 0x30
    "st-oneway_black-w", // PerOxyd stone 0x31
    "st-oneway_black-e", // PerOxyd stone 0x32
    "st-oneway_black-n", // PerOxyd stone 0x33
    "st-oneway_black-s", // PerOxyd stone 0x34
    "st-oneway_white-w", // PerOxyd stone 0x35
    "st-oneway_white-e", // PerOxyd stone 0x36
    "st-oneway_white-n", // PerOxyd stone 0x37
    "st-oneway_white-s", // PerOxyd stone 0x38
    0,                   // PerOxyd stone 0x39 (common was 'st-magic')
    0,                   // PerOxyd stone 0x3a (common was 'st-magic')
    0,                   // PerOxyd stone 0x3b (common was 'st-magic')
    "st-actorimpulse",   // PerOxyd stone 0x3c
    "st-actorimpulse_invisible", // PerOxyd stone 0x3d
    "st-laser-1",        // PerOxyd stone 0x3e  The laser-names are fake names!
    "st-laser-2",        // PerOxyd stone 0x3f  Direction and state are generated by Enigma.
    "st-laser-3",        // PerOxyd stone 0x40
    "st-mirror-p|",      // PerOxyd stone 0x41
    "st-mirror-p/",      // PerOxyd stone 0x42
    "st-mirror-p-",      // PerOxyd stone 0x43
    "st-mirror-p\\",     // PerOxyd stone 0x44
    UNUSED,              // PerOxyd stone 0x45
    "st-mirror-p/m",     // PerOxyd stone 0x46
    "st-mirror-p-m",     // PerOxyd stone 0x47
    "st-mirror-p\\m",    // PerOxyd stone 0x48
    "st-mirror-p|t",     // PerOxyd stone 0x49
    "st-mirror-p/t",     // PerOxyd stone 0x4a
    "st-mirror-p-t",     // PerOxyd stone 0x4b
    "st-mirror-p\\t",    // PerOxyd stone 0x4c
    "st-mirror-3>",      // PerOxyd stone 0x4d
    "st-mirror-3^",      // PerOxyd stone 0x4e
    "st-mirror-3<",      // PerOxyd stone 0x4f
    "st-mirror-3v",      // PerOxyd stone 0x50
    "st-puzzle-es",      // PerOxyd stone 0x51
    "st-puzzle-sw",      // PerOxyd stone 0x52
    "st-puzzle-nw",      // PerOxyd stone 0x53
    "st-puzzle-ne",      // PerOxyd stone 0x54
    "st-puzzle-ew",      // PerOxyd stone 0x55
    "st-puzzle-ns",      // PerOxyd stone 0x56
    "st-puzzle-n",       // PerOxyd stone 0x57
    "st-puzzle-s",       // PerOxyd stone 0x58
    "st-puzzle-w",       // PerOxyd stone 0x59
    "st-puzzle-e",       // PerOxyd stone 0x5a
    "st-puzzle-nesw",    // PerOxyd stone 0x5b
    "st-puzzle-hollow",  // PerOxyd stone 0x5c
    0,                   // PerOxyd stone 0x5d
    0,                   // PerOxyd stone 0x5e (coffee-stone, opens like an oxyd, then it may be moved and below is a cup of coffee)
    0,                   // PerOxyd stone 0x5f
    "st-disco-dark",     // PerOxyd stone 0x60
    "st-disco-medium",   // PerOxyd stone 0x61
    "st-bombs",          // PerOxyd stone 0x62
    0,                   // PerOxyd stone 0x63 flash
    "st-coinslot",       // PerOxyd stone 0x64
    "st-thief",          // PerOxyd stone 0x65
    "st-shogun-s",       // PerOxyd stone 0x66
    "st-shogun-m",       // PerOxyd stone 0x67
    "st-shogun-l",       // PerOxyd stone 0x68
    "st-shogun-sml",     // PerOxyd stone 0x69
    "st-shogun-ml",      // PerOxyd stone 0x6a
    "st-shogun-sl",      // PerOxyd stone 0x6b
    "st-shogun-sm",      // PerOxyd stone 0x6c
    "st-stoneimpulse",   // PerOxyd stone 0x6d
    0,                   // PerOxyd stone 0x6e
    "st-mail-n",         // PerOxyd stone 0x6f
    "st-mail-w",         // PerOxyd stone 0x70
    "st-mail-e",         // PerOxyd stone 0x71
    "st-mail-s",         // PerOxyd stone 0x72
    "st-door-h",         // PerOxyd stone 0x73
    "st-door-v",         // PerOxyd stone 0x74
    "st-rock2",          // PerOxyd stone 0x75 looks like a white version of st-rock2 (common was 'st-rock2')
    "st-stonebrush",     // PerOxyd stone 0x76
    0,                   // PerOxyd stone 0x77
    0,                   // PerOxyd stone 0x78
    "st-white1",         // PerOxyd stone 0x79
    "st-black1",         // PerOxyd stone 0x7a
    0,                   // PerOxyd stone 0x7b
    0,                   // PerOxyd stone 0x7c
    "st-yinyang1",       // PerOxyd stone 0x7d
    "st-break_acwhite",  // PerOxyd stone 0x7e
    "st-break_acblack",  // PerOxyd stone 0x7f
    0,                   // PerOxyd stone 0x80
    0,                   // PerOxyd stone 0x81
    0,                   // PerOxyd stone 0x82
    "st-bolder-n",       // PerOxyd stone 0x83
    "st-bolder-s",       // PerOxyd stone 0x84
    "st-bolder-w",       // PerOxyd stone 0x85
    "st-bolder-e",       // PerOxyd stone 0x86
    "st-rock5",          // PerOxyd stone 0x87
    UNUSED,              // PerOxyd stone 0x88
    UNUSED,              // PerOxyd stone 0x89
    0,                   // PerOxyd stone 0x8a
    0,                   // PerOxyd stone 0x8b
    "st-rock3",          // PerOxyd stone 0x8c
    0,                   // PerOxyd stone 0x8d
    0,                   // PerOxyd stone 0x8e (common was 'st-rock6')
    UNUSED,              // PerOxyd stone 0x8f
    "st-rock8",          // PerOxyd stone 0x90
    "st-rotator_move-left",  // PerOxyd stone 0x91
    "st-rotator_move-right", // PerOxyd stone 0x92
    "st-swap",           // PerOxyd stone 0x93
    0,                   // PerOxyd stone 0x94
    0,                   // PerOxyd stone 0x95
    "st-rubberband",     // PerOxyd stone 0x96
    "st-scissors",       // PerOxyd stone 0x97
    "st-grate3",         // PerOxyd stone 0x98
    "st-blocker",        // PerOxyd stone 0x99
    "st-grate1",         // PerOxyd stone 0x9a
    0,                   // PerOxyd stone 0x9b
    "st-stone1",         // PerOxyd stone 0x9c
    "st-fart",           // PerOxyd stone 0x9d
    "st-turnstile",      // PerOxyd stone 0x9e
    "st-turnstile-n",    // PerOxyd stone 0x9f
    "st-turnstile-s",    // PerOxyd stone 0xa0
    "st-turnstile-w",    // PerOxyd stone 0xa1
    "st-turnstile-e",    // PerOxyd stone 0xa2
    UNUSED,              // PerOxyd stone 0xa3
    0,                   // PerOxyd stone 0xa4
    UNUSED,              // PerOxyd stone 0xa5
    UNUSED,              // PerOxyd stone 0xa6
    UNUSED,              // PerOxyd stone 0xa7
    UNUSED,              // PerOxyd stone 0xa8
    UNUSED,              // PerOxyd stone 0xa9
    UNUSED,              // PerOxyd stone 0xaa
    UNUSED,              // PerOxyd stone 0xab
    UNUSED,              // PerOxyd stone 0xac
    UNUSED,              // PerOxyd stone 0xad
    UNUSED,              // PerOxyd stone 0xae
    UNUSED,              // PerOxyd stone 0xaf
    UNUSED,              // PerOxyd stone 0xb0
    UNUSED,              // PerOxyd stone 0xb1
    UNUSED,              // PerOxyd stone 0xb2
    UNUSED,              // PerOxyd stone 0xb3
    UNUSED,              // PerOxyd stone 0xb4
    UNUSED,              // PerOxyd stone 0xb5
    UNUSED,              // PerOxyd stone 0xb6
    "st-easymode",       // PerOxyd stone 0xb7
    0,                   // PerOxyd stone 0xb8
    0,                   // PerOxyd stone 0xb9
    // codes >= 0xba are unused
};

static const char *PerOxyd_item_map[256] = {
    0,                   // PerOxyd item 0x00
    "it-extralife",      // PerOxyd item 0x01
    0,                   // PerOxyd item 0x02 document 1
    0,                   // PerOxyd item 0x03 document 2
    "it-hammer",         // PerOxyd item 0x04
    "it-coffee",         // PerOxyd item 0x05
    "it-cherry",         // PerOxyd item 0x06
    "it-umbrella",       // PerOxyd item 0x07
    "it-glasses",        // PerOxyd item 0x08 glasses
    0,                   // PerOxyd item 0x09 broken glasses
    "it-dynamite",       // PerOxyd item 0x0a
    "it-blackbomb",      // PerOxyd item 0x0b
    "it-whitebomb",      // PerOxyd item 0x0c
    "it-crack0",         // PerOxyd item 0x0d
    "it-crack1",         // PerOxyd item 0x0e
    "it-crack2",         // PerOxyd item 0x0f
    "it-crack3",         // PerOxyd item 0x10
    "it-coin1",          // PerOxyd item 0x11
    "it-coin2",          // PerOxyd item 0x12
    "it-coin4",          // PerOxyd item 0x13
    0,                   // PerOxyd item 0x14 key
    0,                   // PerOxyd item 0x15 key
    0,                   // PerOxyd item 0x16 key
    "it-floppy",         // PerOxyd item 0x17
    "it-flagwhite",      // PerOxyd item 0x18
    "it-flagblack",      // PerOxyd item 0x19
    "it-soother",        // PerOxyd item 0x1a
    "it-pipe-wn",        // PerOxyd item 0x1b
    "it-pipe-sw",        // PerOxyd item 0x1c
    "it-pipe-ne",        // PerOxyd item 0x1d
    "it-pipe-es",        // PerOxyd item 0x1e
    "it-pipe-v",         // PerOxyd item 0x1f
    "it-pipe-h",         // PerOxyd item 0x20
    "it-spade",          // PerOxyd item 0x21
    0,                   // PerOxyd item 0x22 coffee maker (?)
    0,                   // PerOxyd item 0x23 spikes
    "it-seed",           // PerOxyd item 0x24
    "it-spring2",        // PerOxyd item 0x25
    "it-spring",         // PerOxyd item 0x26
    0,                   // PerOxyd item 0x27 bag
    "it-magnet",         // PerOxyd item 0x28
    "it-signal-filter0", // PerOxyd item 0x29 signal filter
    "it-signal-filter1", // PerOxyd item 0x2a signal filter
    "it-shogun-s",       // PerOxyd item 0x2b
    "it-shogun-l",       // PerOxyd item 0x2c
    "it-vortex-open",    // PerOxyd item 0x2d open hole
    "it-vortex-closed",  // PerOxyd item 0x2e closed hole
    "it-wormhole",       // PerOxyd item 0x2f
    "it-hill",           // PerOxyd item 0x30
    "it-tinyhill",       // PerOxyd item 0x31
    "it-hollow",         // PerOxyd item 0x32
    "it-tinyhollow",     // PerOxyd item 0x33
    0,                   // PerOxyd item 0x34
    0,                   // PerOxyd item 0x35
    "it-springboard",    // PerOxyd item 0x36
    0,                   // PerOxyd item 0x37
    "it-bridge-oxyd",    // PerOxyd item 0x38
    UNUSED,              // PerOxyd item 0x39
    UNUSED,              // PerOxyd item 0x3a
    UNUSED,              // PerOxyd item 0x3b
    0,                   // PerOxyd item 0x3c
    0,                   // PerOxyd item 0x3d spoon
    0,                   // PerOxyd item 0x3e rubber band
    0,                   // PerOxyd item 0x3f color changing floor
    "it-trigger",        // PerOxyd item 0x40
    "it-brush",          // PerOxyd item 0x41
    0,                   // PerOxyd item 0x42 banana
    0,                   // PerOxyd item 0x43 pencil
    "it-brake",          // PerOxyd item 0x44
    0,                   // PerOxyd item 0x45 crushed cherry
    "it-blocker",        // PerOxyd item 0x46
    "it-magicwand",      // PerOxyd item 0x47
    "it-wrench",         // PerOxyd item 0x48
    UNUSED,              // PerOxyd item 0x49
    "it-odometer",       // PerOxyd item 0x4a
    "it-puller-n",       // PerOxyd item 0x4b
    "it-puller-s",       // PerOxyd item 0x4c
    "it-puller-w",       // PerOxyd item 0x4d
    "it-puller-e",       // PerOxyd item 0x4e
    UNUSED,              // PerOxyd item 0x4f
    UNUSED,              // PerOxyd item 0x50
    0,                   // PerOxyd item 0x51 puller left, active
    UNUSED,              // PerOxyd item 0x52
    0,                   // PerOxyd item 0x53 oxyd on floor (?)
    UNUSED,              // PerOxyd item 0x54
    UNUSED,              // PerOxyd item 0x55
    UNUSED,              // PerOxyd item 0x56
    UNUSED,              // PerOxyd item 0x57
    0,                   // PerOxyd item 0x58 oxyd on floor
    0,                   // PerOxyd item 0x59 oxyd on floor
    UNUSED,              // PerOxyd item 0x5a
    UNUSED,              // PerOxyd item 0x5b
    UNUSED,              // PerOxyd item 0x5c
    UNUSED,              // PerOxyd item 0x5d
    UNUSED,              // PerOxyd item 0x5e
    UNUSED,              // PerOxyd item 0x5f
    UNUSED,              // PerOxyd item 0x60
    UNUSED,              // PerOxyd item 0x61
    UNUSED,              // PerOxyd item 0x62
    UNUSED,              // PerOxyd item 0x63
    UNUSED,              // PerOxyd item 0x64
    UNUSED,              // PerOxyd item 0x65
    UNUSED,              // PerOxyd item 0x66
    UNUSED,              // PerOxyd item 0x67
    UNUSED,              // PerOxyd item 0x68
    UNUSED,              // PerOxyd item 0x69
    0,                   // PerOxyd item 0x6a active black bomb
    UNUSED,              // PerOxyd item 0x6b
    UNUSED,              // PerOxyd item 0x6c
    UNUSED,              // PerOxyd item 0x6d
    UNUSED,              // PerOxyd item 0x6e
    UNUSED,              // PerOxyd item 0x6f
    UNUSED,              // PerOxyd item 0x70
    UNUSED,              // PerOxyd item 0x71
    UNUSED,              // PerOxyd item 0x72
    UNUSED,              // PerOxyd item 0x73
    UNUSED,              // PerOxyd item 0x74
    UNUSED,              // PerOxyd item 0x75
    "it-easymode",       // PerOxyd item 0x76
    0,                   // PerOxyd item 0x77
    0,                   // PerOxyd item 0x78
    0,                   // PerOxyd item 0x79
    // codes >= 0x7a are unused
};

// ---------------------------------------------
// OxydExtra mapping
// ---------------------------------------------

static const char *OxydExtra_floor_map[256] = {
    "fl-abyss",          // OxydExtra floor 0x00
    "fl-gray",           // OxydExtra floor 0x01
    "fl-metal",          // OxydExtra floor 0x02
    UNUSED,              // OxydExtra floor 0x03
    UNUSED,              // OxydExtra floor 0x04
    UNUSED,              // OxydExtra floor 0x05
    UNUSED,              // OxydExtra floor 0x06
    "fl-light",          // OxydExtra floor 0x07
    "fl-rough-red",      // OxydExtra floor 0x08
    "fl-rough-blue",     // OxydExtra floor 0x09
    "fl-rough-blue",     // OxydExtra floor 0x0a
    "fl-rough-red",      // OxydExtra floor 0x0b
    "fl-inverse",        // OxydExtra floor 0x0c
    "fl-black",          // OxydExtra floor 0x0d
    UNUSED,              // OxydExtra floor 0x0e
    UNUSED,              // OxydExtra floor 0x0f
    UNUSED,              // OxydExtra floor 0x10
    UNUSED,              // OxydExtra floor 0x11
    UNUSED,              // OxydExtra floor 0x12
    "fl-water",          // OxydExtra floor 0x13
    UNUSED,              // OxydExtra floor 0x14
    UNUSED,              // OxydExtra floor 0x15
    UNUSED,              // OxydExtra floor 0x16
    "fl-ice_001",        // OxydExtra floor 0x17
    UNUSED,              // OxydExtra floor 0x18
    UNUSED,              // OxydExtra floor 0x19
    UNUSED,              // OxydExtra floor 0x1a
    UNUSED,              // OxydExtra floor 0x1b
    "fl-space",          // OxydExtra floor 0x1c
    UNUSED,              // OxydExtra floor 0x1d
    UNUSED,              // OxydExtra floor 0x1e
    UNUSED,              // OxydExtra floor 0x1f
    UNUSED,              // OxydExtra floor 0x20
    UNUSED,              // OxydExtra floor 0x21
    UNUSED,              // OxydExtra floor 0x22
    UNUSED,              // OxydExtra floor 0x23
    UNUSED,              // OxydExtra floor 0x24
    "fl-gradient3",      // OxydExtra floor 0x25
    "fl-gradient4",      // OxydExtra floor 0x26
    UNUSED,              // OxydExtra floor 0x27
    UNUSED,              // OxydExtra floor 0x28
    UNUSED,              // OxydExtra floor 0x29
    UNUSED,              // OxydExtra floor 0x2a
    UNUSED,              // OxydExtra floor 0x2b
    UNUSED,              // OxydExtra floor 0x2c
    UNUSED,              // OxydExtra floor 0x2d
    UNUSED,              // OxydExtra floor 0x2e
    UNUSED,              // OxydExtra floor 0x2f
    UNUSED,              // OxydExtra floor 0x30
    "fl-gradient15",     // OxydExtra floor 0x31
    "fl-gradient16",     // OxydExtra floor 0x32
    UNUSED,              // OxydExtra floor 0x33
    "fl-rough",          // OxydExtra floor 0x34
    UNUSED,              // OxydExtra floor 0x35
    UNUSED,              // OxydExtra floor 0x36
    UNUSED,              // OxydExtra floor 0x37
    "fl-mortar",         // OxydExtra floor 0x38
    UNUSED,              // OxydExtra floor 0x39
    UNUSED,              // OxydExtra floor 0x3a
    UNUSED,              // OxydExtra floor 0x3b
    "fl-samba",          // OxydExtra floor 0x3c
    UNUSED,              // OxydExtra floor 0x3d
    UNUSED,              // OxydExtra floor 0x3e
    UNUSED,              // OxydExtra floor 0x3f
    UNUSED,              // OxydExtra floor 0x40
    "fl-samba",          // OxydExtra floor 0x41
    UNUSED,              // OxydExtra floor 0x42
    "fl-bumps",          // OxydExtra floor 0x43
    UNUSED,              // OxydExtra floor 0x44
    UNUSED,              // OxydExtra floor 0x45
    UNUSED,              // OxydExtra floor 0x46
    "fl-bumps",          // OxydExtra floor 0x47
    "fl-rock",           // OxydExtra floor 0x48
    UNUSED,              // OxydExtra floor 0x49
    UNUSED,              // OxydExtra floor 0x4a
    UNUSED,              // OxydExtra floor 0x4b
    "fl-bridge",         // OxydExtra floor 0x4c
    UNUSED,              // OxydExtra floor 0x4d
    UNUSED,              // OxydExtra floor 0x4e
    UNUSED,              // OxydExtra floor 0x4f
    UNUSED,              // OxydExtra floor 0x50
    UNUSED,              // OxydExtra floor 0x51
    UNUSED,              // OxydExtra floor 0x52
    UNUSED,              // OxydExtra floor 0x53
    "fl-gray",           // OxydExtra floor 0x54
    "fl-plank",          // OxydExtra floor 0x55
    UNUSED,              // OxydExtra floor 0x56
    UNUSED,              // OxydExtra floor 0x57
    UNUSED,              // OxydExtra floor 0x58
    "fl-trigger",        // OxydExtra floor 0x59
    UNUSED,              // OxydExtra floor 0x5a
    "fl-gravel",         // OxydExtra floor 0x5b
    // codes >= 0x5c are unused
};

static const char *OxydExtra_stone_map[256] = {
    0,                   // OxydExtra stone 0x00
    0,                   // OxydExtra stone 0x01
    0,                   // OxydExtra stone 0x02
    0,                   // OxydExtra stone 0x03
    0,                   // OxydExtra stone 0x04
    0,                   // OxydExtra stone 0x05
    0,                   // OxydExtra stone 0x06
    0,                   // OxydExtra stone 0x07
    0,                   // OxydExtra stone 0x08
    0,                   // OxydExtra stone 0x09
    0,                   // OxydExtra stone 0x0a
    0,                   // OxydExtra stone 0x0b
    0,                   // OxydExtra stone 0x0c
    0,                   // OxydExtra stone 0x0d
    0,                   // OxydExtra stone 0x0e
    0,                   // OxydExtra stone 0x0f
    0,                   // OxydExtra stone 0x10
    "st-fakeoxyd",       // OxydExtra stone 0x11
    "st-rock3",          // OxydExtra stone 0x12
    "st-rock4",          // OxydExtra stone 0x13
    UNUSED,              // OxydExtra stone 0x14
    "st-rock5",          // OxydExtra stone 0x15
    "st-rock7",          // OxydExtra stone 0x16
    UNUSED,              // OxydExtra stone 0x17
    "st-grate1",         // OxydExtra stone 0x18
    UNUSED,              // OxydExtra stone 0x19
    UNUSED,              // OxydExtra stone 0x1a
    UNUSED,              // OxydExtra stone 0x1b
    "st-marble",         // OxydExtra stone 0x1c
    UNUSED,              // OxydExtra stone 0x1d
    UNUSED,              // OxydExtra stone 0x1e
    "st-rock5",          // OxydExtra stone 0x1f
    "st-stone2",         // OxydExtra stone 0x20
    "st-rock7",          // OxydExtra stone 0x21
    "st-glass1",         // OxydExtra stone 0x22
    UNUSED,              // OxydExtra stone 0x23
    "st-rock3_break",    // OxydExtra stone 0x24
    "st-rock3_hole",     // OxydExtra stone 0x25
    "st-rock3_move",     // OxydExtra stone 0x26
    "st-wood",           // OxydExtra stone 0x27
    "st-switch",         // OxydExtra stone 0x28
    UNUSED,              // OxydExtra stone 0x29
    UNUSED,              // OxydExtra stone 0x2a
    UNUSED,              // OxydExtra stone 0x2b
    UNUSED,              // OxydExtra stone 0x2c
    "st-floppy",         // OxydExtra stone 0x2d
    UNUSED,              // OxydExtra stone 0x2e
    "st-death",          // OxydExtra stone 0x2f
    "st-death_invisible", // OxydExtra stone 0x30
    "st-oneway_black-w", // OxydExtra stone 0x31
    UNUSED,              // OxydExtra stone 0x32
    "st-oneway_black-n", // OxydExtra stone 0x33
    "st-oneway_black-s", // OxydExtra stone 0x34
    UNUSED,              // OxydExtra stone 0x35
    UNUSED,              // OxydExtra stone 0x36
    UNUSED,              // OxydExtra stone 0x37
    UNUSED,              // OxydExtra stone 0x38
    UNUSED,              // OxydExtra stone 0x39
    UNUSED,              // OxydExtra stone 0x3a
    UNUSED,              // OxydExtra stone 0x3b
    "st-actorimpulse",   // OxydExtra stone 0x3c
    UNUSED,              // OxydExtra stone 0x3d
    "st-laser-1",        // OxydExtra stone 0x3e  The laser-names are fake names!
    "st-laser-2",        // OxydExtra stone 0x3f  Direction and state are generated by Enigma.
    "st-laser-3",        // OxydExtra stone 0x40
    UNUSED,              // OxydExtra stone 0x41
    UNUSED,              // OxydExtra stone 0x42
    "st-mirror-p-",      // OxydExtra stone 0x43
    "st-mirror-p\\",     // OxydExtra stone 0x44
    UNUSED,              // OxydExtra stone 0x45
    "st-mirror-p/",      // OxydExtra stone 0x46
    UNUSED,              // OxydExtra stone 0x47
    UNUSED,              // OxydExtra stone 0x48
    UNUSED,              // OxydExtra stone 0x49
    UNUSED,              // OxydExtra stone 0x4a
    "st-mirror-p-t",     // OxydExtra stone 0x4b
    UNUSED,              // OxydExtra stone 0x4c
    "st-mirror-3>",      // OxydExtra stone 0x4d
    "st-mirror-3^",      // OxydExtra stone 0x4e
    "st-mirror-3<",      // OxydExtra stone 0x4f
    "st-mirror-3v",      // OxydExtra stone 0x50
    UNUSED,              // OxydExtra stone 0x51
    UNUSED,              // OxydExtra stone 0x52
    UNUSED,              // OxydExtra stone 0x53
    UNUSED,              // OxydExtra stone 0x54
    UNUSED,              // OxydExtra stone 0x55
    UNUSED,              // OxydExtra stone 0x56
    UNUSED,              // OxydExtra stone 0x57
    UNUSED,              // OxydExtra stone 0x58
    UNUSED,              // OxydExtra stone 0x59
    UNUSED,              // OxydExtra stone 0x5a
    UNUSED,              // OxydExtra stone 0x5b
    UNUSED,              // OxydExtra stone 0x5c
    "st-stone_break",    // OxydExtra stone 0x5d
    UNUSED,              // OxydExtra stone 0x5e
    UNUSED,              // OxydExtra stone 0x5f
    UNUSED,              // OxydExtra stone 0x60
    UNUSED,              // OxydExtra stone 0x61
    UNUSED,              // OxydExtra stone 0x62
    UNUSED,              // OxydExtra stone 0x63
    "st-coinslot",       // OxydExtra stone 0x64
    "st-thief",          // OxydExtra stone 0x65
    "st-shogun-s",       // OxydExtra stone 0x66
    UNUSED,              // OxydExtra stone 0x67
    UNUSED,              // OxydExtra stone 0x68
    UNUSED,              // OxydExtra stone 0x69
    UNUSED,              // OxydExtra stone 0x6a
    UNUSED,              // OxydExtra stone 0x6b
    UNUSED,              // OxydExtra stone 0x6c
    "st-stoneimpulse",   // OxydExtra stone 0x6d
    UNUSED,              // OxydExtra stone 0x6e
    UNUSED,              // OxydExtra stone 0x6f
    UNUSED,              // OxydExtra stone 0x70
    UNUSED,              // OxydExtra stone 0x71
    UNUSED,              // OxydExtra stone 0x72
    "st-door-h",         // OxydExtra stone 0x73
    "st-door-v",         // OxydExtra stone 0x74
    UNUSED,              // OxydExtra stone 0x75
    "st-invisible",      // OxydExtra stone 0x76
    UNUSED,              // OxydExtra stone 0x77
    UNUSED,              // OxydExtra stone 0x78
    UNUSED,              // OxydExtra stone 0x79
    UNUSED,              // OxydExtra stone 0x7a
    UNUSED,              // OxydExtra stone 0x7b
    UNUSED,              // OxydExtra stone 0x7c
    UNUSED,              // OxydExtra stone 0x7d
    UNUSED,              // OxydExtra stone 0x7e
    UNUSED,              // OxydExtra stone 0x7f
    UNUSED,              // OxydExtra stone 0x80
    UNUSED,              // OxydExtra stone 0x81
    UNUSED,              // OxydExtra stone 0x82
    UNUSED,              // OxydExtra stone 0x83
    UNUSED,              // OxydExtra stone 0x84
    UNUSED,              // OxydExtra stone 0x85
    UNUSED,              // OxydExtra stone 0x86
    UNUSED,              // OxydExtra stone 0x87
    UNUSED,              // OxydExtra stone 0x88
    UNUSED,              // OxydExtra stone 0x89
    "st-blue-sand",      // OxydExtra stone 0x8a
    "st-bluegray",       // OxydExtra stone 0x8b
    UNUSED,              // OxydExtra stone 0x8c
    UNUSED,              // OxydExtra stone 0x8d
    UNUSED,              // OxydExtra stone 0x8e
    UNUSED,              // OxydExtra stone 0x8f
    UNUSED,              // OxydExtra stone 0x90
    UNUSED,              // OxydExtra stone 0x91
    UNUSED,              // OxydExtra stone 0x92
    UNUSED,              // OxydExtra stone 0x93
    UNUSED,              // OxydExtra stone 0x94
    UNUSED,              // OxydExtra stone 0x95
    UNUSED,              // OxydExtra stone 0x96
    UNUSED,              // OxydExtra stone 0x97
    UNUSED,              // OxydExtra stone 0x98
    UNUSED,              // OxydExtra stone 0x99
    UNUSED,              // OxydExtra stone 0x9a
    UNUSED,              // OxydExtra stone 0x9b
    UNUSED,              // OxydExtra stone 0x9c
    UNUSED,              // OxydExtra stone 0x9d
    "st-turnstile",      // OxydExtra stone 0x9e
    "st-turnstile-n",    // OxydExtra stone 0x9f
    "st-turnstile-s",    // OxydExtra stone 0xa0
    "st-turnstile-w",    // OxydExtra stone 0xa1
    "st-turnstile-e",    // OxydExtra stone 0xa2
    UNUSED,              // OxydExtra stone 0xa3
    "st-fakeoxyd",       // OxydExtra stone 0xa4
    UNUSED,              // OxydExtra stone 0xa5
    UNUSED,              // OxydExtra stone 0xa6
    UNUSED,              // OxydExtra stone 0xa7
    UNUSED,              // OxydExtra stone 0xa8
    UNUSED,              // OxydExtra stone 0xa9
    UNUSED,              // OxydExtra stone 0xaa
    UNUSED,              // OxydExtra stone 0xab
    UNUSED,              // OxydExtra stone 0xac
    UNUSED,              // OxydExtra stone 0xad
    UNUSED,              // OxydExtra stone 0xae
    UNUSED,              // OxydExtra stone 0xaf
    UNUSED,              // OxydExtra stone 0xb0
    UNUSED,              // OxydExtra stone 0xb1
    UNUSED,              // OxydExtra stone 0xb2
    UNUSED,              // OxydExtra stone 0xb3
    UNUSED,              // OxydExtra stone 0xb4
    UNUSED,              // OxydExtra stone 0xb5
    UNUSED,              // OxydExtra stone 0xb6
    UNUSED,              // OxydExtra stone 0xb7
    UNUSED,              // OxydExtra stone 0xb8
    UNUSED,              // OxydExtra stone 0xb9
    UNUSED,              // OxydExtra stone 0xba
    "st-stoneimpulse-hollow", // OxydExtra stone 0xbb
    // codes >= 0xbc are unused
};

static const char *OxydExtra_item_map[256] = {
    0,                   // OxydExtra item 0x00
    "it-extralife",      // OxydExtra item 0x01
    "it-document",       // OxydExtra item 0x02
    "it-document",       // OxydExtra item 0x03
    "it-hammer",         // OxydExtra item 0x04
    "it-coffee",         // OxydExtra item 0x05
    "it-cherry",         // OxydExtra item 0x06
    "it-umbrella",       // OxydExtra item 0x07
    0,                   // OxydExtra item 0x08
    UNUSED,              // OxydExtra item 0x09
    "it-dynamite",       // OxydExtra item 0x0a
    UNUSED,              // OxydExtra item 0x0b
    UNUSED,              // OxydExtra item 0x0c
    "it-crack0",         // OxydExtra item 0x0d
    "it-crack1",         // OxydExtra item 0x0e
    "it-crack2",         // OxydExtra item 0x0f
    "it-crack3",         // OxydExtra item 0x10
    "it-coin1",          // OxydExtra item 0x11
    "it-coin2",          // OxydExtra item 0x12
    "it-coin4",          // OxydExtra item 0x13
    0,                   // OxydExtra item 0x14
    0,                   // OxydExtra item 0x15
    "it-key",            // OxydExtra item 0x16
    "it-floppy",         // OxydExtra item 0x17
    UNUSED,              // OxydExtra item 0x18
    UNUSED,              // OxydExtra item 0x19
    UNUSED,              // OxydExtra item 0x1a
    UNUSED,              // OxydExtra item 0x1b
    UNUSED,              // OxydExtra item 0x1c
    UNUSED,              // OxydExtra item 0x1d
    UNUSED,              // OxydExtra item 0x1e
    UNUSED,              // OxydExtra item 0x1f
    UNUSED,              // OxydExtra item 0x20
    "it-spade",          // OxydExtra item 0x21
    "it-surprise",       // OxydExtra item 0x22
    0,                   // OxydExtra item 0x23
    UNUSED,              // OxydExtra item 0x24
    UNUSED,              // OxydExtra item 0x25
    UNUSED,              // OxydExtra item 0x26
    "it-bag",            // OxydExtra item 0x27
    UNUSED,              // OxydExtra item 0x28
    UNUSED,              // OxydExtra item 0x29
    "it-sensor",         // OxydExtra item 0x2a
    "it-shogun-s",       // OxydExtra item 0x2b
    UNUSED,              // OxydExtra item 0x2c
    "it-vortex-open",    // OxydExtra item 0x2d
    UNUSED,              // OxydExtra item 0x2e
    "it-wormhole",       // OxydExtra item 0x2f
    "it-hill",           // OxydExtra item 0x30
    "it-tinyhill",       // OxydExtra item 0x31
    "it-hollow",         // OxydExtra item 0x32
    "it-tinyhollow",     // OxydExtra item 0x33
    UNUSED,              // OxydExtra item 0x34
    UNUSED,              // OxydExtra item 0x35
    UNUSED,              // OxydExtra item 0x36
    "it-bridge-oxyd",    // OxydExtra item 0x37
    UNUSED,              // OxydExtra item 0x38
    UNUSED,              // OxydExtra item 0x39
    UNUSED,              // OxydExtra item 0x3a
    UNUSED,              // OxydExtra item 0x3b
    0,                   // OxydExtra item 0x3c
    UNUSED,              // OxydExtra item 0x3d
    UNUSED,              // OxydExtra item 0x3e
    UNUSED,              // OxydExtra item 0x3f
    "it-trigger",        // OxydExtra item 0x40
    "it-brush",          // OxydExtra item 0x41
    0,                   // OxydExtra item 0x42
    // codes >= 0x43 are unused
};

namespace enigma_mapping {
    Mapping::Mapping(OxydVersion version)
        : floor_map(0)
        , item_map(0)
        , stone_map(0)
    {
        switch (version) {
            case OxydVersion_Oxyd1:
                floor_map = Oxyd1_floor_map;
                item_map  = Oxyd1_item_map;
                stone_map = Oxyd1_stone_map;
                break;
            case OxydVersion_OxydMagnum:
            case OxydVersion_OxydMagnumGold:
                floor_map = OxydMagnum_floor_map;
                item_map  = OxydMagnum_item_map;
                stone_map = OxydMagnum_stone_map;
                break;
            case OxydVersion_PerOxyd:
                floor_map = PerOxyd_floor_map;
                item_map  = PerOxyd_item_map;
                stone_map = PerOxyd_stone_map;
                break;
            case OxydVersion_OxydExtra:
                floor_map = OxydExtra_floor_map;
                item_map  = OxydExtra_item_map;
                stone_map = OxydExtra_stone_map;
                break;
            default :
                assert(0);
                break;
        }
    }
}
