//  ======================================================================== //
//                                                                           //
//    File      : enigma_mapping.h                                           //
//    Purpose   :                                                            //
//    Time-stamp: <Wed Jun/25/2003 19:42 MET amgine@reallysoft.de>           //
//                                                                           //
//    (C) May 2003 by Ralf Westram <amgine@rallysoft.de>                     //
//                                                                           //
//    Permission to use, copy, modify, distribute and sell this software     //
//    and its documentation for any purpose is hereby granted without fee,   //
//    provided that the above copyright notice appear in all copies and      //
//    that both that copyright notice and this permission notice appear      //
//    in supporting documentation.                                           //
//                                                                           //
//    Ralf Westram makes no representations about the suitability of this    //
//    software for any purpose.  It is provided "as is" without express or   //
//    implied warranty.                                                      //
//                                                                           //
//  ======================================================================== //

#ifndef ENIGMA_MAPPING_H
#define ENIGMA_MAPPING_H

namespace enigma_mapping {

    class Mapping {
        const char **floor_map;
        const char **item_map;
        const char **stone_map;

        Mapping(const Mapping&);
        Mapping& operator= (const Mapping&);
    public:
        Mapping(OxydLib::OxydVersion version);

        const char* floorName(int idx) const { return floor_map[idx]; }
        const char* itemName(int idx) const { return item_map[idx]; }
        const char* stoneName(int idx) const { return stone_map[idx]; }
    };
}

#else
#error enigma_mapping.h included twice
#endif // ENIGMA_MAPPING_H

