/*
 * Copyright (C) 2002,2003 Daniel Heck
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: lua.hh,v 1.5 2003/06/15 10:38:19 dheck Exp $
 */
#ifndef LUA_HH
#define LUA_HH

#include <string>
#include <vector>
#include <exception>
#include "enigma.hh"
#include "px/geom.hh"

extern "C" {
#include <lua.h>
}

namespace lua
{
    extern lua_State *state;

    struct CFunction {
        lua_CFunction func;
        const char *name;

    };

    
    int FindDataFile (lua_State *L);

    // Register the C functions in `funcs'.  The end of the array is
    // denoted by an entry with func==0.
    void RegisterFuncs (CFunction funcs[]);

    /* Call a Lua function with one argument.  This is mainly used for
       callbacks during the game. */
    int CallFunc(const char *funcname, const enigma::Value& arg);

    int Dofile(const std::string & filename);
    int Dobuffer (const std::vector<char> &luacode);
    int DoSubfolderfile(const std::string & basefolder, const std::string & filename);

    void Init();
    void Shutdown();
}

#endif
