#-------------------------------------------------------------------------------
#  
#  enable.om package test case.  
#  
#  Written by: David C. Morrill
#  
#  Date: 02/09/2005
#  
#  (c) Copyright 2005 by Enthought, Inc.
#  
#-------------------------------------------------------------------------------
    
#-------------------------------------------------------------------------------
#  Imports:  
#-------------------------------------------------------------------------------

from enthought.enable                import *
from enthought.enable.wx             import Window 
from enthought.enable.om             import *
from enthought.enable.drawing_canvas import *

from enthought.traits.api                import *
from enthought.traits.ui.api             import *

import wx

#-------------------------------------------------------------------------------
#  Constants:  
#-------------------------------------------------------------------------------

component_style   = OMOuterComponentStyle( 
                        image = '=component_l7_r13_t7_b13_%d.png' )
component_style_2 = OMOuterComponentStyle( 
                        image = '=component2_%d.png' )
component_style_3 = OMOuterComponentStyle( 
#                        image = '=blue_t4_l4_r10_b10_%d.png' )
                        image = '=newblue_l0_r5_t8_b7_%d.png' )
component_style_4 = OMOuterComponentStyle( 
                        aspect_ratio = 1.0,
                        image        = '=white_t4_l4_r10_b10_%d.png' )
component_style_5 = OMOuterComponentStyle( 
                        image = '=white_component_%d.png' )

#-------------------------------------------------------------------------------
#  'ComponentHandler' class:  
#-------------------------------------------------------------------------------

class ComponentHandler ( Handler ):
    
    def init ( self, info ):
        window = wx.Frame( None, -1, 'enable.om Test' )
        ew     = Window( window, component = Scrolled( info.object ) )
        window.SetDimensions( 10, 10, 800, 900 )
        window.Show()
        
        return True
        
#-------------------------------------------------------------------------------
#  Build a component:  
#-------------------------------------------------------------------------------
                
def build_component ( x = 10, y = 10, dx = 200, dy = 200, 
                      contacts        = 4, 
                      label           = 'Contact ',
                      style           = None, 
                      comp_style      = component_style,
                      tracks          = [ 'left', 'right' ],
                      contact_spacing = 3,
                      group_spacing   = 3,
                      margin          = 0,
                      group           = False,
                      selected        = False,
                      image           = '=contact',
                      inner           = None ):
    cm        = OMTrackContactManager()
    component = OMComponent( 
        origin          = ( x, y ),
        outer_component = OMOuterComponent( style = comp_style ),
        contact_manager = cm,
        selected        = selected )
    if inner is not None:
        component.inner_component = inner
    for position in tracks:
        cm.add_tracks( OMTrack( position        = position,
                                left_margin     = margin, 
                                right_margin    = margin,
                                group_spacing   = group_spacing,
                                contact_spacing = contact_spacing ) )
    for i in range( contacts ):
        if label == ' ':
            clabel = ''
        else:
            clabel = label + str( i + 1 )
        contact = OMContact( label = clabel,
                             image = image )
        if style is not None:
            contact.style = style
        if group:
            contact.group = str( i % 4 ) 
        cm.add_contacts( contact )
    cm.layout_contacts( dx, dy )
    return component
        
#-------------------------------------------------------------------------------
#  Test case:  
#-------------------------------------------------------------------------------

canvas          = OMCanvas( bounds       = ( 0, 0, 2500, 1500 ),
                            min_width    = 2500, 
                            min_height   = 1500,
                            grid_width   = 16,
                            grid_height  = 16,
                            snap_to_grid = True )
contact_style   = OMContactStyle( label_position = 'inside center' )
contact_style_2 = OMContactStyle( label_position = 'inside left' )
for i in range( 3 ):
    canvas.add( build_component( 
                    x        = 230 * i + 10,
                    dy       = 100,
                    contacts = 2 * (i + 1),
                    inner    = OMLabel( text  = 'Chip %d' % (i + 1),
                                        image = '=text.png',
                                        image_position = 'top center' ) ) )
                    
for i in range( 3 ):
    canvas.add( build_component( 
                    x        = 220 * i + 10,
                    y        = 130,
                    dx       = 170,
                    dy       = 250,
                    contacts = 6 * i + 2,
                    group    = True,
                    image    = '=contact_red',
                    style    = contact_style ) )
for i in range( 3 ):
    canvas.add( build_component( 
                    x          = 220 * i + 10,
                    y          = 400,
                    dx         = 10,
                    dy         = 10,
                    contacts   = 6 * i + 2,
                    label      = 'Inner ',
                    style      = contact_style_2,
                    margin     = 3,
                    comp_style = component_style_2,
                    tracks     = [ 'inner left', 'inner right' ] ))
for i in range( 3 ):
    canvas.add( build_component( 
                    x          = 60 * i + 10,
                    y          = 460,
                    dx         = 10,
                    dy         = 10,
                    contacts   = 6 * i + 2,
                    label      = '',
                    image      = '=contact_black',
                    margin     = 3,
                    style      = contact_style,
                    comp_style = component_style_3 ) )
for i in range( 3 ):
    canvas.add( build_component( 
                    x          = 120 * i + 300,
                    y          = 550,
                    dx         = 10,
                    dy         = 10,
                    contacts   = 6 * i + 2,
                    label      = '',
                    image      = '=contact_black',
                    margin     = 3,
                    style      = contact_style,
                    comp_style = component_style_3,
                    inner      = OMLabel( text  = 'Chip %d' % (i + 1),
                                          image = 'gear.png',
                                          image_position = 'top center' ) ) )
                    
for i in range( 3 ):
    canvas.add( build_component( 
                    x               = 60 * i + 10,
                    y               = 560,
                    dx              = 10,
                    dy              = 10,
                    contacts        = 6 * i + 2,
                    label           = '',
                    image           = '=red_cross',
                    margin          = 3,
                    style           = contact_style,
                    comp_style      = component_style_3 ) )
for i in range( 3 ):
    canvas.add( build_component( 
                    x               = 60 * i + 10,
                    y               = 660,
                    dx              = 10,
                    dy              = 10,
                    contacts        = 6 * i + 2,
                    label           = '',
                    image           = '=blue_cross',
                    margin          = 3,
                    contact_spacing = 6,
                    style           = contact_style,
                    comp_style      = component_style_4 ) )
for i in range( 3 ):
    canvas.add( build_component( 
                    x               = 195,
                    y               = 510 + 30 * i * i,
                    dx              = None,
                    dy              = None,
                    contacts        = 6 * i + 2,
                    label           = ' ',
                    image           = '=blue_cross',
                    margin          = 3,
                    contact_spacing = 6,
                    style           = contact_style,
                    comp_style      = component_style_4 ) )
for i in range( 3 ):
    canvas.add( build_component(
                    x               = 120 * i + 300,
                    y               = 660,
                    dx              = 10,
                    dy              = 10,
                    contacts        = 6 * i + 2,
                    label           = '',
                    image           = '=blue_cross',
                    margin          = 3,
                    contact_spacing = 6,
                    style           = contact_style,
                    comp_style      = component_style_5,
                    inner           = OMLabel( text  = 'Chip %d' % (i + 1),
                                               image = 'gear.png',
                                               image_position = 'bottom center')))
                                 
canvas.configure_traits( 
    view = View( handler = ComponentHandler() )
)
                         
