from enthought.enable               import Component
from enthought.enable.enable_traits import red_color_trait

class ColorCycler ( Component ):
    
    __traits__ = { 'color': red_color_trait }
    
    def __init__ ( self, **traits ):
        self.event_state = 'red'
        Component.__init__( self, **traits )
    
    def red_left_up ( self, event ):
        self.event_state = self.color = 'green'
        self.redraw()
    
    def green_left_up ( self, event ):
        self.event_state = self.color = 'blue'
        self.redraw()
    
    def blue_left_up ( self, event ):
        self.event_state = self.color = 'red'
        self.redraw()
    
    def _draw ( self, gc ):
        gc.save_state()
        
        x, y, dx, dy = self.bounds
        
        gc.set_fill_color( self.color_ )
        gc.begin_path()
        gc.rect( x + 1.0, y + 1.0, dx - 2.0, dy - 2.0 ) 
        gc.fill_path()
            
        gc.set_stroke_color( ( 0.0, 0.0, 0.0, 1.0 ) )
        gc.set_line_width( 1.0 )
        gc.begin_path()
        gc.rect( x + 0.5, y + 0.5, dx - 1.0, dy - 1.0 )
        gc.stroke_path()

        gc.restore_state()

