#-----------------------------------------------------------------------------
#
#  Copyright (c) 2006 by Enthought, Inc.
#  All rights reserved.
#
#  Author: Greg Rogers
#
#-----------------------------------------------------------------------------

from enthought.traits.api import HasTraits, Str

class MyModel(HasTraits):
    
    name = Str

    ###########################################################################
    ### HasTraits interface
    ###########################################################################
    
    def trait_view(self, name=None, view_element=None):
        """ Returns a View """
        if (name or view_element) != None:
            return super(MyModel, self).trait_view( name=name, 
                                                view_element=view_element )
        
        from my_model_view import MyModelView
        return MyModelView()

    def trait_context ( self ):
        """ Returns the default context to use for editing/configuring traits.
        """
        # Add handler specific state to the edit context.
        from my_model_handler import HandlerModel

        # Note: can't use '_' in context keys.
        context = { 'object': self,
                    'handlermodel': HandlerModel() }

        return context
    
    ###########################################################################
    ### MyModel event handlers
    ###########################################################################

    def _name_changed(self, old, new):
        print 'MyModel._name_changed:', self, 'old:', old, 'new:', new
        return

### EOF

    