#------------------------------------------------------------------------------
# Copyright (c) 2005, Enthought, Inc.
# All rights reserved.
# 
# This software is provided without warranty under the terms of the BSD
# license included in enthought/LICENSE.txt and may be redistributed only
# under the conditions described in the aforementioned license.  The license
# is also available online at http://www.enthought.com/licenses/BSD.txt
# Thanks for using Enthought open source!
#
# Author: Lyn Pierce
# Date: 7/11/2005
# Description: Define a function show_me() that allows the user to experiment 
#              with various trait/editor/initial value combinations.
#------------------------------------------------------------------------------

from enthought.traits.api \
    import HasTraits
    
from enthought.traits.ui.api \
    import View, Group, Item

#------------------------------------------------------------------------------
# Function: ed_demo_factory( trait, edr )
#------------------------------------------------------------------------------

def ed_demo_factory ( trait, edr ):
    """ Create a class with trait 'trait' and a view displaying editor 'edr'.
    """

    class EdDemo ( HasTraits ):
        """ This class is defined at runtime with a specified trait and editor.
        
        This class contains a trait attribute of the specified type and a
        display specification for showing the four styles of the given editor
        when applied to that trait type.
        """

        # Two traits are defined at runtime: the editor to be demonstrated
        # and the trait that the editor will display.
        ed = edr
        f1 = trait

        #----------------------------------------------------------------------
        # This group contains the one field of the class four times, once
        # for each style of the editor.  view1 allows the result to be used by
        # the edit_traits() function as a display description.
        #
        # [Editor specifications appear to be ignored if 'grp' is
        #  specified outside of edDemo.  Investigate. (LP)]
        #----------------------------------------------------------------------


        grp = Group( Group("15", Item('f1', editor=ed), "15", style="simple", 
                           label="Simple", show_border=True),
                     Group(" "),
                     Group("15", Item('f1', editor=ed), "15", style="custom", 
                           label="Custom", show_border=True),
                     Group(" "),
                     Group("15", Item('f1', editor=ed), "15", style="text", 
                           label="Text", show_border=True),
                     Group(" "),
                     Group("15", Item('f1', editor=ed), "15", style="readonly", 
                           label="Read Only", show_border=True)
                     ) 

        view1 = View( grp )

    return EdDemo()


#------------------------------------------------------------------------------
# function showMe( trait, edr=None, value=None )
#------------------------------------------------------------------------------

def show_me( trait, edr=None, value=None ):
    """ Show how editor 'edr' appears when applied to a trait of type 'trait'.

    Demonstrate the use of the four styles of editor "edr" on a Trait of 
    type "trait".  The optional "value" keyword argument may be used to specify 
    an initial value.

    """
    
    # Create an object with the appropriate trait attribute and display spec.
    edit1 = ed_demo_factory(trait, edr)
 
    # If an initial value is specified, assign it to the trait attribute.
    if value != None:
        edit1.f1 = value
    
    # Display the editor demo dialogue in wizard form.
    edit1.configure_traits( kind="wizard" )

    return
