#ifndef __ENODE_KV_H__
#define __ENODE_KV_H__

/***********************************************************
 *	 Arbitrary key/value Attachment
 **********************************************************/

/* This is used to attach arbitrary data to a node for later use. Data
 * attached in this manner is not saved in any way.  I'm pretty sure this
 * should only be used by renderers.  Also note that the string arguments
 * here are replaced with generic pointers in C implementation.  To be used
 * only if you know what you are doing! */

/* Set a value in a node */
void enode_set_kv (ENode * node, gchar * key, gpointer value);

/* Get a set value */
gpointer enode_get_kv (ENode * node, gchar * key);


/* (old documentation.. still of some use probably */
/* used to store arbitrary information for a node.  This can be used to hold
 * eg. GTK widgets and other things that you need to keep track of.  For gtk
 * widget renderers, we are currently using "top-widget" and "bottom-widget"
 * to point to the top and bottom widgets of the tree.  Anything specific to
 * the tag shoudl be prefixed by the tag.  eg "app-ebox-widget". */



#endif				/* __ENODE_KV_H__ */


