#include <gtk/gtk.h>
#include <stdlib.h>
#include "entity.h"
#include "gtk-common.h"
#include "gtk-widget-attr.h"

/*--element

Element Name: <label>

Creates a text label in the appropriate place.

%widget%

*/

static gint
rendgtk_label_set_text_attr (ENode * node, EBuf * attr, EBuf * value)
{
    GtkWidget *label;

    label = enode_get_kv (node, "top-widget");
    if (!label)
	return (TRUE);

    gtk_label_set_text (GTK_LABEL (label), value->str);

    return (TRUE);
}

static gint
rendgtk_label_set_justify_attr (ENode * node, EBuf * attr, EBuf * value)
{
    GtkWidget *label;

    label = enode_get_kv (node, "top-widget");

    if (!label)
	return (TRUE);

    if (ebuf_equal_str (value, "left")) {
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
	return (TRUE);
    }

    if (ebuf_equal_str (value, "right")) {
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
	return (TRUE);
    }

    if (ebuf_equal_str (value, "fill")) {
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_FILL);
	return (TRUE);
    }

    /* center is the catchall/default */
    gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_CENTER);
    return (TRUE);
}


static void
rendgtk_label_render (ENode * node)
{
    GtkWidget *label;
    gchar *text = NULL;

    text = enode_attrib_str (node, "text", NULL);

    label = gtk_label_new (text);

    enode_set_kv (node, "top-widget", label);
    enode_set_kv (node, "bottom-widget", label);

    rendgtk_show_cond (node, label);

    enode_attribs_sync (node);
}

static gint
rendgtk_label_set_linewrap (ENode * node, EBuf * attr, EBuf * value)
{
    GtkWidget *label;

    label = enode_get_kv (node, "top-widget");
    if (!label)
        return (TRUE);

    gtk_label_set_line_wrap (GTK_LABEL (label), erend_value_is_true (value));
    EDEBUG (("label-renderer", "Line wrap is %s", value->str));
    return (TRUE);

}

void
label_renderer_register (void)
{
    Element *element;
    ElementAttr *e_attr;

    /* labels */
    element = g_malloc0 (sizeof (Element));
    element->render_func = rendgtk_label_render;
    element->destroy_func = rendgtk_element_destroy;
    element->parent_func = NULL;
    element->tag = "label";
    element->description = "Create a simple label widget.";
    element_register (element);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "text";
    e_attr->description = "Set label text.";
    e_attr->value_desc = "string";
    e_attr->set_attr_func = rendgtk_label_set_text_attr;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "linewrap";
    e_attr->description =
        "Sets the word wrapping method for the label widget";
    e_attr->value_desc = "boolean";
    e_attr->possible_values = "false,true";
    e_attr->set_attr_func = rendgtk_label_set_linewrap;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "justify";
    e_attr->description = "Set label justification.";
    e_attr->value_desc = "choice";
    e_attr->possible_values = "center,right,left,fill";
    e_attr->set_attr_func = rendgtk_label_set_justify_attr;
    element_register_attrib (element, e_attr);

    rendgtk_widget_attr_register (element, GTK_TYPE_LABEL);
}
