/***************************************************************************
 *   Copyright (C) 2006, 2007 by Niklas Knutsson                           *
 *   nq@altern.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "eqonomizemonthselector.h"

#include <qobject.h>
#include <qlayout.h>
#include <kglobal.h>
#include <klocale.h>
#include <kcalendarsystem.h>
#include <kcombobox.h>
#include <qspinbox.h>

EqonomizeMonthSelector::EqonomizeMonthSelector(QWidget *parent) : QWidget(parent) {
	const KCalendarSystem *calSys = KGlobal::locale()->calendar();
	d_date = QDate::currentDate();
	calSys->setYMD(d_date, calSys->year(d_date), calSys->month(d_date), 1);
	QHBoxLayout *layout = new QHBoxLayout(this, 0, 6);
	monthCombo = new KComboBox(this);
	monthCombo->setEditable(false);
	layout->addWidget(monthCombo);
	yearEdit = new QSpinBox(calSys->minValidYear(), calSys->maxValidYear(), 1, this);
	yearEdit->setValue(calSys->year(d_date));
	layout->addWidget(yearEdit);
	updateMonths();
	monthCombo->setCurrentItem(calSys->month(d_date) - 1);
	connect(yearEdit, SIGNAL(valueChanged(int)), this, SLOT(onYearChanged(int)));
	connect(monthCombo, SIGNAL(activated(int)), this, SLOT(onMonthChanged(int)));
}
EqonomizeMonthSelector::~EqonomizeMonthSelector() {}
		
QDate EqonomizeMonthSelector::date() const {return d_date;}

void EqonomizeMonthSelector::onYearChanged(int year) {
	const KCalendarSystem *calSys = KGlobal::locale()->calendar();
	calSys->setYMD(d_date, year, calSys->month(d_date), 1);
	updateMonths();
	emit yearChanged(d_date);
	emit dateChanged(d_date);
}
void EqonomizeMonthSelector::onMonthChanged(int month) {
	const KCalendarSystem *calSys = KGlobal::locale()->calendar();
	calSys->setYMD(d_date, calSys->year(d_date), month + 1, 1);
	emit monthChanged(d_date);
	emit dateChanged(d_date);
}

void EqonomizeMonthSelector::setDate(const QDate &newdate) {
	const KCalendarSystem *calSys = KGlobal::locale()->calendar();
	if(newdate.isValid()) {
		calSys->setYMD(d_date, calSys->year(newdate), calSys->month(newdate), 1);
		yearEdit->blockSignals(true);
		yearEdit->setValue(calSys->year(newdate));
		yearEdit->blockSignals(false);
		monthCombo->blockSignals(true);
		updateMonths();
		monthCombo->setCurrentItem(calSys->month(d_date) - 1);
		monthCombo->blockSignals(false);
	}
}

void EqonomizeMonthSelector::updateMonths() {
	const KCalendarSystem *calSys = KGlobal::locale()->calendar();
	int months = calSys->monthsInYear(d_date);
	int year = calSys->year(d_date);
	monthCombo->blockSignals(true);
	if(monthCombo->count() != 12 || KGlobal::locale()->calendarType() != "gregorian") {
		monthCombo->clear();
		for(int i = 1; i <= months; i++) {
			monthCombo->insertItem(calSys->monthName(i, year));
		}
		monthCombo->setCurrentItem(calSys->month(d_date) - 1);
	}
	monthCombo->blockSignals(false);
}
	
void EqonomizeMonthSelector::focusMonth() {monthCombo->setFocus();}
void EqonomizeMonthSelector::focusYear() {yearEdit->setFocus();}
	
#include "eqonomizemonthselector.moc"
