/***************************************************************************
 *   Copyright (C) 2006, 2007 by Niklas Knutsson                           *
 *   nq@altern.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef TRANSACTION_EDIT_WIDGET_H
#define TRANSACTION_EDIT_WIDGET_H

#include <qvaluevector.h>
#include <knuminput.h>
#include <qwidget.h>
#include <qdict.h>
#include <transaction.h>
#include <kdialogbase.h>

class Budget;
class Account;
class KLineEdit;
class EqonomizeValueEdit;
class KDateEdit;
class KComboBox;
class QPushButton;
class QLabel;
class QCheckBox;

typedef enum {
	SECURITY_ALL_VALUES,
	SECURITY_SHARES_AND_QUOTATION,
	SECURITY_VALUE_AND_SHARES,
	SECURITY_VALUE_AND_QUOTATION
} SecurityValueDefineType;

class TransactionEditWidget : public QWidget {

	Q_OBJECT
	
	public:

		TransactionEditWidget(bool auto_edit, bool extra_parameters, int transaction_type, bool split, bool transfer_to, Security *security, SecurityValueDefineType security_value_type, bool select_security, Budget *budg, QWidget *parent = 0, const char *name = 0);
		void setTransaction(Transaction *trans);
		void setScheduledTransaction(ScheduledTransaction *strans, const QDate &date);
		void updateFromAccounts(Account *exclude_account = NULL);
		void updateToAccounts(Account *exclude_account = NULL);
		void updateAccounts(Account *exclude_account = NULL);
		void transactionsReset();
		void setCurrentToItem(int index);
		void setCurrentFromItem(int index);
		void setAccount(Account *account);
		int currentToItem();
		int currentFromItem();
		void focusDescription();
		QWidget *bottomWidget();
		void transactionRemoved(Transaction *trans);
		void transactionAdded(Transaction *trans);
		void transactionModified(Transaction *trans);
		bool modifyTransaction(Transaction *trans);
		Transaction *createTransaction();
		bool validValues(bool ask_questions = false);
		QDate date();
		Security *selectedSecurity();
		void setMaxShares(double max);
		void setMaxSharesDate(QDate quotation_date);
		bool checkAccounts();
		void currentDateChanged(const QDate &olddate, const QDate &newdate);
	
	protected:

		QDict<Transaction> default_values;
		int transtype;
		bool description_changed;
		Budget *budget;
		Security *security;
		bool b_autoedit, b_sec, b_extra;
		bool value_set, shares_set, sharevalue_set;
		QDate shares_date;
		
		QValueVector<Account*> froms, tos;
		KLineEdit *descriptionEdit, *commentsEdit, *payeeEdit;
		KComboBox *fromCombo, *toCombo, *securityCombo;
		EqonomizeValueEdit *valueEdit, *sharesEdit, *quotationEdit, *quantityEdit;
		QPushButton *maxSharesButton;
		KDateEdit *dateEdit;
		QWidget *bottom_widget;

	signals:

		void addmodify();
		void dateChanged(const QDate&);

	public slots:

		void valueChanged(double);
		void securityChanged();
		void sharesChanged(double);
		void quotationChanged(double);
		void descriptionChanged(const QString&);
		void setDefaultValue();
		void maxShares();
		
};

class TransactionEditDialog : public KDialogBase {

	Q_OBJECT

	public:

		TransactionEditDialog(bool extra_parameters, int transaction_type, bool split, bool transfer_to, Security *security, SecurityValueDefineType security_value_type, bool select_security, Budget *budg, QWidget *parent);
		TransactionEditWidget *editWidget;

	protected slots:

		void slotOk();
		
};

class MultipleTransactionsEditDialog : public KDialogBase {

	Q_OBJECT
	
	public:

		MultipleTransactionsEditDialog(bool extra_parameters, int transaction_type, Budget *budg, QWidget *parent = 0, const char *name = 0);
		void setTransaction(Transaction *trans);
		void setScheduledTransaction(ScheduledTransaction *strans, const QDate &date);
		void updateAccounts();
		bool modifyTransaction(Transaction *trans);
		bool validValues();
		bool checkAccounts();
		QDate date();

		QCheckBox *descriptionButton, *valueButton, *categoryButton, *dateButton, *payeeButton;
	
	protected:

		int transtype;
		Budget *budget;
		bool b_extra;
		QValueVector<Account*> categories;
		KLineEdit *descriptionEdit, *payeeEdit;
		KComboBox *categoryCombo;
		EqonomizeValueEdit *valueEdit;
		KDateEdit *dateEdit;

	protected slots:

		void slotOk();
		
};


#endif

