/* Ergo, version 3.2, a program for linear scaling electronic structure
 * calculations.
 * Copyright (C) 2012 Elias Rudberg, Emanuel H. Rubensson, and Pawel Salek.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Primary academic reference:
 * Kohn−Sham Density Functional Theory Electronic Structure Calculations 
 * with Linearly Scaling Computational Time and Memory Usage,
 * Elias Rudberg, Emanuel H. Rubensson, and Pawel Salek,
 * J. Chem. Theory Comput. 7, 340 (2011),
 * <http://dx.doi.org/10.1021/ct100611z>
 * 
 * For further information about Ergo, see <http://www.ergoscf.org>.
 */

#include "monomial_info.h"
#include <assert.h>


monomial_info_struct::monomial_info_struct()
{
  // first get count
  int count = 0;
  for(int n1 = 0; n1 <= MONOMIAL_N_MAX; n1++)
    {
      for(int n1x = 0; n1x <= n1; n1x++)
	for(int n1y = 0; n1y <= n1; n1y++)
	  for(int n1z = 0; n1z <= n1; n1z++)
	    {
	      if(n1x+n1y+n1z != n1)
		continue;
	      count++;
	    } /* END FOR n1x n1y n1z */
    } /* END FOR n1 */
  
  noOfMonomialsTot = count;
  monomial_list = new monomial_struct[noOfMonomialsTot];
  
  count = 0;
  for(int n1 = 0; n1 <= MONOMIAL_N_MAX; n1++)
    {
      for(int n1x = 0; n1x <= n1; n1x++)
	for(int n1y = 0; n1y <= n1; n1y++)
	  for(int n1z = 0; n1z <= n1; n1z++)
	    {
	      if(n1x+n1y+n1z != n1)
		continue;
	      assert(count < noOfMonomialsTot);
	      monomial_list[count].ix = n1x;
	      monomial_list[count].iy = n1y;
	      monomial_list[count].iz = n1z;
	      monomial_index_list[n1x][n1y][n1z] = count;
	      count++;
	    } /* END FOR n1x n1y n1z */
      no_of_monomials_list[n1] = count;
    } /* END FOR n1 */
  assert(count == noOfMonomialsTot);
}


monomial_info_struct::~monomial_info_struct()
{
  delete []monomial_list;
}

