# -*- coding: utf-8 -*-
#
# This module contains the configuration of the individual eric installation
#

import sys
import os

__ericDir = os.path.dirname(sys.argv[0])

_pkg_config = {
    'ericDir'             : __ericDir,
    'ericPixDir'          : os.path.join(__ericDir, 'pixmaps'),
    'ericIconDir'         : os.path.join(__ericDir, 'icons'),
    'ericDTDDir'          : os.path.join(__ericDir, 'DTDs'),
    'ericDocDir'          : os.path.join(__ericDir, 'Documentation'),
    'ericExamplesDir'     : os.path.join(__ericDir, 'Examples'),
    'ericTranslationsDir' : os.path.join(__ericDir, 'i18n'),
    'ericWizardsDir'      : os.path.join(__ericDir, 'Wizards'),
    'ericTemplatesDir'    : os.path.join(__ericDir, 'DesignerTemplates'),
    'ericOthersDir'       : __ericDir,
    'bindir'              : __ericDir,
    'mdir'                : __ericDir,
}

def getConfig(name):
    '''
    Module function to get a configuration value.

    @param name the name of the configuration value (string).
    '''
    try:
        return _pkg_config[name]
    except KeyError:
        pass

    raise AttributeError, '"%s" is not a valid configuration value' % name
