# -*- coding: utf-8 -*-

# Copyright (c) 2002 - 2005 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module defining configuration variables for the VCS package
"""

from qt import qApp, QStringList

# Available version control systems
ConfigVcsSystems = ['None', 'CVS', 'Mercurial', 'Subversion']

# Display strings for the available version control systems
# This list must be kept in sync with the one above.
ConfigVcsSystemsDisplay = QStringList()
ConfigVcsSystemsDisplay.append(qApp.translate('VCS Systems', 'None'))
ConfigVcsSystemsDisplay.append(qApp.translate('VCS Systems', 'CVS'))
ConfigVcsSystemsDisplay.append(qApp.translate('VCS Systems', 'Mercurial'))
ConfigVcsSystemsDisplay.append(qApp.translate('VCS Systems', 'Subversion'))

# List of indicators (directory or file) for a specific
# version control system.
ConfigVcsSystemIndicators = [('CVS','CVS'),
                             ('Mercurial', '.hg'),
                             ('Subversion', '.svn'), 
]

# List of VCS that support login/logout functionality    
ConfigVcsAuthSystems = ['CVS']
