# -*- coding: utf-8 -*-

# Copyright (c) 2005 - 2006 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog for entering a single template variable.
"""

from qt import *

from TemplateSingleVariableForm import TemplateSingleVariableForm


class TemplateSingleVariableDialog(TemplateSingleVariableForm):
    """
    Class implementing a dialog for entering a single template variable.
    """
    def __init__(self, variable, parent = None):
        """
        Constructor
        
        @param variable template variable name (string)
        @param parent parent widget of this dialog (QWidget)
        """
        TemplateSingleVariableForm.__init__(self, parent, None, 1)
        
        self.dummy = self.trUtf8("Dummy")
        
        self.variableLabel.setText(variable)

    def getVariable(self):
        """
        Public method to get the value for the variable.
        
        @return value for the template variable (string)
        """
        return unicode(self.variableEdit.text())
