# -*- coding: utf-8 -*-

# Copyright (c) 2002-2006 Detlev Offenbach <detlev@die-offenbachs.de>
#
# This is the uninstall script for eric3.

"""
Uninstallation script for the eric3 IDE and all eric3 related tools.
"""

import sys
import os
import string
import shutil
import glob
import distutils.sysconfig

from eric3config import getConfig

# Define the globals.
progName = None
pyModDir = None

def usage(rcode = 2):
    """Display a usage message and exit.

    rcode is the return code passed back to the calling process.
    """
    global progName

    print "Usage:"
    print "    %s [-h]" % (progName)
    print "where:"
    print "    -h             display this help message"

    sys.exit(rcode)


def initGlobals():
    """
    Sets the values of globals that need more than a simple assignment.
    """
    global pyModDir

    pyModDir = distutils.sysconfig.get_python_lib()


def wrapperName(dname,wfile):
    """Create the platform specific name for the wrapper script.
    """
    if sys.platform == "win32":
        wname = dname + "\\" + wfile + ".bat"
    else:
        wname = dname + "/" + wfile

    return wname


def uninstallEric():
    """
    Uninstall the eric files.
    """
    global pyModDir
    
    # Remove the wrapper scripts
    rem_wnames = ["eric3", "eric3-unittest", "eric3-helpviewer",
        "eric3-doc", "eric3-qregexp", "eric3-re", "eric3-api",
        "eric3-uipreviewer", "eric3-trpreviewer",
        "qtunittest", "helpviewer"]
    for rem_wname in rem_wnames:
        rwname = wrapperName(getConfig('bindir'),rem_wname)
        if os.path.exists(rwname):
            os.remove(rwname)
    
    # Cleanup our config file
    for name in ['eric3config.py', 'eric3config.pyc']:
        e3cfile = os.path.join(pyModDir, name)
        if os.path.exists(e3cfile):
            os.remove(e3cfile)
        
    # Cleanup the install directories
    for name in ['ericExamplesDir', 'ericDocDir', 'ericDTDDir', 'ericCSSDir',
                 'ericIconDir', 'ericPixDir', 'ericDir', 'ericTemplatesDir',
                 'ericOthersDir']:
        try:
            shutil.rmtree(getConfig(name), 1)
        except:
            pass
    
    # Cleanup translations
    for name in glob.glob(os.path.join(getConfig('ericTranslationsDir'), 'eric3_*.qm')):
        try:
            os.remove(name)
        except:
            pass
    
def main(argv):
    """The main function of the script.

    argv is the list of command line arguments.
    """
    import getopt

    initGlobals()

    # Parse the command line.
    global progName
    progName = os.path.basename(argv[0])

    try:
        optlist, args = getopt.getopt(argv[1:],"h")
    except getopt.GetoptError:
        usage()

    global platBinDir

    for opt, arg in optlist:
        if opt == "-h":
            usage(0)
    
    uninstallEric()
    
    
if __name__ == "__main__":
    try:
        main(sys.argv)
    except SystemExit:
        raise
    except:
        print \
"""An internal error occured.  Please report all the output of the program,
including the following traceback, to eric-bugs@die-offenbachs.de.
"""
        raise
